create PROCEDURE PERF_WITHIN_HOUR AS 
  pdate VARCHAR2(10);
  ndate VARCHAR2(10);
  today VARCHAR2(10);
  actualhour NUMBER;
  actualmin NUMBER;
  actualsec NUMBER;
  shift VARCHAR2(2);
  sdate DATE;
  dateto VARCHAR2(20);
  datefrom VARCHAR2(20);
  dateto4 VARCHAR2(20);
  datefrom4 VARCHAR2(20);
  dateto3 VARCHAR2(20);
  datefrom3 VARCHAR2(20);
  
  sum_target NUMBER;
  sum_fact NUMBER;
  actual_ship_result NUMBER;
  nowcount NUMBER;
  temp INTEGER;
  
  last_sum_target NUMBER;
  last_sum_fact NUMBER;
  last_actual_ship_result NUMBER;
  perf_within_hour ANDON_INNER_PERFORMANCE%ROWTYPE;
  
  job_running VARCHAR(1);
  
  
CURSOR andoncounter IS
 SELECT prod_line, sysdate, NVL(yield_qty,0) as QTY FROM ANDON_COUNTER
      WHERE TO_CHAR(affacted_hour, 'YYYY-MM-DD HH24')=TO_CHAR(sysdate, 'YYYY-MM-DD HH24');
      
CURSOR shiftresult(dateTO VARCHAR2, dateFROM VARCHAR2, line_name VARCHAR2) IS
  SELECT to_char(ac.AFFACTED_HOUR,'HH24') as AH, ac.TARGET_QTY as TARGET,ac.YIELD_QTY as QTY, ac.HOUR_COMMENT as HC FROM ANDON_COUNTER ac 
    WHERE ac.PROD_LINE=line_name AND ac.AFFACTED_HOUR between to_date(dateTO,'YYYY-MM-DD HH24:MI:SS') and to_date(dateFROM,'YYYY-MM-DD HH24:MI:SS')
    ORDER BY AC.AFFACTED_HOUR;
    
CURSOR last_inner_perf (line_name VARCHAR2) IS
    SELECT SHIFT_RESULT,SHIFT_EXPECT,SHIFT_ACTUAL
    FROM ANDON_INNER_PERFORMANCE WHERE LINE=line_name AND PREF_DATE=(SELECT DATATYPE_DATE FROM ANDON_CONFIG WHERE PROPERITY='LAST_PREF_WITHIN_HOUR');

/* Ismert hibak, feladatok

  - Muszakvaltaskor a DIFF elcsuszik
  - a DIFF kiválasztásakor probléma lehet, ha nincs elöz¿ adat
*/

BEGIN

 SELECT UPPER(DATATYPE_VARCHAR) into job_running from ANDON_CONFIG WHERE properity='PREF_WITHIN_HOUR_RUN';
 
 IF job_running='Y' THEN
  GOTO proc_exit;
 END IF;

 UPDATE ANDON_CONFIG SET DATATYPE_VARCHAR='Y' WHERE properity='PREF_WITHIN_HOUR_RUN';
 COMMIT;

 sdate:=sysdate;
 pdate:=TO_CHAR(sysdate-1,'YYYY-MM-DD');
 today:=TO_CHAR(sysdate,'YYYY-MM-DD');
 ndate:=TO_CHAR(sysdate+1,'YYYY-MM-DD');
 actualhour:=TO_NUMBER(to_char(sdate,'HH24'));
 actualmin:=TO_NUMBER(to_char(sdate,'MI'));
 actualsec:=(actualmin*60)+TO_NUMBER(to_char(sdate,'SS'));
 
	IF actualhour<6 THEN
		dateto3:=pdate||' 22:00:00';
		datefrom3:=today||' 05:59:59';
  END IF;
	IF actualhour>5 and actualhour<14 THEN
		dateto3:=today||' 06:00:00';
		datefrom3:=today||' 13:59:59';
  END IF;
  IF actualhour>13 and actualhour<22 THEN
		dateto3:=today||' 14:00:00';
		datefrom3:=today||' 21:59:59';
	END IF;
	IF actualhour>21 THEN
		dateto3:=today||' 22:00:00';
		datefrom3:=ndate||' 05:59:59';
	END IF;
  
  IF actualhour<6 THEN
		dateto4:=pdate||' 18:00:00';
		datefrom4:=today||' 05:59:59';
	END IF;
	IF actualhour>=6 and actualhour<18 THEN
		dateto4:=today||' 06:00:00';
		datefrom4:=today||' 17:59:59';
	END IF;
	IF actualhour>=18 THEN
		dateto4:=today||' 18:00:00';
		datefrom4:=ndate||' 05:59:59';
	END IF;
	
  
  FOR AC IN andoncounter LOOP
    SELECT GET_SHIFTMODELL(AC.prod_line) INTO shift from dual;
    IF shift=3 THEN 
      dateto:=dateto3;
      datefrom:=datefrom3;
    END IF;
    IF shift=4 THEN
      dateto:=dateto4;
      datefrom:=datefrom4;
    END IF;
    
    actual_ship_result:=0;
    sum_target:=0;
    sum_fact:=0;
    nowcount:=1;
    FOR SR IN  shiftresult(dateto,datefrom,AC.prod_line) LOOP
      IF SR.AH=actualhour AND SR.TARGET>0 THEN
        temp:=SR.TARGET*(actualsec/3600); -- temp is INTEGER, this is the INTVAL :)
     
        sum_target:=sum_target+temp;
        /*IF(AC.prod_line='ECL_G4') THEN
        DBMS_OUTPUT.put_line('actualsec: '||actualsec);
        DBMS_OUTPUT.put_line('SR.TARGET: '||SR.TARGET);
        DBMS_OUTPUT.put_line('(actualsec/3600): '||round((actualsec/3600)));
        DBMS_OUTPUT.put_line('SR.TARGET*(actualsec/3600)): '||round(SR.TARGET*(actualsec/3600)));
        END IF;*/
        sum_fact:=sum_fact+SR.QTY;
        nowcount:=0;
      END IF;
      IF SR.AH=actualhour THEN
        nowcount:=0;
      END IF;
      IF nowcount>0 AND SR.TARGET>0 THEN
        sum_target:=sum_target+SR.TARGET;
        sum_fact:=sum_fact+SR.QTY;
      END IF;
     /* IF(AC.prod_line='ECL_G4') THEN
       DBMS_OUTPUT.put_line(SR.AH || '-' || sum_fact || '-' || sum_target || '-');
      END IF;*/
    END LOOP;
    actual_ship_result:=sum_fact-sum_target;
    --DBMS_OUTPUT.put_line(AC.prod_line || '-' || sum_fact || '-' || sum_target || '-' ||  actual_ship_result);
    
    FOR LR IN last_inner_perf(AC.prod_line) LOOP
      last_actual_ship_result:=LR.SHIFT_RESULT;
      last_sum_target:=LR.SHIFT_EXPECT;
      last_sum_fact:=LR.SHIFT_ACTUAL;
    END LOOP;
     
    perf_within_hour.LINE:=AC.prod_line;
    perf_within_hour.PREF_DATE:=sdate;
    perf_within_hour.YIELD_QTY:=AC.QTY;
    perf_within_hour.SHIFT_RESULT:=actual_ship_result;
    perf_within_hour.SHIFT_EXPECT:=sum_target;
    perf_within_hour.SHIFT_ACTUAL:=sum_fact;
    perf_within_hour.DIFF_SHIFT_RESULT:=actual_ship_result-last_actual_ship_result;
    perf_within_hour.DIFF_SHIFT_EXPECT:=sum_target-last_sum_target;
    perf_within_hour.DIFF_SHIFT_ACTUAL:=sum_fact-last_sum_fact;
    
    INSERT INTO ANDON_INNER_PERFORMANCE VALUES perf_within_hour;
    
  END LOOP;
  
  UPDATE ANDON_CONFIG SET DATATYPE_DATE=sdate WHERE PROPERITY= 'LAST_PREF_WITHIN_HOUR';
  UPDATE ANDON_CONFIG SET DATATYPE_VARCHAR='N' WHERE PROPERITY='PREF_WITHIN_HOUR_RUN';
  
  <<proc_exit>>
   NULL;
   
END PERF_WITHIN_HOUR;
/

