create PACKAGE car_sbmvV_1_2_1_RC_b4 IS

  -- Author  : EUGEN
  -- Created : 28.08.2007 10:39:41

  ----- Tables for data input -------------------------------------------------
  -- storage for Carrier Id of destination carrier
  TYPE t_car_id_dest_tbl IS TABLE OF t_car.car_id%TYPE INDEX BY BINARY_INTEGER;
  car_id_dest_tbl t_car_id_dest_tbl;

  -- storage for Carrier Id  Type of destination carrier
  TYPE t_car_id_type_dest_tbl IS TABLE OF t_car.car_id_type%TYPE INDEX BY BINARY_INTEGER;
  car_id_type_dest_tbl t_car_id_type_dest_tbl;

  -- storage for Carrier Type of destination carrier
  TYPE t_car_type_dest_tbl IS TABLE OF t_car.car_type%TYPE INDEX BY BINARY_INTEGER;
  car_type_dest_tbl t_car_type_dest_tbl;

  -- storage for position Id in destination carrier
  TYPE t_pos_id_tbl IS TABLE OF t_car_subunit.pos_id%TYPE INDEX BY BINARY_INTEGER;
  pos_id_tbl t_pos_id_tbl;

  TYPE t_pos_x_tbl IS TABLE OF t_car_subunit.pos_x%TYPE INDEX BY BINARY_INTEGER;
  pos_x_tbl t_pos_x_tbl;

  TYPE t_pos_y_tbl IS TABLE OF t_car_subunit.pos_y%TYPE INDEX BY BINARY_INTEGER;
  pos_y_tbl t_pos_y_tbl;

  TYPE t_pos_z_tbl IS TABLE OF t_car_subunit.pos_z%TYPE INDEX BY BINARY_INTEGER;
  pos_z_tbl t_pos_z_tbl;

  -- storage for subunits Ids
  TYPE t_subunit_id_tbl IS TABLE OF t_car_subunit.subunit_id%TYPE INDEX BY BINARY_INTEGER;
  subunit_id_tbl t_subunit_id_tbl;

  -- storage for subunits Id types
  TYPE t_subunit_id_type_tbl IS TABLE OF t_car_subunit.subunit_id_type%TYPE INDEX BY BINARY_INTEGER;
  subunit_id_type_tbl t_subunit_id_type_tbl;

  -- storage for Number of user strings for  subunit
  TYPE t_u_sub_each_tbl IS TABLE OF PLS_INTEGER INDEX BY BINARY_INTEGER;
  u_sub_each_tbl t_u_sub_each_tbl;

  -- storage for control flags (insert or update of user string)
  TYPE t_u_control_tbl IS TABLE OF VARCHAR2(20) INDEX BY BINARY_INTEGER;
  u_control_tbl t_u_control_tbl;

  -- storage for user string indexes
  TYPE t_u_sub_idx_tbl IS TABLE OF PLS_INTEGER INDEX BY BINARY_INTEGER;
  u_sub_idx_tbl t_u_sub_idx_tbl;

  -- storage for user strings values
  TYPE t_u_sub_tbl IS TABLE OF t_car_user_string.ud_str_00%TYPE INDEX BY BINARY_INTEGER;
  u_sub_tbl t_u_sub_tbl;
  -----------------------------------------------------------------------------
  FUNCTION get_val(p_str VARCHAR2) RETURN VARCHAR2;

  PROCEDURE c_car_move_wrap(p_base_id t_car.base_id%TYPE, p_in_operator t_car.operator%TYPE, p_in_user_comment t_car.user_comment%TYPE,
                            p_now t_car.updated%TYPE, p_now_sub t_car.updated_sub%TYPE, p_mode_handle_error PLS_INTEGER, p_errcod IN OUT SMALLINT,
                            p_errmsg IN OUT VARCHAR2);

  --function to_number_f(val varchar2) return number;

  ------------------- bind  functions --------------------
  PROCEDURE init_arrays;
  PROCEDURE bind_car_id_dest_tbl(val VARCHAR2);
  PROCEDURE bind_car_id_type_dest_tbl(val VARCHAR2);
  PROCEDURE bind_car_type_dest_tbl(val VARCHAR2);
  PROCEDURE bind_pos_id_tbl(val VARCHAR2);
  PROCEDURE bind_pos_x_tbl(val INT);
  PROCEDURE bind_pos_y_tbl(val INT);
  PROCEDURE bind_pos_z_tbl(val INT);
  PROCEDURE bind_subunit_id_tbl(val VARCHAR2);
  PROCEDURE bind_subunit_id_type_tbl(val VARCHAR2);
  PROCEDURE bind_u_sub_each_tbl(val INT);
  PROCEDURE bind_u_control_tbl(val VARCHAR2);
  PROCEDURE bind_u_sub_idx_tbl(val INT);
  PROCEDURE bind_u_sub_tbl(val VARCHAR2);
  --------------------------------------------------------

  --*********************************************************************************
  -- for version control
  FUNCTION get_version_label RETURN VARCHAR2;
  --********************************************************************************

  FUNCTION get_ud_log_id(p_user_str_descript NUMBER) RETURN NUMBER;

END car_sbmvV_1_2_1_RC_b4;
/

