create PACKAGE BODY car_sbmvV_1_2_1_RC_b4 IS
  -------------- types ------------------------------------------------------------------
  -- for unique valus control
  TYPE t_hash_values_tbl IS TABLE OF PLS_INTEGER INDEX BY VARCHAR2(100);
  ---------------- errors ---------------------------------------------------------------
  BASE_ERROR_NUMBER CONSTANT INT := -19000;
  /*
  oracle user_errors must be in the range of -20000 to -20999;
  that's why carma_errors must be in range -1999 to -1000
  */
  ERROR_IN_PLSQL_PROCEDURE      CONSTANT INT := -1103; -- AP_CAR_API_CAR_SUB_MOVE__ERROR_IN_PLSQL_PROCEDURE
  DEST_CARRIER_IS_LOCKED        CONSTANT INT := -1104; -- AP_CAR_API_CAR_SUB_MOVE__DEST_CARRIER_IS_LOCKED
  SRC_CARRIER_IS_LOCKED         CONSTANT INT := -1105; -- AP_CAR_API_CAR_SUB_MOVE__SRC_CARRIER_IS_LOCKED
  SUBUNIT_IS_LOCKED             CONSTANT INT := -1106; -- AP_CAR_API_CAR_SUB_MOVE__SUBUNIT_IS_LOCKED
  CANNOT_CREATE_NEW_DST_CARRIER CONSTANT INT := -1107; -- AP_CAR_API_CAR_SUB_MOVE__CANNOT_CREATE_NEW_DST_CARRIER
  CANNOT_FIND_FREE_POSITION     CONSTANT INT := -1108; -- AP_CAR_API_CAR_SUB_MOVE__CANNOT_FIND_FREE_POSITION
  ANOTHER_SUBUNIT_IN_DST_POS    CONSTANT INT := -1109; -- AP_CAR_API_CAR_SUB_MOVE__ANOTHER_SUBUNIT_IN_DST_POS
  SRC_CARRIER_NOT_FOUND         CONSTANT INT := -1110; -- AP_CAR_API_CAR_SUB_MOVE__SRC_CARRIER_NOT_FOUND
  SUBUNIT_NOT_FOUND             CONSTANT INT := -1111; -- AP_CAR_API_CAR_SUB_MOVE__SUBUNIT_NOT_FOUND
  NO_DATA_FOUND_FOR_CAR_TYPE    CONSTANT INT := -1112; -- AP_CAR_API_CAR_SUB_MOVE__NO_DATA_FOUND_FOR_CAR_TYPE
  BAD_MODE_HANDLE_ERROR_VALUE   CONSTANT INT := -1114; -- AP_CAR_API_CAR_SUB_MOVE__BAD_MODE_HANDLE_ERROR_VALUE
  SRC_CAR_TYPE_IS_LOCKED        CONSTANT INT := -1197; -- AP_CAR_API_CAR_SUB_MOVE__SRC_CAR_TYPE_IS_LOCKED
  DST_CAR_TYPE_IS_LOCKED        CONSTANT INT := -1198; -- AP_CAR_API_CAR_SUB_MOVE__DST_CAR_TYPE_IS_LOCKED
  DST_CAR_TYPE_REQUIRED         CONSTANT INT := -1199; -- AP_CAR_API_CAR_SUB_MOVE__DST_CAR_TYPE_REQUIRED
  ---------------------------------------------------------------------------------------

  hash_values_tbl t_hash_values_tbl;

  --------------- constants -------------------------------------------------------------
  AUTO_CREATE_CAR_DESC          CONSTANT VARCHAR2(30) := 'Autocreated carrier';
  TRANSACTION_TYPE_SU_MOVE      CONSTANT VARCHAR2(30) := 'Move_subunit';
  TRANSACTION_TYPE_SU_MOVE_SELF CONSTANT VARCHAR2(30) := 'Move_subunit_self'; -- car_source==car_destination
  TRANSACTION_TYPE_CAR_CREATE   CONSTANT VARCHAR2(30) := 'Create_carrier';

  UPDATE_MODE_UPDATE CONSTANT VARCHAR2(20) := 'U';
  UPDATE_MODE_INSERT CONSTANT VARCHAR2(20) := 'I';
  MAGIC_STRING       CONSTANT VARCHAR2(2) := '#*';
  -------------- variables --------------------------------------------------------------
  car_dst_tbl_lock car_typesV_1_2_1_RC_b4.t_car_tbl;
  car_src_tbl_lock car_typesV_1_2_1_RC_b4.t_car_tbl;

  subunits_tbl      car_typesV_1_2_1_RC_b4.t_subunit_tbl;
  subunits_tbl_lock car_typesV_1_2_1_RC_b4.t_subunit_tbl;
  -- new values of user_strings
  user_str_tbl            car_typesV_1_2_1_RC_b4.t_usr_str_tbl;
  user_strings_table_lock car_typesV_1_2_1_RC_b4.t_user_strings_table;

  --------------------- version control ------------------------------------------------
  FUNCTION get_version_label RETURN VARCHAR2 IS
  BEGIN
    RETURN '$Name:  $';
  END get_version_label;

  -- unique control ---------------------------------------------------
  PROCEDURE reset_unique_control IS
  BEGIN
    hash_values_tbl.DELETE;
  END reset_unique_control;

  PROCEDURE add_unique_key(p_val VARCHAR2) IS
    hash_val_str VARCHAR2(100);
  BEGIN
    /*
    if car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO then
      car_typesV_1_2_1_RC_b4.put_log_record('Procedure  ''add_unique_key''. Calculate hash_value for:' || car_typesV_1_2_1_RC_b4.SEP || '<' ||
                                     p_val || '>');
    end if;
    */

    SELECT to_char(ora_hash(p_val)) INTO hash_val_str FROM dual;
    hash_values_tbl(hash_val_str) := 1;
  END;

  FUNCTION is_value_unique(p_val VARCHAR2) RETURN BOOLEAN IS
    hash_val_str VARCHAR2(100);
    res          BOOLEAN;
    i            PLS_INTEGER;
  BEGIN

    /*
    if car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO then
      car_typesV_1_2_1_RC_b4.put_log_record('Procedure  ''is_value_unique''. Calculate hash_value for:' || car_typesV_1_2_1_RC_b4.SEP || '<' ||
                                     p_val || '>');
    end if;
    */

    SELECT to_char(ora_hash(p_val)) INTO hash_val_str FROM dual;

    BEGIN
      i   := hash_values_tbl(hash_val_str);
      res := FALSE;
    EXCEPTION
      WHEN no_data_found THEN
        res := TRUE;

    END;

    RETURN res;

  END is_value_unique;
  ---------------------------------------------------------------------------------------

  ------------------------ print_object_function for logging ----------------------------

  FUNCTION print_carrier_short(header VARCHAR2, p_base_id VARCHAR2, p_car_id VARCHAR2, p_car_id_type VARCHAR2, p_transaction_type VARCHAR2,
                               p_car_type VARCHAR2, p_description_short VARCHAR2, p_pos_max PLS_INTEGER) RETURN VARCHAR2 IS
    res_str VARCHAR2(32000);
  BEGIN
    res_str := header || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'base_id                         =' || p_base_id || car_typesV_1_2_1_RC_b4.SEP ||
               car_typesV_1_2_1_RC_b4.TAB || 'car_id                          =' || p_car_id || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'car_id_type                     =' || p_car_id_type || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'transaction_type                     =' || p_transaction_type || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'car_type                        =' || p_car_type || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'description_short               =' ||
               p_description_short || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'pos_max                         =' || to_char(nvl(p_pos_max, 0));

    RETURN res_str;
  END print_carrier_short;

  FUNCTION print_subunit_record(header VARCHAR2, p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) RETURN VARCHAR2 IS
    res_str VARCHAR2(32000);
  BEGIN
    res_str := header || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'subunit_id:             ' || p_subunit_rec.subunit_id || car_typesV_1_2_1_RC_b4.SEP ||
               car_typesV_1_2_1_RC_b4.TAB || 'subunit_id_type:        ' || p_subunit_rec.subunit_id_type || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'new_pos_id:             ' || p_subunit_rec.new_pos_id || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'su_lock_descript:       ' ||
               p_subunit_rec.su_lock_descript || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'su_exists_flag:         ' ||
               p_subunit_rec.su_exists_flag || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'dst_car_id:             ' || p_subunit_rec.dst_car_id ||
               car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'dst_car_id_type:        ' || p_subunit_rec.dst_car_id_type || car_typesV_1_2_1_RC_b4.SEP ||
               car_typesV_1_2_1_RC_b4.TAB || 'dst_car_type:           ' || p_subunit_rec.dst_car_type || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'dst_car_lock_descript:  ' || p_subunit_rec.dst_car_lock_descript || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'dst_car_pos_max:        ' || p_subunit_rec.dst_car_pos_max || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'old_pos_id:             ' ||
               p_subunit_rec.old_pos_id || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'src_car_id:             ' || p_subunit_rec.src_car_id ||
               car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'src_car_id_type:        ' || p_subunit_rec.src_car_id_type || car_typesV_1_2_1_RC_b4.SEP ||
               car_typesV_1_2_1_RC_b4.TAB || 'src_car_lock_descript:  ' || p_subunit_rec.src_car_lock_descript || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'user_str_descript:      ' || p_subunit_rec.user_str_descript || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'u_control:              ' || p_subunit_rec.u_control || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'u_sub_each:             ' ||
               p_subunit_rec.u_sub_each;

    RETURN res_str;
  END print_subunit_record;

  FUNCTION print_subunit_update_stmt(p_header VARCHAR2, p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec, p_operator t_car.operator%TYPE,
                                     p_user_comment t_car.user_comment%TYPE, p_updated t_car.updated%TYPE, p_updated_sub t_car.updated_sub%TYPE,
                                     p_with_poz_xyz BOOLEAN) RETURN VARCHAR2 IS
    res_str VARCHAR2(32000);
  BEGIN
    res_str := p_header || car_typesV_1_2_1_RC_b4.SEP || 'update t_car_subunit set' || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'car_id       =' ||
               p_subunit_rec.dst_car_id || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'car_id_type  =' || p_subunit_rec.dst_car_id_type ||
               car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'car_type     =' || p_subunit_rec.dst_car_type || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'user_str_descript = ' || to_char(p_subunit_rec.user_str_descript) || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'operator     =' ||
               p_operator || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'user_comment =' || p_user_comment || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
               'updated =' || p_updated || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'updated_sub =' || p_updated_sub || car_typesV_1_2_1_RC_b4.SEP ||
               car_typesV_1_2_1_RC_b4.TAB || 'pos_id       =' || to_char(p_subunit_rec.new_pos_id) || car_typesV_1_2_1_RC_b4.SEP;
    IF p_with_poz_xyz THEN
      res_str := res_str || car_typesV_1_2_1_RC_b4.TAB || 'pos_x        =' || p_subunit_rec.pos_x || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
                 'pos_y        =' || p_subunit_rec.pos_y || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'pos_z        =' || p_subunit_rec.pos_z ||
                 car_typesV_1_2_1_RC_b4.SEP;
    END IF;
    res_str := res_str || car_typesV_1_2_1_RC_b4.TAB || 'updated      =' || to_char(car_typesV_1_2_1_RC_b4.carma_core_control.now, 'dd.mm.yyyy') || car_typesV_1_2_1_RC_b4.SEP ||
               'where subunit_id = ' || p_subunit_rec.subunit_id || ' and ' || car_typesV_1_2_1_RC_b4.SEP || 'subunit_id_type = ' ||
               p_subunit_rec.subunit_id_type;

    RETURN res_str;
  END print_subunit_update_stmt;

  FUNCTION get_ud_log_id(p_user_str_descript NUMBER) RETURN NUMBER IS
    res NUMBER;
  BEGIN
    BEGIN
      SELECT ud_log_id
      INTO   res
      FROM   (SELECT ud_log_id FROM t_car_us_str_log WHERE user_str_descript = p_user_str_descript ORDER BY updated DESC, updated_sub DESC)
      WHERE  rownum = 1;
      /* Dan ToDo: use normal logging here */
      dbms_output.put_line(res);

    EXCEPTION
      WHEN no_data_found THEN
        res := 0;
    END;

    RETURN res;

  END get_ud_log_id;

  FUNCTION get_errcod(p_errcod SMALLINT) RETURN SMALLINT IS
    v_errcod SMALLINT := 0;
  BEGIN
    IF p_errcod != 0 THEN
      IF p_errcod >= -20999
         AND p_errcod <= -20000 THEN
        v_errcod := abs(p_errcod - BASE_ERROR_NUMBER);
      ELSE
        v_errcod := abs(ERROR_IN_PLSQL_PROCEDURE);
      END IF;
    END IF;
    RETURN v_errcod;

  END get_errcod;

  PROCEDURE put_error_record(p_rec_idx INT, p_retval INT, p_errcod SMALLINT, p_errmsg VARCHAR2) IS
    err_idx  INT;
    v_errcod SMALLINT;
  BEGIN
    car_typesV_1_2_1_RC_b4.error_tbl.EXTEND;
    v_errcod := get_errcod(p_errcod);
    err_idx := car_typesV_1_2_1_RC_b4.error_tbl.COUNT;
    car_typesV_1_2_1_RC_b4.error_tbl(err_idx).rec_idx := p_rec_idx;
    car_typesV_1_2_1_RC_b4.error_tbl(err_idx).retval := p_retval;
    IF p_retval = 0 THEN
      car_typesV_1_2_1_RC_b4.error_tbl(err_idx).errcod := -23; -- -23 /* sql-error from database */CAPS error code
    ELSE
      car_typesV_1_2_1_RC_b4.error_tbl(err_idx).errcod := 1; --CAPS  OK;
    END IF;
    car_typesV_1_2_1_RC_b4.error_tbl(err_idx).applerr := v_errcod;
    car_typesV_1_2_1_RC_b4.error_tbl(err_idx).appltxt := substr(p_errmsg, 1, 1000);
  END put_error_record;

  ------------
  -- Used in MAGIC_STRING functionality
  ------------
  FUNCTION get_val(p_str VARCHAR2) RETURN VARCHAR2 IS
  BEGIN
    IF p_str = MAGIC_STRING THEN
      RETURN NULL;
    ELSE
      RETURN p_str;
    END IF;
  END;

  FUNCTION is_car_type_locked(p_base_id t_car.base_id%TYPE, p_car_type t_car.car_type%TYPE) RETURN BOOLEAN IS
    v_lock_descript NUMBER := 0;
    v_car_type      T_CAR.CAR_TYPE%TYPE;
    v_log_message   VARCHAR2(250) := 'Check Carrier Type Lock for:base_id=<%1> car_type=<%2>';
  BEGIN
    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
      v_log_message := REPLACE(v_log_message, '%1', p_base_id);
      v_log_message := REPLACE(v_log_message, '%2', p_car_type);
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || v_log_message);
    END IF;
    BEGIN
      SELECT lock_descript, car_type
      INTO   v_lock_descript, v_car_type
      FROM   t_car_type_lock
      WHERE  base_id = p_base_id
      AND    car_type = p_car_type;
    EXCEPTION
      WHEN no_data_found THEN
        NULL;
    END;
    RETURN v_lock_descript > 0;
  END is_car_type_locked;

  FUNCTION is_car_type_locked(p_base_id t_car.base_id%TYPE, p_car_id t_car.car_id%TYPE, p_car_id_type t_car.car_id_type%TYPE) RETURN BOOLEAN IS
    v_lock_descript NUMBER := 0;
    v_car_type      T_CAR.CAR_TYPE%TYPE;
    v_log_message   VARCHAR2(250) := 'Check Carrier Type Lock for:base_id=<%1> car_id=<%2> car_id_type=<%3>';
  BEGIN
    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
      v_log_message := REPLACE(v_log_message, '%1', p_base_id);
      v_log_message := REPLACE(v_log_message, '%2', p_car_id);
      v_log_message := REPLACE(v_log_message, '%3', p_car_id_type);
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || v_log_message);
    END IF;
    BEGIN
      SELECT lock_descript, car_type
      INTO   v_lock_descript, v_car_type
      FROM   t_car_type_lock
      WHERE  base_id = p_base_id
      AND    car_type = (SELECT car_type
                         FROM   t_car
                         WHERE  base_id = p_base_id
                         AND    car_id = p_car_id
                         AND    car_id_type = p_car_id_type
                         AND    rownum < 2);
    EXCEPTION
      WHEN no_data_found THEN
        NULL;
    END;
    RETURN v_lock_descript > 0;
  END is_car_type_locked;

  /*
   check, if a loop is existing in recursions of our tree
  */
  PROCEDURE check_loop(p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) IS
    v_rec_cnt INT := 0;
  BEGIN

    IF p_subunit_rec.dst_car_id != p_subunit_rec.src_car_id
       AND p_subunit_rec.dst_car_id_type != p_subunit_rec.src_car_id_type THEN

      BEGIN

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Check loop in tree');
        END IF;

        -- try to build tree from subunit: if this raises an error - loop exists in tree
        SELECT COUNT(*)
        INTO   v_rec_cnt
        FROM   t_car_subunit
        START  WITH car_id = p_subunit_rec.subunit_id
             AND    car_id_type = p_subunit_rec.subunit_id_type
        CONNECT BY PRIOR subunit_id = car_id
            AND    PRIOR subunit_id_type = car_id_type;

      END;

    END IF;

  END check_loop;

  /*
  Looks for first free position in carrier. Position number (in DB type varchar2) will be interpreted as
  number datatype.
  */
  FUNCTION get_first_free_position(p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) RETURN INT IS
    v_pos_max INT;
    v_pos_min INT;
    res       INT;
  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Enter function get_first_free_position for' ||
                                  car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'car_id:' || p_subunit_rec.dst_car_id || ' car_id_type:' ||
                                  p_subunit_rec.dst_car_id_type);
    END IF;

    SELECT nvl(MIN(car_fncV_1_2_1_RC_b4.to_number_f(pos_id)), 0), nvl(MAX(car_fncV_1_2_1_RC_b4.to_number_f(pos_id)), 0)
    INTO   v_pos_min, v_pos_max
    FROM   t_car_subunit
    WHERE  car_id = p_subunit_rec.dst_car_id
    AND    car_id_type = p_subunit_rec.dst_car_id_type;

    --1. - try to find free position below MIN assigned position
    IF v_pos_min > 1 THEN
      RETURN v_pos_min - 1;
    END IF;
    --2. - try to find free position over  MAX assigned position
    IF v_pos_max < p_subunit_rec.dst_car_pos_max
       AND v_pos_max > 0 THEN
      RETURN v_pos_max + 1;
    END IF;

    SELECT pos_max
    INTO   v_pos_max
    FROM   t_car
    WHERE  car_id = p_subunit_rec.dst_car_id
    AND    car_id_type = p_subunit_rec.dst_car_id_type;
    -- 3 - try to find free position between min and max assigned positions
    SELECT nvl(MIN(lvl), 0)
    INTO   res
    FROM   (SELECT LEVEL AS lvl FROM dual CONNECT BY LEVEL <= v_pos_max)
    WHERE  lvl > v_pos_min
    AND    NOT EXISTS (SELECT *
            FROM   t_car_subunit t
            WHERE  t.car_id = p_subunit_rec.dst_car_id
            AND    t.car_id_type = p_subunit_rec.dst_car_id_type
            AND    to_number(pos_id) = lvl);

    IF res = 0 THEN
      BEGIN
        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'MAX assigned position in this carrier <' ||
                                      to_char(v_pos_max) || '>');
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'MIN assigned position in this carrier <' ||
                                      to_char(v_pos_min) || '>');
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'MAX possible position in this carrier <' ||
                                      to_char(p_subunit_rec.dst_car_pos_max) || '>');
        END IF;
        raise_application_error(BASE_ERROR_NUMBER + CANNOT_FIND_FREE_POSITION,
                                'Cannot find free position in carrier; car_id:' || p_subunit_rec.dst_car_id || ' car_id_type:' ||
                                 p_subunit_rec.dst_car_id_type);
      END;
    END IF;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Exit get_first_free_position with value:' ||
                                  to_char(res));
    END IF;

    RETURN res;
  END get_first_free_position;

  /*
  return pos_max for given car_type and base_id;
  when no data found raises error
  */
  FUNCTION get_pos_max_for_car_type(p_base_id t_car.base_id%TYPE, p_car_type t_car.car_type%TYPE) RETURN INT IS
    v_pos_max INT := 0;
  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Define pos_max for carrier_type:' || p_car_type);
    END IF;

    SELECT /*+ CHOOSE ORDERED INDEX(n T_NODES_II) INDEX(n2a T_NODE2ATTR_III) INDEX(a T_ATTRIBUTES_II) USE_NL(n n2a a)*/
     to_number(a.at002at) AS pos_max
    INTO   v_pos_max
    FROM   t_nodes n, t_node2attr n2a, t_attributes a
    WHERE  n.c_key = (SELECT /*+ ORDERED USE_NL(a, n2a, n) */
                       n.c_key
                      FROM   t_attributes a, t_node2attr n2a, t_nodes n
                      WHERE  n2a.c_key = n.c_key
                      AND    a.a_key = n2a.a_key
                      AND    a.nodename = p_car_type || '_' || p_base_id
                      AND    a.nodetype = 'CarrierType'
                      AND    n2a.avalid_to > SYSDATE
                      AND    n2a.avalid_from <= SYSDATE
                      AND    n.nvalid_to > SYSDATE
                      AND    n.nvalid_from <= SYSDATE
                      AND    n.ntype = '0')
    AND    n.c_key = n2a.c_key
    AND    n2a.a_key = a.a_key
    AND    n.ntype = '0'
    AND    n.nvalid_to > SYSDATE
    AND    n.nvalid_from <= SYSDATE
    AND    n2a.avalid_to > SYSDATE
    AND    n2a.avalid_from <= SYSDATE;

    RETURN v_pos_max;

  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(BASE_ERROR_NUMBER + NO_DATA_FOUND_FOR_CAR_TYPE,
                              'No data found in COMAN tables for given destination carrier type; car_type:' || p_car_type);

  END get_pos_max_for_car_type;

  /*
  Creates and add new carrier to database (in case, when given in interface destination carrir not exists)
  */
  PROCEDURE add_new_car_if_need(p_base_id t_car.base_id%TYPE, p_subunit_tbl IN OUT car_typesV_1_2_1_RC_b4.t_subunit_tbl, p_rec_id INT,
                                p_in_operator t_car.operator%TYPE, p_in_user_comment t_car.user_comment%TYPE) IS

    v_pos_max         INT;
    v_new_car_id      t_car.car_id%TYPE;
    v_new_car_id_type t_car.car_id_type%TYPE;
  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                  'Enter procedure add_new_car_if_need (create new carrier)');
    END IF;

    v_pos_max         := get_pos_max_for_car_type(p_base_id, p_subunit_tbl(p_rec_id).dst_car_type);
    v_new_car_id      := p_subunit_tbl(p_rec_id).dst_car_id;
    v_new_car_id_type := p_subunit_tbl(p_rec_id).dst_car_id_type;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                  print_carrier_short('New carrier will be added with parameters:', p_base_id, v_new_car_id, v_new_car_id_type,
                                                      TRANSACTION_TYPE_CAR_CREATE, p_subunit_tbl(p_rec_id).dst_car_type, AUTO_CREATE_CAR_DESC,
                                                      v_pos_max));
    END IF;

    INSERT INTO t_car
      (base_id, car_id, car_id_type, transaction_type, car_type, description_short, description_long, pos_max, pos_actual, operator,
       user_comment, use_counter, created)
    VALUES
      (p_base_id, v_new_car_id, v_new_car_id_type, TRANSACTION_TYPE_CAR_CREATE, p_subunit_tbl(p_rec_id).dst_car_type, AUTO_CREATE_CAR_DESC,
       AUTO_CREATE_CAR_DESC, v_pos_max, 0, p_in_operator, p_in_user_comment, 0, car_typesV_1_2_1_RC_b4.carma_core_control.now);

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'New carrier is created');
    END IF;

    --------------
    -- set exists flag to 1 for all subunits, that have this carrier as desination
    FOR i IN 1 .. p_subunit_tbl.COUNT LOOP
      IF p_subunit_tbl(i).dst_car_id = v_new_car_id
         AND p_subunit_tbl(i).dst_car_id_type = v_new_car_id_type THEN
        p_subunit_tbl(i).dst_exists_flag := 1;
      END IF;
    END LOOP;

  EXCEPTION
    WHEN OTHERS THEN
      BEGIN
        raise_application_error(BASE_ERROR_NUMBER + CANNOT_CREATE_NEW_DST_CARRIER,
                                'Cannot create new dst_carrier; car_id:' || p_subunit_tbl(p_rec_id)
                                .dst_car_id || ' car_id_type:' || p_subunit_tbl(p_rec_id).dst_car_id_type || ' (reason: ' || SQLERRM || ')');
      END;

  END add_new_car_if_need;

  PROCEDURE write_subunit_log(p_log_rec t_car_subunit%ROWTYPE) IS
  BEGIN
    IF car_typesV_1_2_1_RC_b4.carma_core_control.table_logging != car_typesV_1_2_1_RC_b4.DISABLE_TABLE_LOG THEN
      BEGIN
        INSERT INTO t_car_subunit_log
          (base_id, car_id, car_id_type, pos_id, transaction_type, car_type, subunit_id, subunit_id_type, subunit_name, pos_x, pos_y, pos_z, qty,
           status, operator, user_comment, part_number, part_name, part_type, part_group, part_unit, part_revision, part_version, lock_descript,
           user_str_descript, ud_log_id, created, updated, updated_sub, deleted, deleted_sub)
        VALUES
          (p_log_rec.base_id, p_log_rec.car_id, p_log_rec.car_id_type, p_log_rec.pos_id, p_log_rec.transaction_type, p_log_rec.car_type,
           p_log_rec.subunit_id, p_log_rec.subunit_id_type, p_log_rec.subunit_name, p_log_rec.pos_x, p_log_rec.pos_y, p_log_rec.pos_z,
           p_log_rec.qty, p_log_rec.status, p_log_rec.operator, p_log_rec.user_comment, p_log_rec.part_number, p_log_rec.part_name,
           p_log_rec.part_type, p_log_rec.part_group, p_log_rec.part_unit, p_log_rec.part_revision, p_log_rec.part_version,
           p_log_rec.lock_descript, p_log_rec.user_str_descript, get_ud_log_id(p_log_rec.user_str_descript), p_log_rec.created, p_log_rec.updated,
           p_log_rec.updated_sub, p_log_rec.deleted, p_log_rec.deleted_sub);
      END;
    END IF;
  END write_subunit_log;

  -- user strings utils ----------------------------------------------------------------
  /*
  Delete content for user_string with user_str_descriptor = p_user_str_descript;
  need if u_control flag is Insert/I (all new)
  */
  PROCEDURE clear_user_string(p_user_str_descript INT) IS
    v_us_rec t_car_user_string%ROWTYPE;
  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Enter procedure clear_user_string');
    END IF;

    v_us_rec.user_str_descript := p_user_str_descript;
    v_us_rec.ud_category       := 'Subunit';
    v_us_rec.created           := car_typesV_1_2_1_RC_b4.carma_core_control.now;
    UPDATE t_car_user_string SET ROW = v_us_rec WHERE user_str_descript = p_user_str_descript;

  END clear_user_string;

  PROCEDURE write_user_string_log(p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) IS
    r              NUMBER := 0;
    v_stmt         VARCHAR2(10000);
    v_stmt_ud_strs VARCHAR2(10000);
    v_ud_log_id    NUMBER;

    FUNCTION create_ud_strs RETURN VARCHAR2 IS
      v_idx VARCHAR2(3);
    BEGIN
      v_stmt_ud_strs := NULL;
      FOR i IN 0 .. car_typesV_1_2_1_RC_b4.carma_core_control.user_str_count - 1 LOOP
        v_idx          := LPAD(to_char(i), 2, '0');
        v_stmt_ud_strs := v_stmt_ud_strs || 'UD_STR_' || v_idx || ',';
      END LOOP;
      RETURN v_stmt_ud_strs;
    END create_ud_strs;

  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                  'Enter procedure write_user_string_log for user_str_desc:' || p_subunit_rec.user_str_descript);
    END IF;
    v_stmt_ud_strs := create_ud_strs;
    v_stmt         := 'INSERT INTO t_car_us_str_log(ud_log_id, user_str_descript, ud_category,' || v_stmt_ud_strs ||
                      'created, updated, updated_sub) ' || 'SELECT :ud_log_id,user_str_descript,ud_category,' || v_stmt_ud_strs ||
                      'created, :now,:now_sub ' || 'FROM t_car_user_string WHERE user_str_descript=:us_desc';
    SELECT t_car_ud_log__ud_log_id.NEXTVAL INTO v_ud_log_id FROM dual;

    FOR i IN 1 .. user_strings_table_lock.COUNT LOOP
      IF user_strings_table_lock(i).user_str_descript = p_subunit_rec.user_str_descript THEN
        BEGIN
          IF car_typesV_1_2_1_RC_b4.carma_core_control.table_logging != car_typesV_1_2_1_RC_b4.DISABLE_TABLE_LOG THEN
            BEGIN
              EXECUTE IMMEDIATE v_stmt
                USING v_ud_log_id, car_typesV_1_2_1_RC_b4.carma_core_control.now, car_typesV_1_2_1_RC_b4.carma_core_control.now_sub, user_strings_table_lock(i).user_str_descript;
              r := SQL%ROWCOUNT;
              EXIT;
            END;
          END IF;
        END;
      END IF;
    END LOOP;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Exit write_user_string_log; add ' || r ||
                                  ' row(s)');
    END IF;

  END;

  PROCEDURE write_user_strings(p_subunit_rec IN OUT car_typesV_1_2_1_RC_b4.t_subunit_rec) IS
    v_sql_string        VARCHAR2(10000);
    v_sql_string_insert VARCHAR2(5000);
    v_sql_string_values VARCHAR2(5000);
    v_us_idx            INT;
    cur                 NUMBER;
    RESULT              NUMBER;
    new_val_usr_desc    INT;
    v_info_rec          VARCHAR2(100);
    ------------------------------------
    err_code INT;
    err_msg  VARCHAR2(1000);

  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Enter procedure write_user_strings');
    END IF;

    -- try to find user string in input data
    FOR i IN 1 .. user_str_tbl.COUNT LOOP
      IF user_str_tbl(i).subunit_id = p_subunit_rec.subunit_id
         AND user_str_tbl(i).subunit_id_type = p_subunit_rec.subunit_id_type THEN
        BEGIN

          -- build sql for user string -----------------------------------------------
          IF p_subunit_rec.user_str_descript > 0 THEN
            BEGIN
              IF p_subunit_rec.u_control = UPDATE_MODE_INSERT THEN
                clear_user_string(p_subunit_rec.user_str_descript);
              END IF;
              -- build user string (update)
              v_sql_string := 'update t_car_user_string set ';
              FOR j IN 1 .. p_subunit_rec.u_sub_each LOOP
                IF user_str_tbl(i + j - 1).us_value IS NOT NULL THEN
                  v_us_idx     := user_str_tbl(i + j - 1).us_idx;
                  v_sql_string := v_sql_string || 'ud_str_' || lpad(v_us_idx, 2, '0') || '=:' || to_char(v_us_idx) || ',';
                END IF;
              END LOOP;
              -- delete last comma
              v_sql_string := substr(v_sql_string, 1, length(v_sql_string) - 1);
              v_sql_string := v_sql_string || ' where user_str_descript=:d';

            END;
          ELSE
            -- build user string (insert)
            BEGIN
              v_sql_string_insert := 'insert into t_car_user_string(ud_category,created,';
              v_sql_string_values := 'values(''Subunit'',:created,';
              FOR j IN 1 .. p_subunit_rec.u_sub_each LOOP
                v_us_idx            := user_str_tbl(i + j - 1).us_idx;
                v_sql_string_insert := v_sql_string_insert || 'ud_str_' || lpad(v_us_idx, 2, '0') || ',';
                v_sql_string_values := v_sql_string_values || ':' || to_char(v_us_idx) || ',';
              END LOOP;
              -- add user_str_descript
              v_sql_string_insert := v_sql_string_insert || 'user_str_descript) ';
              v_sql_string_values := v_sql_string_values || ' :d)';
              v_sql_string        := v_sql_string_insert || v_sql_string_values;
            END;
          END IF; -- build sql for user string ----------------------------------------

          IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
            car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Sql_string: ' || v_sql_string);
          END IF;

          cur := dbms_sql.open_cursor;
          dbms_sql.parse(cur, v_sql_string, dbms_sql.NATIVE);

          IF instr(lower(v_sql_string), 'insert') > 0 THEN
            IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
              car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Bind variable :created');
            END IF;
            dbms_sql.bind_variable(cur, ':created', car_typesV_1_2_1_RC_b4.carma_core_control.now);
          END IF;

          FOR j IN 1 .. p_subunit_rec.u_sub_each LOOP
            BEGIN
              v_us_idx := user_str_tbl(i + j - 1).us_idx;
              -- if NULL value is passed as user_string value in UPDATE - we omit the update
              IF v_sql_string_insert IS NOT NULL
                 OR (user_str_tbl(i + j - 1).us_value IS NOT NULL AND v_sql_string_insert IS NULL) THEN
                IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
                  car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Bind variable :' || ':' ||
                                              to_char(v_us_idx) || '; value:<' || get_val(user_str_tbl(i + j - 1).us_value) || '>');
                END IF;
                dbms_sql.bind_variable(cur, ':' || to_char(v_us_idx), get_val(user_str_tbl(i + j - 1).us_value));
              END IF;
            END;
          END LOOP;

          dbms_sql.bind_variable(cur, ':d', abs(p_subunit_rec.user_str_descript));

          IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
            v_info_rec := 'Bind user_str_descript from subunit_rec d:' || to_char(p_subunit_rec.user_str_descript);
            car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || v_info_rec);
          END IF;

          IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
            car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Execute...');
          END IF;

          BEGIN
            RESULT := dbms_sql.EXECUTE(cur);
            dbms_sql.close_cursor(cur);
          EXCEPTION
            WHEN OTHERS THEN
              BEGIN
                err_code := SQLCODE;
                err_msg  := SQLERRM;
                IF dbms_sql.is_open(cur) THEN
                  BEGIN
                    dbms_sql.close_cursor(cur);

                    raise_application_error(-20000, err_msg);
                  END;
                END IF;
              END;
          END;

          IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
            car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Processed ' || RESULT ||
                                        ' row(s) for t_car_user_string');
          END IF;

        END;
        ------------------------------------------------
        IF p_subunit_rec.user_str_descript <> 0 THEN
          p_subunit_rec.user_str_descript := abs(p_subunit_rec.user_str_descript);
          write_user_string_log(p_subunit_rec); -- logging
        END IF;
        ------------------------------------------------
        EXIT;

      END IF;
    END LOOP;
  END write_user_strings;
  --------------------------------------------------------------------------------------

  PROCEDURE update_carrier_data(p_base_id t_car.base_id%TYPE, p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) IS
    --c varchar2(100);
    tmp_transaction_type t_car_log.transaction_type%TYPE;
    pos_actual_incr      INT;
  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Enter procedure update_carrier_data with:' ||
                                  car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'src_car_id:' || p_subunit_rec.src_car_id || car_typesV_1_2_1_RC_b4.SEP ||
                                  car_typesV_1_2_1_RC_b4.TAB || 'src_car_id_type:' || p_subunit_rec.src_car_id_type || car_typesV_1_2_1_RC_b4.SEP ||
                                  car_typesV_1_2_1_RC_b4.TAB || 'dst_car_id:' || p_subunit_rec.dst_car_id || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
                                  'dst_car_id_type:' || p_subunit_rec.dst_car_id_type);
    END IF;

    tmp_transaction_type := TRANSACTION_TYPE_SU_MOVE;
    pos_actual_incr      := 1;
    IF p_subunit_rec.dst_car_id = p_subunit_rec.src_car_id
       AND p_subunit_rec.dst_car_id_type = p_subunit_rec.src_car_id_type THEN
      BEGIN

        tmp_transaction_type := TRANSACTION_TYPE_SU_MOVE_SELF;
        pos_actual_incr      := 0;

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                      'Src_carrier == Dst_carrier (insert one entry only)');
        END IF;

      END;
    END IF;

    -- write in log info about src_carriers
    IF car_typesV_1_2_1_RC_b4.carma_core_control.table_logging != car_typesV_1_2_1_RC_b4.DISABLE_TABLE_LOG THEN
      INSERT INTO t_car_log
        (base_id, car_id, car_id_type, transaction_type, car_type, supplier_id, location_id, external_id_1, external_id_2, description_short,
         description_long, pos_max, pos_actual, status, operator, user_comment, last_maintenance, last_in_use, use_counter, lock_descript,
         user_str_descript, ud_log_id, created, updated, updated_sub, deleted, deleted_sub)
        SELECT c.base_id, c.car_id, c.car_id_type, c.transaction_type, c.car_type, c.supplier_id, c.location_id, c.external_id_1, c.external_id_2,
               c.description_short, c.description_long, c.pos_max, c.pos_actual, c.status, c.operator, c.user_comment, c.last_maintenance,
               c.last_in_use, c.use_counter, c.lock_descript, c.user_str_descript, get_ud_log_id(c.user_str_descript), c.created, c.updated,
               c.updated_sub, c.deleted, c.deleted_sub
        FROM   t_car c
        WHERE  base_id = p_base_id
        AND    car_id = p_subunit_rec.src_car_id
        AND    car_id_type = p_subunit_rec.src_car_id_type;
    END IF;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Insert src_carriers log: rowcount=' ||
                                  SQL%ROWCOUNT);
    END IF;

    -- write in log info about dst_carriers (only when src_carrier != dst_carrier)
    IF p_subunit_rec.dst_car_id != p_subunit_rec.src_car_id
       OR --and
       p_subunit_rec.dst_car_id_type != p_subunit_rec.src_car_id_type THEN
      BEGIN
        IF car_typesV_1_2_1_RC_b4.carma_core_control.table_logging != car_typesV_1_2_1_RC_b4.DISABLE_TABLE_LOG THEN
          INSERT INTO t_car_log
            (base_id, car_id, car_id_type, transaction_type, car_type, supplier_id, location_id, external_id_1, external_id_2, description_short,
             description_long, pos_max, pos_actual, status, operator, user_comment, last_maintenance, last_in_use, use_counter, lock_descript,
             user_str_descript, ud_log_id, created, updated, updated_sub, deleted, deleted_sub)
            SELECT c.base_id, c.car_id, c.car_id_type, c.transaction_type, c.car_type, c.supplier_id, c.location_id, c.external_id_1,
                   c.external_id_2, c.description_short, c.description_long, c.pos_max, c.pos_actual, c.status, c.operator, c.user_comment,
                   c.last_maintenance, c.last_in_use, c.use_counter, c.lock_descript, c.user_str_descript, get_ud_log_id(c.user_str_descript),
                   c.created, c.updated, c.updated_sub, c.deleted, c.deleted_sub
            FROM   t_car c
            WHERE  base_id = p_base_id
            AND    car_id = p_subunit_rec.dst_car_id
            AND    car_id_type = p_subunit_rec.dst_car_id_type;
        END IF;

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Insert dst_carriers log: rowcount=' ||
                                      SQL%ROWCOUNT);
        END IF;
      END;
    END IF;

    -- update t_car for src_carriers -----------------------
    UPDATE t_car
    SET    transaction_type = tmp_transaction_type, updated = car_typesV_1_2_1_RC_b4.carma_core_control.now,
           updated_sub = car_typesV_1_2_1_RC_b4.carma_core_control.now_sub, pos_actual = pos_actual - pos_actual_incr,
           last_in_use = car_typesV_1_2_1_RC_b4.carma_core_control.now, use_counter = use_counter + 1
    WHERE  base_id = p_base_id
    AND    car_id = p_subunit_rec.src_car_id
    AND    car_id_type = p_subunit_rec.src_car_id_type;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Update src_carriers data');
    END IF;

    -- update t_car for dst_carriers - only when sr_carrier != dst_carrier
    IF p_subunit_rec.dst_car_id != p_subunit_rec.src_car_id
       OR --and
       p_subunit_rec.dst_car_id_type != p_subunit_rec.src_car_id_type THEN
      BEGIN
        -- update t_car for dst_carriers -----------------------
        UPDATE t_car
        SET    transaction_type = TRANSACTION_TYPE_SU_MOVE, updated = car_typesV_1_2_1_RC_b4.carma_core_control.now,
               updated_sub = car_typesV_1_2_1_RC_b4.carma_core_control.now_sub, pos_actual = pos_actual + pos_actual_incr,
               last_in_use = car_typesV_1_2_1_RC_b4.carma_core_control.now, use_counter = use_counter + 1
        WHERE  base_id = p_base_id
        AND    car_id = p_subunit_rec.dst_car_id
        AND    car_id_type = p_subunit_rec.dst_car_id_type;

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Update dst_carriers data');
        END IF;
      END;
    END IF;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Exit update_carrier_data');
    END IF;

  END update_carrier_data;

  /*
  makes check: pos_id still free in carrier; if parameter p_raise_error = true, then
  function raises an error: ANOTHER_SUBUNIT_IN_DST_POS
  */
  FUNCTION check_is_position_free(p_subunit2move car_typesV_1_2_1_RC_b4.t_subunit_rec,
                                  /*p_car_id      t_car_subunit.car_id%TYPE,
                                                                                                                                                                                                                                              p_car_id_type t_car_subunit.car_id_type%TYPE,
                                                                                                                                                                                                                                              p_pos_id      t_car_subunit.pos_id%TYPE,*/
                                  p_raise_err BOOLEAN) RETURN BOOLEAN IS
    v_cnt INT;
    v_res BOOLEAN := FALSE;
  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Check whether new position <' ||
                                  p_subunit2move.new_pos_id || '> is free');
    END IF;

    SELECT COUNT(*)
    INTO   v_cnt
    FROM   t_car_subunit
    WHERE  car_id = p_subunit2move.dst_car_id --p_car_id
    AND    car_id_type = p_subunit2move.dst_car_id_type --p_car_id_type
    AND    pos_id = p_subunit2move.new_pos_id --p_pos_id;
    AND    (subunit_id <> p_subunit2move.subunit_id OR subunit_id_type <> p_subunit2move.subunit_id_type);

    IF v_cnt = 0 THEN
      v_res := TRUE;
    END IF;

    IF v_res = FALSE
       AND p_raise_err THEN
      raise_application_error(BASE_ERROR_NUMBER + ANOTHER_SUBUNIT_IN_DST_POS,
                              'Another subunit at pos ' || p_subunit2move.new_pos_id || ' of carrier car_id:' || p_subunit2move.dst_car_id ||
                               ' car_id_type:' || p_subunit2move.dst_car_id_type);
    END IF;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Check result:' || car_typesV_1_2_1_RC_b4.b_to_char(v_res));
    END IF;

    RETURN v_res;
  END check_is_position_free;

  /*
  Loop over all subunits; try to move each of it (change parent carrier);
  write carrirer_log,subunit_log,user_string and user_string_log;
  error handling - according to p_mode_handle_error parameter;
  */
  PROCEDURE c_car_move(p_base_id t_car.base_id%TYPE, p_in_operator t_car.operator%TYPE, p_in_user_comment t_car.user_comment%TYPE,
                       p_mode_handle_error SMALLINT) IS
    v_log_rec                  t_car_subunit%ROWTYPE;
    err_code                   SMALLINT;
    err_msg                    VARCHAR2(32000);
    bool_check_new_pos_is_free BOOLEAN;
    bool_src_eq_dst            BOOLEAN := FALSE;
    v_errstack                 VARCHAR2(4000 CHAR);

    ----------
    -- returns true if subunit has user strings data in input
    ----------
    FUNCTION has_user_str(p_subunit car_typesV_1_2_1_RC_b4.t_subunit_rec) RETURN BOOLEAN IS
    BEGIN
      FOR i IN 1 .. user_str_tbl.COUNT LOOP
        IF user_str_tbl(i).subunit_id = p_subunit.subunit_id
           AND user_str_tbl(i).subunit_id_type = p_subunit.subunit_id_type THEN
          RETURN TRUE;
        END IF;
      END LOOP;
      RETURN FALSE;
    END has_user_str;

    ----------
    -- Assigns user_str_descript (negative) to a subunit if user strings are in input,
    -- but user_str_descript doesn't exists for the subunit (first creation)
    ----------
    PROCEDURE check_user_str_descript(p_subunit IN OUT car_typesV_1_2_1_RC_b4.t_subunit_rec) IS
    BEGIN
      IF has_user_str(p_subunit)
         AND nvl(p_subunit.user_str_descript, 0) = 0 THEN
        SELECT -t_car_user_string__user_str.NEXTVAL INTO p_subunit.user_str_descript FROM dual;
      END IF;
    END check_user_str_descript;

  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Enter procedure c_car_move');
    END IF;

    ------------
    -- start main loop: move of subunits
    FOR i IN 1 .. subunits_tbl.COUNT LOOP
      BEGIN

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                      print_subunit_record('Start move subunit: <' || to_char(i) || '>:', subunits_tbl(i)));
        END IF;

        SAVEPOINT a;

        -----------
        -- check locks and existence -----------------------------
        -----------
        IF subunits_tbl(i).dst_exists_flag = 0
           AND subunits_tbl(i).dst_car_type IS NULL THEN
          raise_application_error(BASE_ERROR_NUMBER + DST_CAR_TYPE_REQUIRED,
                                  'Missing carrier type in input for non-existing dst.carrier; car_id:' || subunits_tbl(i)
                                  .dst_car_id || ' car_id_type:' || subunits_tbl(i).dst_car_id_type);
        END IF;

        IF (subunits_tbl(i)
           .dst_exists_flag <> 0 AND is_car_type_locked(subunits_tbl(i).base_id, subunits_tbl(i).dst_car_id, subunits_tbl(i).dst_car_id_type))
           OR (subunits_tbl(i).dst_exists_flag = 0 AND is_car_type_locked(subunits_tbl(i).base_id, subunits_tbl(i).dst_car_type)) THEN

          raise_application_error(BASE_ERROR_NUMBER + DST_CAR_TYPE_IS_LOCKED,
                                  'Destination carrier is locked via carrier type; car_id:' || subunits_tbl(i)
                                  .dst_car_id || ' car_id_type:' || subunits_tbl(i).dst_car_id_type);
        END IF;

        IF is_car_type_locked(subunits_tbl(i).base_id, subunits_tbl(i).src_car_id, subunits_tbl(i).src_car_id_type) THEN
          raise_application_error(BASE_ERROR_NUMBER + SRC_CAR_TYPE_IS_LOCKED,
                                  'Source carrier is locked via carrier type; car_id:' || subunits_tbl(i)
                                  .src_car_id || ' car_id_type:' || subunits_tbl(i).src_car_id_type);
        END IF;

        IF subunits_tbl(i).dst_car_lock_descript IS NOT NULL THEN
          raise_application_error(BASE_ERROR_NUMBER + DEST_CARRIER_IS_LOCKED,
                                  'Destination carrier is locked; car_id:' || subunits_tbl(i).dst_car_id || ' car_id_type:' || subunits_tbl(i)
                                  .dst_car_id_type);
        END IF;

        IF subunits_tbl(i).su_lock_descript IS NOT NULL THEN
          raise_application_error(BASE_ERROR_NUMBER + SUBUNIT_IS_LOCKED,
                                  'Subunit is locked; subunit_id:' || subunits_tbl(i).subunit_id || ' subunit_id_type:' || subunits_tbl(i)
                                  .subunit_id_type);
        END IF;

        IF subunits_tbl(i).src_car_lock_descript IS NOT NULL THEN
          raise_application_error(BASE_ERROR_NUMBER + SRC_CARRIER_IS_LOCKED,
                                  'Source carrier is locked; car_id:' || subunits_tbl(i).src_car_id || ' car_id_type:' || subunits_tbl(i)
                                  .src_car_id_type);
        END IF;

        IF nvl(subunits_tbl(i).su_exists_flag, 0) = 0 THEN
          raise_application_error(BASE_ERROR_NUMBER + SUBUNIT_NOT_FOUND,
                                  'Subunit not found; subunit_id:' || subunits_tbl(i).subunit_id || ' subunit_id_type:' || subunits_tbl(i)
                                  .subunit_id_type);
        END IF;

        IF subunits_tbl(i).src_car_id IS NULL THEN
          raise_application_error(BASE_ERROR_NUMBER + SRC_CARRIER_NOT_FOUND,
                                  'Source carrier not found; car_id:' || subunits_tbl(i).src_car_id || ' car_id_type:' || subunits_tbl(i)
                                  .src_car_id_type);
        END IF;

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Data validation ... done');
        END IF;

        -- create new  dst_carrier (if needed)
        IF subunits_tbl(i).dst_exists_flag = 0 THEN
          add_new_car_if_need(p_base_id, subunits_tbl, i, p_in_operator, p_in_user_comment);
        END IF;

        bool_check_new_pos_is_free := FALSE;
        -- check dst_pos (get free position if needed)
        IF subunits_tbl(i).new_pos_id IS NULL THEN
          BEGIN
            IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
              car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'New position is not given');
            END IF;
            -- try to generate from pos_x,pos_y, pos_z
            IF subunits_tbl(i).pos_x != 0
               OR subunits_tbl(i).pos_y != 0
               OR subunits_tbl(i).pos_z != 0 THEN
              BEGIN
                IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
                  car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                              'Try to generate it from pos_x,pos_y, pos_z');
                END IF;
                subunits_tbl(i).new_pos_id := to_char(subunits_tbl(i).pos_x) || '_' || to_char(subunits_tbl(i).pos_y) || '_' ||
                                              to_char(subunits_tbl(i).pos_z);
                -- this check returns: either true or raises an error (ANOTHER_SUBUNIT_IN_DST_POS)
                bool_check_new_pos_is_free := check_is_position_free(subunits_tbl(i), TRUE);
              END;
            ELSE
              BEGIN
                IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
                  car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                              'Try to use position_id from source carrier');
                END IF;
                -- try to use position_id from source carrier
                subunits_tbl(i).new_pos_id := subunits_tbl(i).old_pos_id;

                -- check position without raise error (in this check new_pos_id and old_pos_id - char!!)
                -- make check only when car_dest!=car_src

                bool_check_new_pos_is_free := check_is_position_free(subunits_tbl(i), FALSE);
                IF /*bool_src_eq_dst = FALSE
                                                                                                                   AND*/
                 bool_check_new_pos_is_free = FALSE THEN
                  -- position in use; generate new and make check;
                  subunits_tbl(i).new_pos_id := to_char(get_first_free_position(subunits_tbl(i)));
                END IF;
              END;
            END IF;

          END;
        END IF;

        IF bool_check_new_pos_is_free = FALSE THEN
          -- make final position check (and raise_error if this position in use..)
          -- make check only when car_dest!=car_src
          bool_check_new_pos_is_free := check_is_position_free(subunits_tbl(i), TRUE);
        END IF;

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'New position check ... done');
        END IF;

        SELECT *
        INTO   v_log_rec
        FROM   t_car_subunit -- save record for logging -------------------------
        WHERE  subunit_id = subunits_tbl(i).subunit_id
        AND    subunit_id_type = subunits_tbl(i).subunit_id_type;

        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                      'Save current record (t_car_subunit type) as log_record ');
        END IF;

        -- move subunit(write log)
        write_subunit_log(v_log_rec);
        IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Subunit log is written');
        END IF;

        check_user_str_descript(subunits_tbl(i)); --.user_str_descript:=0;

        IF subunits_tbl(i).pos_x != 0
           OR subunits_tbl(i).pos_y != 0
           OR subunits_tbl(i).pos_z != 0 THEN
          BEGIN

            IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
              car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                          print_subunit_update_stmt('Before t_car_subunit update', subunits_tbl(i), p_in_operator,
                                                                    p_in_user_comment, car_typesV_1_2_1_RC_b4.carma_core_control.now,
                                                                    car_typesV_1_2_1_RC_b4.carma_core_control.now_sub, TRUE));
            END IF;

            UPDATE t_car_subunit
            SET    base_id = p_base_id, car_id = subunits_tbl(i).dst_car_id, car_id_type = subunits_tbl(i).dst_car_id_type,
                   transaction_type = TRANSACTION_TYPE_SU_MOVE, car_type = subunits_tbl(i).dst_car_type, operator = get_val(p_in_operator),
                   user_comment = get_val(p_in_user_comment), pos_id = to_char(subunits_tbl(i).new_pos_id), pos_x = subunits_tbl(i).pos_x,
                   pos_y = subunits_tbl(i).pos_y, pos_z = subunits_tbl(i).pos_z, user_str_descript = abs(subunits_tbl(i).user_str_descript),
                   updated = car_typesV_1_2_1_RC_b4.carma_core_control.now, updated_sub = car_typesV_1_2_1_RC_b4.carma_core_control.now_sub
            WHERE  subunit_id = subunits_tbl(i).subunit_id
            AND    subunit_id_type = subunits_tbl(i).subunit_id_type;
            IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
              car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                          'Make move --> update t_car_subunit (with pos_x members)');
            END IF;
          END;
        ELSE
          BEGIN

            IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
              car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                          print_subunit_update_stmt('Before t_car_subunit update', subunits_tbl(i), p_in_operator,
                                                                    p_in_user_comment, car_typesV_1_2_1_RC_b4.carma_core_control.now,
                                                                    car_typesV_1_2_1_RC_b4.carma_core_control.now_sub, FALSE));
            END IF;

            UPDATE t_car_subunit
            SET    base_id = p_base_id, car_id = subunits_tbl(i).dst_car_id, car_id_type = subunits_tbl(i).dst_car_id_type,
                   transaction_type = TRANSACTION_TYPE_SU_MOVE, car_type = subunits_tbl(i).dst_car_type, operator = get_val(p_in_operator),
                   user_comment = get_val(p_in_user_comment), pos_id = to_char(subunits_tbl(i).new_pos_id),
                   user_str_descript = abs(subunits_tbl(i).user_str_descript), updated = car_typesV_1_2_1_RC_b4.carma_core_control.now,
                   updated_sub = car_typesV_1_2_1_RC_b4.carma_core_control.now_sub
            WHERE  subunit_id = subunits_tbl(i).subunit_id
            AND    subunit_id_type = subunits_tbl(i).subunit_id_type;
            IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
              car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                          'Make move --> update t_car_subunit (without pos_x members)');
            END IF;
          END;
        END IF;

        check_loop(subunits_tbl(i));

        -- update user_string (and write log)
        IF subunits_tbl(i).u_sub_each > 0 THEN
          write_user_strings(subunits_tbl(i));
        END IF;

        -- mark this record as processed (for the next updates of carriers)
        subunits_tbl(i).processed := 1;

        -- update carrier data(last_in_use, etc.), write t_car_log
        update_carrier_data(p_base_id, subunits_tbl(i));

      EXCEPTION
        WHEN OTHERS THEN
          BEGIN
            v_errstack := car_typesV_1_2_1_RC_b4.format_errstack(dbms_utility.format_error_backtrace);
            err_code   := SQLCODE;
            err_msg    := SQLERRM;
            IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
              car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || v_errstack);
            END IF;
            ----------
            -- all or none
            ----------
            IF p_mode_handle_error = 0
               OR p_mode_handle_error = 3 THEN
              ROLLBACK;
              IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
                car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Error by processing subunit #' ||
                                            to_char(i) || ' : ' || err_msg);
              END IF;
              RAISE;
            END IF;

            -------
            -- abort on first error
            -------
            IF p_mode_handle_error = 1 THEN
              subunits_tbl(i).new_pos_id := NULL;
              IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
                car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Write error_record #' || to_char(i) ||
                                            ' : ' || err_msg);
              END IF;
              ROLLBACK TO a;
              put_error_record(i, 0, err_code, err_msg);
              EXIT;
            END IF;

            ----------
            -- Make note for this error; continue with next subunits
            ----------
            IF p_mode_handle_error = 2 THEN
              subunits_tbl(i).new_pos_id := NULL;
              IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
                car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Write error_record #' || to_char(i) ||
                                            ' : ' || err_msg);
              END IF;
              ROLLBACK TO a;
              put_error_record(i, 0, err_code, err_msg);
            END IF;

          END;
      END;

    END LOOP;
    -- end of main loop
    -------------------

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Exit procedure c_car_move');
    END IF;

    -----------
    --commit; (not need here; commit make caps function) -----------------------
    -----------

  EXCEPTION
    -- here we catch all other (unexpected) exceptions
    WHEN OTHERS THEN
      BEGIN
        v_errstack := car_typesV_1_2_1_RC_b4.format_errstack(dbms_utility.format_error_backtrace);
        car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || v_errstack);
        err_code := SQLCODE;
        err_msg  := SQLERRM;
        ROLLBACK;
        RAISE;
      END;

  END c_car_move;

  ---------- fill subunit_tbl functions --------------------------------------
  FUNCTION get_dst_carrierdata(p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) RETURN car_typesV_1_2_1_RC_b4.t_car_rec IS
    v_car_rec car_typesV_1_2_1_RC_b4.t_car_rec;
  BEGIN
    FOR i IN 1 .. car_dst_tbl_lock.COUNT LOOP
      IF car_dst_tbl_lock(i).car_id = p_subunit_rec.dst_car_id
         AND car_dst_tbl_lock(i).car_id_type = p_subunit_rec.dst_car_id_type THEN

        v_car_rec := car_dst_tbl_lock(i);
        EXIT;
      END IF;
    END LOOP;
    RETURN v_car_rec;
  END;

  FUNCTION get_src_carrierdata(p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) RETURN car_typesV_1_2_1_RC_b4.t_car_rec IS
    v_car_rec car_typesV_1_2_1_RC_b4.t_car_rec;
  BEGIN
    FOR i IN 1 .. car_src_tbl_lock.COUNT LOOP
      IF car_src_tbl_lock(i).car_id = p_subunit_rec.src_car_id
         AND car_src_tbl_lock(i).car_id_type = p_subunit_rec.src_car_id_type THEN

        v_car_rec := car_src_tbl_lock(i);
        EXIT;
      END IF;
    END LOOP;
    RETURN v_car_rec;
  END;

  FUNCTION get_subunitdata(p_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec) RETURN car_typesV_1_2_1_RC_b4.t_subunit_rec IS
    v_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec;
  BEGIN
    FOR i IN 1 .. subunits_tbl_lock.COUNT LOOP
      IF subunits_tbl_lock(i).subunit_id = p_subunit_rec.subunit_id
         AND subunits_tbl_lock(i).subunit_id_type = p_subunit_rec.subunit_id_type THEN
        v_subunit_rec := subunits_tbl_lock(i);
        EXIT;
      END IF;
    END LOOP;

    RETURN v_subunit_rec;
  END;

  ------------
  -- Function builds subunit table for processing;
  -- each record (type of p_subunit_rec) have complete info, that is need for subunit's move;
  -- parameter p_subunit_tbl - input data(subunit_tbl_tmp)
  ------------
  PROCEDURE fill_data_id_subunit_tbl(p_subunit_tbl IN OUT car_typesV_1_2_1_RC_b4.t_subunit_tbl) IS
    v_src_car_rec car_typesV_1_2_1_RC_b4.t_car_rec;
    v_dst_car_rec car_typesV_1_2_1_RC_b4.t_car_rec;
    v_subunit_rec car_typesV_1_2_1_RC_b4.t_subunit_rec;
  BEGIN
    FOR i IN 1 .. p_subunit_tbl.COUNT LOOP
      -- find and write data about subunit ---------------
      v_subunit_rec := get_subunitdata(p_subunit_tbl(i));
      p_subunit_tbl(i).user_str_descript := v_subunit_rec.user_str_descript;
      p_subunit_tbl(i).su_exists_flag := v_subunit_rec.su_exists_flag;
      p_subunit_tbl(i).su_lock_descript := v_subunit_rec.su_lock_descript;
      p_subunit_tbl(i).src_car_id := v_subunit_rec.src_car_id;
      p_subunit_tbl(i).src_car_id_type := v_subunit_rec.src_car_id_type;
      p_subunit_tbl(i).old_pos_id := v_subunit_rec.old_pos_id;
      p_subunit_tbl(i).processed := 0;
      -- find and write data about src_carrier -----------
      v_src_car_rec := get_src_carrierdata(p_subunit_tbl(i));
      p_subunit_tbl(i).src_car_id := v_src_car_rec.car_id;
      p_subunit_tbl(i).src_car_id_type := v_src_car_rec.car_id_type;
      p_subunit_tbl(i).src_car_lock_descript := v_src_car_rec.lock_descript;
      -- find and write data about dst_carrier -----------
      v_dst_car_rec := get_dst_carrierdata(p_subunit_tbl(i));
      p_subunit_tbl(i).dst_car_pos_max := v_dst_car_rec.pos_max;
      p_subunit_tbl(i).dst_exists_flag := SIGN(nvl(v_dst_car_rec.pos_max, 0));
      p_subunit_tbl(i).dst_car_lock_descript := v_dst_car_rec.lock_descript;
    END LOOP;
  END;

  --======================== main entry ======================================
  PROCEDURE c_car_move_wrap(p_base_id t_car.base_id%TYPE, p_in_operator t_car.operator%TYPE, p_in_user_comment t_car.user_comment%TYPE,
                            p_now t_car.updated%TYPE, p_now_sub t_car.updated_sub%TYPE, p_mode_handle_error PLS_INTEGER, p_errcod IN OUT SMALLINT,
                            p_errmsg IN OUT VARCHAR2) IS

    u_sub_each_cnt INT := 0;

    curr_subunit_rec  car_typesV_1_2_1_RC_b4.t_subunit_rec;
    curr_car_rec      car_typesV_1_2_1_RC_b4.t_car_rec;
    curr_user_str_rec t_car_user_string%ROWTYPE;
    v_record_key      VARCHAR2(1000);
    v_errstack        VARCHAR2(4000 CHAR);
  BEGIN

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Start');
    END IF;

    -- check input data
    IF p_mode_handle_error < 0
       OR p_mode_handle_error > 3 THEN
      raise_application_error(BASE_ERROR_NUMBER + BAD_MODE_HANDLE_ERROR_VALUE, 'Unsupported value for mode_handle_error!');
    END IF;

    -- these values are const for all cases of p_mode_handle_error
    -- (only for p_mode_handle_error=3 antother way)
    p_errcod := 1;
    p_errmsg := 'OK';

    car_typesV_1_2_1_RC_b4.carma_core_control.now     := p_now;
    car_typesV_1_2_1_RC_b4.carma_core_control.now_sub := p_now_sub;

    car_dst_tbl_lock.DELETE;
    subunits_tbl.DELETE;
    subunits_tbl_lock.DELETE;
    car_src_tbl_lock.DELETE;
    user_str_tbl.DELETE;
    user_strings_table_lock.DELETE;

    car_typesV_1_2_1_RC_b4.error_tbl.DELETE;
    --car_typesV_1_2_1_RC_b4.debug_tbl.delete;

    car_typesV_1_2_1_RC_b4.car_sub_move_reply_tbl.DELETE;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Clear work tables');
    END IF;

    -----------------
    -- create and fill data structures;
    -- all data come from caps function by call init_arrays function and
    -- next call of bind functions for each caps global variable, that is used as bind array
    -- (bind_car_id_ ... etc.)
    FOR i IN 1 .. car_id_dest_tbl.COUNT LOOP
      BEGIN
        subunits_tbl.EXTEND;
        -- use 'main' base ID
        subunits_tbl(i).base_id:=p_base_id;
        subunits_tbl(i).dst_car_id := car_id_dest_tbl(i);
        subunits_tbl(i).dst_car_id_type := car_id_type_dest_tbl(i);
        subunits_tbl(i).dst_car_type := car_type_dest_tbl(i);
        subunits_tbl(i).subunit_id := subunit_id_tbl(i);
        subunits_tbl(i).subunit_id_type := subunit_id_type_tbl(i);
        subunits_tbl(i).u_control := nvl(u_control_tbl(i), UPDATE_MODE_UPDATE);
        subunits_tbl(i).u_sub_each := nvl(u_sub_each_tbl(i), 0);
        subunits_tbl(i).new_pos_id := pos_id_tbl(i);
        subunits_tbl(i).pos_x := pos_x_tbl(i);
        subunits_tbl(i).pos_y := pos_y_tbl(i);
        subunits_tbl(i).pos_z := pos_z_tbl(i);
        FOR j IN 1 .. u_sub_each_tbl(i) LOOP
          user_str_tbl.EXTEND;
          u_sub_each_cnt := u_sub_each_cnt + 1;
          user_str_tbl(u_sub_each_cnt).subunit_id := subunit_id_tbl(i);
          user_str_tbl(u_sub_each_cnt).subunit_id_type := subunit_id_type_tbl(i);
          user_str_tbl(u_sub_each_cnt).us_idx := u_sub_idx_tbl(u_sub_each_cnt);
          user_str_tbl(u_sub_each_cnt).us_value := u_sub_tbl(u_sub_each_cnt);
        END LOOP;

      END;
    END LOOP;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Finish read input data in work tables');
    END IF;

    --=========================================================================
    -- select (and lock!) dst carriers ----------------------------------------
    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Start with select for update for dst_carrier');
    END IF;

    reset_unique_control;

    FOR i IN 1 .. subunits_tbl.COUNT LOOP
      BEGIN
        v_record_key := p_base_id || car_typesV_1_2_1_RC_b4.TAB || subunits_tbl(i).dst_car_id || car_typesV_1_2_1_RC_b4.TAB || subunits_tbl(i).dst_car_id_type;
        IF is_value_unique(v_record_key) THEN

          IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
            car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Selection criteria:' || car_typesV_1_2_1_RC_b4.SEP ||
                                        car_typesV_1_2_1_RC_b4.TAB || 'base_id <' || p_base_id || '>' || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
                                        'car_id <' || subunits_tbl(i)
                                        .dst_car_id || '>' || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'car_id_type <' || subunits_tbl(i)
                                        .dst_car_id_type || '>');
          END IF;
          -- So, we avoid double entries
          SELECT c.base_id, c.car_id, c.car_id_type, c.car_type, c.supplier_id, c.location_id, c.external_id_1, c.external_id_2,
                 c.description_short, c.description_long, c.pos_max, c.pos_actual, c.status, c.operator, c.user_comment, c.last_maintenance,
                 c.last_in_use, c.use_counter, c.lock_descript, c.user_str_descript, c.created, c.updated, c.deleted, 1 AS exists_flag
          INTO   curr_car_rec
          FROM   t_car c
          WHERE  c.base_id = p_base_id
          AND    c.car_id = subunits_tbl(i).dst_car_id
          AND    c.car_id_type = subunits_tbl(i).dst_car_id_type
          AND    rownum < 2
          FOR    UPDATE;

          car_dst_tbl_lock.EXTEND;
          car_dst_tbl_lock(car_dst_tbl_lock.COUNT) := curr_car_rec;
          add_unique_key(v_record_key);

        END IF;

      EXCEPTION
        WHEN no_data_found THEN
          -- will be handled later - during existency check in c_car_move
          NULL;
      END;
    END LOOP;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'End select for update for dst_carrier:  ' ||
                                  to_char(car_dst_tbl_lock.COUNT) || ' row(s) selected');
    END IF;
    -- end select (and lock!) dst carriers ------------------------------------
    --=========================================================================

    --=========================================================================
    --select and lock subunits ------------------------------------------------
    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Start with select for update for subunits');
    END IF;
    reset_unique_control;
    FOR i IN 1 .. subunits_tbl.COUNT LOOP
      BEGIN
        v_record_key := p_base_id || car_typesV_1_2_1_RC_b4.TAB || subunits_tbl(i).subunit_id || car_typesV_1_2_1_RC_b4.TAB || subunits_tbl(i).subunit_id_type;
        IF is_value_unique(v_record_key) THEN

          IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
            car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Selection criteria:' || car_typesV_1_2_1_RC_b4.SEP ||
                                        car_typesV_1_2_1_RC_b4.TAB || 'base_id <' || p_base_id || '>' || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
                                        'subunit_id <' || subunits_tbl(i)
                                        .subunit_id || '>' || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'subunit_id_type <' || subunits_tbl(i)
                                        .subunit_id_type || '>');
          END IF;

          SELECT s.base_id, s.subunit_id, s.subunit_id_type, NULL AS new_pos_id, pos_id AS old_pos_id, s.pos_x, s.pos_y, s.pos_z,
                 NULL AS dst_car_pos_max, NULL AS dst_car_id, NULL AS dst_car_id_type, NULL AS dst_car_type, s.car_id AS src_car_id,
                 s.car_id_type AS src_car_id_type, nvl(s.user_str_descript, 0), NULL AS us_created, NULL AS u_control, NULL AS u_sub_each,
                 1 AS su_exists_flag, NULL AS dst_exists_flag, s.lock_descript AS su_lock_descript, NULL AS dst_car_lock_descript,
                 NULL AS src_car_lock_descript, 0 AS processed
          INTO   curr_subunit_rec
          FROM   t_car_subunit s
          WHERE  s.base_id = p_base_id
          AND    subunits_tbl(i).subunit_id = s.subunit_id
          AND    subunits_tbl(i).subunit_id_type = s.subunit_id_type
          AND    rownum < 2
          FOR    UPDATE;

          car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || curr_subunit_rec.src_car_id);

          --if is_value_unique(curr_subunit_rec.base_id || curr_subunit_rec.subunit_id || curr_subunit_rec.subunit_id_type) then
          subunits_tbl_lock.EXTEND;
          subunits_tbl_lock(subunits_tbl_lock.COUNT) := curr_subunit_rec;
          add_unique_key(v_record_key);
        END IF;

      EXCEPTION
        WHEN no_data_found THEN
          -- subunit existence will be validated later - in c_car_move
          NULL;
      END;

    END LOOP;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'End select for update for subunits: ' ||
                                  to_char(subunits_tbl_lock.COUNT) || ' row(s) selected');
    END IF;
    ---select and lock subunits------------------------------------------------
    --=========================================================================

    --=========================================================================
    -- select and lock src_carriers -------------------------------------------
    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Start with select for update for src_carriers');
    END IF;
    reset_unique_control;
    FOR i IN 1 .. subunits_tbl_lock.COUNT LOOP
      BEGIN
        v_record_key := p_base_id || car_typesV_1_2_1_RC_b4.TAB || subunits_tbl_lock(i).src_car_id || car_typesV_1_2_1_RC_b4.TAB || subunits_tbl_lock(i)
                       .src_car_id_type;
        IF is_value_unique(v_record_key) THEN

          IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LINFO THEN
            car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Selection criteria:' || car_typesV_1_2_1_RC_b4.SEP ||
                                        car_typesV_1_2_1_RC_b4.TAB || 'base_id <' || p_base_id || '>' || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB ||
                                        'car_id <' || subunits_tbl_lock(i)
                                        .src_car_id || '>' || car_typesV_1_2_1_RC_b4.SEP || car_typesV_1_2_1_RC_b4.TAB || 'car_id_type <' || subunits_tbl_lock(i)
                                        .src_car_id_type || '>');
          END IF;

          SELECT c.base_id, c.car_id, c.car_id_type, c.car_type, c.supplier_id, c.location_id, c.external_id_1, c.external_id_2,
                 c.description_short, c.description_long, c.pos_max, c.pos_actual, c.status, c.operator, c.user_comment, c.last_maintenance,
                 c.last_in_use, c.use_counter, c.lock_descript, c.user_str_descript, c.created, c.updated, c.deleted, 1
          INTO   curr_car_rec
          FROM   t_car c
          WHERE  c.base_id = p_base_id
          AND    subunits_tbl_lock(i).src_car_id = c.car_id
          AND    subunits_tbl_lock(i).src_car_id_type = c.car_id_type
          FOR    UPDATE;

          --if is_value_unique(curr_car_rec.base_id || curr_car_rec.car_id || curr_car_rec.car_id_type) then
          car_src_tbl_lock.EXTEND;
          car_src_tbl_lock(car_src_tbl_lock.COUNT) := curr_car_rec;
          add_unique_key(v_record_key);
        END IF;

      EXCEPTION
        WHEN no_data_found THEN
          NULL;

      END;
    END LOOP;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'End select for update for src_carrier: ' ||
                                  to_char(car_src_tbl_lock.COUNT) || ' row(s) selected');
    END IF;
    -- end select and lock src_carriers----------------------------------------
    --=========================================================================

    -- fill data in subunit_tbl ----------------------------
    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep ||
                                  'Start prepare subunit data for processing( call fill_data_id_subunit_tbl)');
    END IF;

    fill_data_id_subunit_tbl(subunits_tbl);

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Finish prepare  prepare subunit data ');
    END IF;

    --=========================================================================
    -- select (and lock) user_strings -----------------------------------------
    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Start with  select for update user strings');
    END IF;
    reset_unique_control;
    FOR i IN 1 .. subunits_tbl_lock.COUNT LOOP
      BEGIN
        v_record_key := to_char(subunits_tbl_lock(i).user_str_descript);
        IF v_record_key IS NOT NULL
           AND is_value_unique(v_record_key) THEN
          SELECT *
          INTO   curr_user_str_rec
          FROM   t_car_user_string us
          WHERE  subunits_tbl_lock(i).user_str_descript = us.user_str_descript
          FOR    UPDATE;

          --if is_value_unique(to_char(curr_user_str_rec.user_str_descript)) then
          user_strings_table_lock.EXTEND;
          user_strings_table_lock(user_strings_table_lock.COUNT) := curr_user_str_rec;
          add_unique_key(v_record_key);
        END IF;

      EXCEPTION
        WHEN no_data_found THEN
          NULL;
      END;
    END LOOP;

    IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.LDEBUG THEN
      car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'End select for update user strings: ' ||
                                  to_char(user_strings_table_lock.COUNT) || ' row(s) selected');
    END IF;
    -- end select (and lock) user_strings -------------------------------------
    --=========================================================================

    ----------
    -- init output array;
    -- (because for mode_handle_error = 0 or 3 we will not rich "fill output array" part)
    FOR i IN 1 .. subunits_tbl.COUNT LOOP
      car_typesV_1_2_1_RC_b4.car_sub_move_reply_tbl.EXTEND;
      car_typesV_1_2_1_RC_b4.car_sub_move_reply_tbl(i) := NULL;
    END LOOP;

    -- goto main loop ----------------------------------------------------------
    c_car_move(p_base_id, p_in_operator, p_in_user_comment, p_mode_handle_error);
    ----------------------------------------------------------------------------

    ----------
    -- fill output data (now only new_pos_id in output array);
    -- this will be never called for mode_handle_error = 0 or 3
    FOR i IN 1 .. subunits_tbl.COUNT LOOP
      -- we do not extend the output table: it is already initiate before c_car_move call (above)
      IF car_typesV_1_2_1_RC_b4.carma_core_control.debug_level >= car_typesV_1_2_1_RC_b4.linfo THEN
        car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Put pos_id into output table: <' ||
                                    subunits_tbl(i).new_pos_id || '>');
      END IF;
      car_typesV_1_2_1_RC_b4.car_sub_move_reply_tbl(i) := subunits_tbl(i).new_pos_id;
    END LOOP;

  EXCEPTION
    WHEN OTHERS THEN
      BEGIN
        v_errstack := car_typesV_1_2_1_RC_b4.format_errstack(dbms_utility.format_error_backtrace);
        car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || SQLERRM || car_typesV_1_2_1_RC_b4.sep || v_errstack);

        IF p_mode_handle_error = 3 THEN
          -- put errors in out params
          p_errcod := get_errcod(SQLCODE);
          p_errmsg := substr(SQLERRM, 1, 1000);
        END IF;

        put_error_record(0, 0, SQLCODE, SQLERRM);
      END;

  END c_car_move_wrap;

  -------------------input procedures; called from server  function -----------

  PROCEDURE init_arrays IS
    -- need to be call before each call of caps function c_car_sub_update
    v_errstack VARCHAR2(4000 CHAR);
  BEGIN
    car_typesV_1_2_1_RC_b4.debug_tbl.DELETE;

    car_typesV_1_2_1_RC_b4.put_log_record($$PLSQL_LINE || ':' || $$PLSQL_UNIT || car_typesV_1_2_1_RC_b4.sep || 'Init arrays');

    car_id_dest_tbl.DELETE;
    car_id_type_dest_tbl.DELETE;
    car_type_dest_tbl.DELETE;
    pos_id_tbl.DELETE;
    pos_x_tbl.DELETE;
    pos_y_tbl.DELETE;
    pos_z_tbl.DELETE;
    subunit_id_tbl.DELETE;
    subunit_id_type_tbl.DELETE;
    u_sub_each_tbl.DELETE;
    u_control_tbl.DELETE;
    u_sub_idx_tbl.DELETE;
    u_sub_tbl.DELETE;
  END;

  PROCEDURE bind_car_id_dest_tbl(val VARCHAR2) IS
  BEGIN
    --car_id_dest_tbl.extend;
    car_id_dest_tbl(car_id_dest_tbl.COUNT + 1) := TRIM(val);
  END;

  PROCEDURE bind_car_id_type_dest_tbl(val VARCHAR2) IS
  BEGIN
    --car_id_type_dest_tbl.extend;
    car_id_type_dest_tbl(car_id_type_dest_tbl.COUNT + 1) := TRIM(val);
  END;

  PROCEDURE bind_car_type_dest_tbl(val VARCHAR2) IS
  BEGIN
    --car_type_dest_tbl.extend;
    car_type_dest_tbl(car_type_dest_tbl.COUNT + 1) := TRIM(val);
  END;

  PROCEDURE bind_pos_id_tbl(val VARCHAR2) IS
  BEGIN
    --pos_id_tbl.extend;
    pos_id_tbl(pos_id_tbl.COUNT + 1) := TRIM(val);
  END;

  PROCEDURE bind_pos_x_tbl(val INT) IS
  BEGIN
    --pos_x_tbl.extend;
    pos_x_tbl(pos_x_tbl.COUNT + 1) := val;
  END;

  PROCEDURE bind_pos_y_tbl(val INT) IS
  BEGIN
    --pos_y_tbl.extend;
    pos_y_tbl(pos_y_tbl.COUNT + 1) := val;
  END;

  PROCEDURE bind_pos_z_tbl(val INT) IS
  BEGIN
    --pos_z_tbl.extend;
    pos_z_tbl(pos_z_tbl.COUNT + 1) := val;
  END;

  PROCEDURE bind_subunit_id_tbl(val VARCHAR2) IS
  BEGIN
    --subunit_id_tbl.extend;
    subunit_id_tbl(subunit_id_tbl.COUNT + 1) := TRIM(val);
  END;

  PROCEDURE bind_subunit_id_type_tbl(val VARCHAR2) IS
  BEGIN
    --subunit_id_type_tbl.extend;
    subunit_id_type_tbl(subunit_id_type_tbl.COUNT + 1) := TRIM(val);
  END;

  PROCEDURE bind_u_sub_each_tbl(val INT) IS
  BEGIN
    --u_sub_each_tbl.extend;
    u_sub_each_tbl(u_sub_each_tbl.COUNT + 1) := val;
  END;

  PROCEDURE bind_u_control_tbl(val VARCHAR2) IS
  BEGIN
    --u_control_tbl.extend;
    u_control_tbl(u_control_tbl.COUNT + 1) := TRIM(val);
  END;

  PROCEDURE bind_u_sub_idx_tbl(val INT) IS
  BEGIN
    --u_sub_idx_tbl.extend;
    u_sub_idx_tbl(u_sub_idx_tbl.COUNT + 1) := val;
  END;

  PROCEDURE bind_u_sub_tbl(val VARCHAR2) IS
  BEGIN
    --u_sub_tbl.extend;
    u_sub_tbl(u_sub_tbl.COUNT + 1) := TRIM(val);
  END;

BEGIN
  -- Initialization
  car_typesV_1_2_1_RC_b4.error_tbl              := car_typesV_1_2_1_RC_b4.t_error_tbl();
  car_typesV_1_2_1_RC_b4.debug_tbl              := car_typesV_1_2_1_RC_b4.t_debug_tbl();
  car_typesV_1_2_1_RC_b4.car_sub_move_reply_tbl := car_typesV_1_2_1_RC_b4.t_car_sub_move_reply_tbl();

  car_dst_tbl_lock := car_typesV_1_2_1_RC_b4.t_car_tbl();
  car_src_tbl_lock := car_typesV_1_2_1_RC_b4.t_car_tbl();

  subunits_tbl      := car_typesV_1_2_1_RC_b4.t_subunit_tbl();
  subunits_tbl_lock := car_typesV_1_2_1_RC_b4.t_subunit_tbl();

  user_str_tbl            := car_typesV_1_2_1_RC_b4.t_usr_str_tbl();
  user_strings_table_lock := car_typesV_1_2_1_RC_b4.t_user_strings_table();
END car_sbmvV_1_2_1_RC_b4;
/

