create PACKAGE BODY CLM_APP_MON_V_1_4_1_b2 IS
  /***********************************************************************************************
  PROCEDURE recompile
  A simple call for the server to verify package is recompiled for session before using
  /***********************************************************************************************/
  PROCEDURE recompile IS
  BEGIN
    NULL;
  END;
  /***********************************************************************************************/
  FUNCTION get_mon_entry(p_key_mon_id VARCHAR2,
                         p_entry_name VARCHAR2) RETURN VARCHAR2 IS
    val VARCHAR2(200);
  BEGIN
    SELECT t.text_value
      INTO val
      FROM t_entry_text t, t_entry e
     WHERE t.entry_id = e.entry_id
       AND e.parent_key_id = p_key_mon_id
       AND e.entry_name = p_entry_name
       AND t.index_no = 0;
    RETURN val;
  END;
  /***********************************************************************************************/
  PROCEDURE debug(debug_level      PLS_INTEGER,
                  p_procedure_name VARCHAR2,
                  p_line_num       NUMBER,
                  p_message        VARCHAR2) IS
  BEGIN
    clm_debug_V_1_4_1_b2.add_debug_info(debug_level, $$PLSQL_UNIT || '(' || p_line_num || ') ' || p_message);
  END;
  /***********************************************************************************************/
  PROCEDURE app_monitor IS
    PLSQL_PROC       CHAR(11) := 'app_monitor';
    v_cfg_path       VARCHAR2(100) := '/.MES_System/Core/CLM/ApplicationMonitor';
    v_key_id         NUMBER;
    v_client_id      NUMBER;
    v_client_name    t_client_history.client_name%TYPE;
    v_board_id       NUMBER;
    v_template_id    NUMBER;
    v_time_since     NUMBER;
    v_seconds        NUMBER;
    v_last_activity  DATE;
    v_client_hist_id NUMBER;
  BEGIN
    debug(5, PLSQL_PROC, $$PLSQL_LINE, 'Starting on ' || to_char(SYSDATE, 'DD-MON-YY HH24:MI:SS'));
    clm_config_V_1_4_1_b2.p_get_path_key_id(v_cfg_path, v_key_id, 'Y');
    -- each app
    FOR k IN (SELECT *
                FROM t_key
               WHERE parent_key_id = v_key_id
                 AND key_name NOT IN (SELECT key_name FROM t_bg_client_monitor))
    LOOP
      debug(5, PLSQL_PROC, $$PLSQL_LINE, 'Working on key ' || k.key_name);
      -- get the client ID
      v_client_id := get_mon_entry(k.key_id, 'client_id');
      v_seconds   := get_mon_entry(k.key_id, 'seconds');
      -- get last activity
      SELECT ch.last_activity, ch.client_hist_id, ch.client_name
        INTO v_last_activity, v_client_hist_id, v_client_name
        FROM t_client_history ch, t_client c
       WHERE c.client_id = v_client_id
         AND c.client_id = ch.client_id
         AND c.last_start_date = ch.start_date;

      -- how long since pulse?
      debug(3,
            PLSQL_PROC,
            $$PLSQL_LINE,
            'CHECK ' || to_char((v_last_activity + (v_seconds / 86400)), 'DD-MON-YY HH24:MI:SS') || ' SYSDATE ' || to_char(SYSDATE, 'DD-MON-YY HH24:MI:SS'));
      IF ((v_last_activity + (v_seconds / 86400)) < SYSDATE) THEN
        debug(3, PLSQL_PROC, $$PLSQL_LINE, 'Client ' || v_client_name || ' is idle or not running');
        -- NEED TO SEND NOTIFICATION.  STORE IN GLOBAL TEMP TABLE
        v_board_id    := get_mon_entry(k.key_id, 'board_id');
        v_template_id := get_mon_entry(k.key_id, 'template_id_down');
        -- Insert into table?
        INSERT INTO t_bg_client_monitor
          (key_id, client_id, client_hist_id, template_id, board_id, notify_down, notify_up)
        VALUES
          (k.key_id, v_client_id, v_client_hist_id, v_template_id, v_board_id, 'Y', 'N');
      ELSE
        debug(4, PLSQL_PROC, $$PLSQL_LINE, 'Client ' || v_client_name || ' last reported at ' || to_char(v_last_activity, 'DD-MON-YY HH24:MI:SS'));
        debug(4, PLSQL_PROC, $$PLSQL_LINE, 'That was ' || ((SYSDATE - v_last_activity) * 60 * 60 * 24) || ' seconds ago (max ' || v_seconds || ')');
      END IF;
    END LOOP;

    -- clean up anything (keys) that was deleted in editor
    DELETE FROM t_bg_client_monitor WHERE key_id NOT IN (SELECT key_id FROM t_key WHERE parent_key_id = v_key_id);

    -- each app
    FOR k IN (SELECT c.client_id, c.last_start_date, h.start_date, h.last_activity, h.client_name, d.key_id, d.key_name
                FROM v_bg_client_mon_data d, t_client c, t_client_history h
               WHERE d.notify_up = 'N'
                 AND d.notify_down = 'D'
                 AND c.client_id = d.client_id
                 AND h.client_hist_id = d.client_hist_id)
    LOOP
      IF (k.last_start_date > k.start_date) THEN
        debug(3, PLSQL_PROC, $$PLSQL_LINE, 'Client ' || k.client_name || ' has been restarted');
        v_template_id := get_mon_entry(k.key_id, 'template_id_up');
        UPDATE t_bg_client_monitor SET notify_up = 'Y', template_id = v_template_id WHERE client_id = k.client_id;
      ELSE
        debug(3, PLSQL_PROC, $$PLSQL_LINE, 'Client ' || k.client_name || ' is still down');
      END IF;
    END LOOP;
  END;
  /***********************************************************************************************/
  PROCEDURE notified_down(p_client_id NUMBER) IS
  BEGIN
    UPDATE t_bg_client_monitor
       SET notify_down = 'D'
     WHERE client_id = p_client_id
       AND notify_down = 'Y';
  END;
  /***********************************************************************************************/
  PROCEDURE notified_up(p_client_id NUMBER) IS
  BEGIN
    DELETE FROM t_bg_client_monitor
     WHERE client_id = p_client_id
       AND notify_up = 'Y';
  END;
  /***********************************************************************************************/
  PROCEDURE caps_app_monitor(p_errcode OUT PLS_INTEGER,
                             p_errmsg  OUT VARCHAR2) IS
  BEGIN
    app_monitor;
    p_errcode := 0;
    p_errmsg  := '';
  EXCEPTION
    WHEN OTHERS THEN
      p_errcode := SQLCODE;
      p_errmsg  := substr(SQLERRM, 1, 200);
      IF (NOT clm_error_V_1_4_1_b2.is_user_exception(p_errcode)) THEN
        RAISE; -- WAS NOT A HANDLED EXCEPTION, RE-RAISE IT
      END IF;
  END;
  /***********************************************************************************************/
  PROCEDURE caps_notified_down(p_client_id NUMBER,
                               p_errcode   OUT PLS_INTEGER,
                               p_errmsg    OUT VARCHAR2) IS
  BEGIN
    notified_down(p_client_id);
    p_errcode := 0;
    p_errmsg  := '';
  EXCEPTION
    WHEN OTHERS THEN
      p_errcode := SQLCODE;
      p_errmsg  := substr(SQLERRM, 1, 200);
      IF (NOT clm_error_V_1_4_1_b2.is_user_exception(p_errcode)) THEN
        RAISE; -- WAS NOT A HANDLED EXCEPTION, RE-RAISE IT
      END IF;
  END;
  /***********************************************************************************************/
  PROCEDURE caps_notified_up(p_client_id NUMBER,
                             p_errcode   OUT PLS_INTEGER,
                             p_errmsg    OUT VARCHAR2) IS
  BEGIN
    notified_up(p_client_id);
    p_errcode := 0;
    p_errmsg  := '';
  EXCEPTION
    WHEN OTHERS THEN
      p_errcode := SQLCODE;
      p_errmsg  := substr(SQLERRM, 1, 200);
      IF (NOT clm_error_V_1_4_1_b2.is_user_exception(p_errcode)) THEN
        RAISE; -- WAS NOT A HANDLED EXCEPTION, RE-RAISE IT
      END IF;
  END;
  /***********************************************************************************************/
END;
/

