create FUNCTION clob_to_blob(p_clob IN CLOB) RETURN BLOB IS
    v_blob        BLOB;
    v_offset      NUMBER DEFAULT 1;
    v_amount      NUMBER DEFAULT 4096;
    v_offsetwrite NUMBER DEFAULT 1;
    v_amountwrite NUMBER;
    v_buffer      VARCHAR2(4096 CHAR);
  BEGIN
    dbms_lob.createtemporary(v_blob, TRUE);
    BEGIN
      LOOP
        dbms_lob.READ(p_clob, v_amount, v_offset, v_buffer);
        v_amountwrite := utl_raw.length(utl_raw.cast_to_raw(v_buffer));
        dbms_lob.WRITE(v_blob, v_amountwrite, v_offsetwrite, utl_raw.cast_to_raw(v_buffer));
        v_offsetwrite := v_offsetwrite + v_amountwrite;
        v_offset      := v_offset + v_amount;
        v_amount      := 4096;
      END LOOP;
    EXCEPTION
      WHEN no_data_found THEN
        NULL;
    END;
    RETURN v_blob;
  END;
/

