create FUNCTION get_key_path(p_key_id NUMBER) RETURN VARCHAR2 IS
  vpath     VARCHAR2(2000);
  search_id t_key.key_id%TYPE := p_key_id;
  pid       t_key.key_id%TYPE;
  kname     t_key.key_name%TYPE;
BEGIN
  LOOP
    BEGIN
      SELECT key_name, parent_key_id INTO kname, pid FROM t_KEY WHERE key_id = search_id;
      IF pid < 0 THEN
        -- root parent_id is -1
        IF (LENGTH(vpath) > 0) THEN
          RETURN vpath; -- stop at root key! (we don't say /root/child1 we say /child1)
        ELSE
          RETURN '/';
        END IF;
      END IF;
      vpath     := '/' || kname || vpath;
      search_id := pid;
    EXCEPTION
      WHEN no_data_found THEN
        EXIT;
    END;
  END LOOP;
  RETURN vpath;
END;
/

