using System;
using System.Data;
using System.Threading.Tasks;
using Oracle.ManagedDataAccess.Client;

namespace AnalyseToolExtension.Clients
{
    public static class MesClient
    {
        private const string ConString = "User Id=mesread;Password=mesread;Data Source=budbmes2.auto.contiwan.com:1521/REPORTING.auto.contiwan.com";

        public static OracleConnection OraConnection { get; private set; }
        public static async Task Connect(string customConnectionString = null,bool directConnect = false)
        {
            if (await ConnectionCheck() && !directConnect) return;
            
            if (OraConnection != null && directConnect) { await Disconnect(); }
            
            var cs = string.IsNullOrEmpty(customConnectionString) ? ConString : customConnectionString;

            Console.WriteLine("MesClient database connecting...");
            OraConnection = new OracleConnection(cs);

            try
            {
                OraConnection.SqlNetAllowedLogonVersionClient = (OracleAllowedLogonVersionClient)5;
                OraConnection.SqlNetAllowedLogonVersionClient = (OracleAllowedLogonVersionClient)3;
                OraConnection.Open();
                Console.WriteLine("MesClient database connection successful.");
            }
            catch (Exception ex) { await Task.FromException(ex); }
        }

        public static Task<bool> ConnectionCheck()
        {
            if (OraConnection == null) return Task.FromResult(false);

            try
            {
                using (OracleCommand cmd = new OracleCommand("SELECT 1 FROM DUAL", OraConnection))
                {
                    try
                    {
                        cmd.ExecuteScalar();
                    }catch(Exception ex) { return Task.FromResult(false); }
                }

                return Task.FromResult(OraConnection.State == ConnectionState.Open);
            }
            catch (Exception e)
            {
                return Task.FromResult(false);
            }

            return Task.FromResult(false);
        }

        public static Task Disconnect()
        {
            if (OraConnection == null) return Task.FromResult(false);
            try
            {
                OraConnection.Close(); 
                OraConnection.Dispose();
                OraConnection = null;
                return Task.CompletedTask;
            }
            catch (Exception e) { Task.FromException(e); }
            return Task.FromResult(false);
        }
    }
}