using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Diagnostics.Tracing;
using System.Globalization;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using AnalyseToolExtension.DataObjects;
using AnalyseToolExtension.QueryCodes;
using Microsoft.SqlServer.Server;
using Oracle.ManagedDataAccess.Client;

namespace AnalyseToolExtension.Clients
{
    public class MesDataBase
    {
        private static OracleConnection OraConnection { get; set; }

        public static Task Connect(string customConnectionString = null)
        {
            if (OraConnection != null)
            {
                OraConnection.Close();
                OraConnection.Dispose();
                OraConnection = null;
            }
            
            var cs = string.IsNullOrEmpty(customConnectionString)
                ? "User Id=mesread;Password=mesread;Data Source=budbmes2.auto.contiwan.com:1521/REPORTING.auto.contiwan.com"
                : customConnectionString;

            Console.WriteLine("Csatlakozás a MES adatbázishoz...");
            OraConnection = new OracleConnection(cs);

            try
            {
                OraConnection.SqlNetAllowedLogonVersionClient = (OracleAllowedLogonVersionClient)5;
                OraConnection.SqlNetAllowedLogonVersionClient = (OracleAllowedLogonVersionClient)3;
                OraConnection.Open();
                Console.WriteLine("Sikeres csatlakozás a MES adatbázishoz!");
                return Task.CompletedTask;
            }
            catch (Exception ex)
            {
                //throw new Exception(ex.Message, ex);
                Console.WriteLine("Csatlakozási hiba : " + ex.Message);
                Task.FromException(ex);
            }

            return Task.CompletedTask;
        }

        private static bool ConnectionCheck()
        {
            if (OraConnection == null) return false;
            try
            {
                var si = OraConnection.State;
                if (si == ConnectionState.Open) return true;
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
                return false;
            }

            return false;
        }

        public async Task<DataTable> GetCustomData(string command)
        {
            if (!ConnectionCheck()) await Connect();
            using (var cmd = OraConnection.CreateCommand())
            {
                try
                {
                    cmd.CommandText = command;
                    cmd.CommandType = CommandType.Text;
                    var reader = await cmd.ExecuteReaderAsync();
                    var dt = new DataTable();
                    var fc = reader.FieldCount;
                    for (var i = 0; i < fc; i++)
                    {
                        dt.Columns.Add(reader.GetColumnSchema()[i].ColumnName);
                    }

                    while (reader.Read())
                    {
                        var obs = new List<object>();
                        for (var i = 0; i < fc; i++)
                        {
                            obs.Add(reader.GetString(i));
                        }

                        dt.Rows.Add(obs);
                    }

                    reader.Close();

                    return dt;
                }
                catch (Exception ex)
                {
                    return await (Task<DataTable>)Task.FromException(ex);
                }
            }
        }

        //public async Task<UnitInfo> GetUnitInfo(string unitId) { }
        public async Task<List<EvaInfo>> GetEvaInfo(string unitId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = new List<EvaInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT plr.RUN_DATE, plr.RUNID_TYPE, mat.pdk_material AS Material_Number, plr.RUN_STATE, psp.PRP_VAR AS TestplanName, psp.PRP_VER, bmn.bmt_name AS Station, plr.run_key_prt, plr.run_seq_key " +
                    "FROM evaprod.pd_lfd_run plr " +
                    "JOIN evaprod.pd_stm_prp psp ON plr.prp_date_id = psp.prp_date_id " +
                    "JOIN evaprod.pd_lfd_mat mat ON plr.prd_mat_sid = mat.prd_mat_sid " +
                    "JOIN evaprod.pd_lfd_bmn bmn ON plr.bmt_dat_id = bmn.bmt_dat_id " +
                    $"WHERE plr.runid = '{unitId}' " +
                    "ORDER BY run_date DESC";
                cmd.CommandType = CommandType.Text;
                var evaReader = await cmd.ExecuteReaderAsync(token);
                while (evaReader.ReadAsync(token).Result)
                {
                    var typ = evaReader.IsDBNull(1) ? null : evaReader.GetString(1);
                    var res = evaReader.IsDBNull(3) ? null : evaReader.GetString(3);
                    var dte = evaReader.IsDBNull(0) ? new DateTime() : evaReader.GetDateTime(0);
                    var mat = evaReader.IsDBNull(2) ? null : evaReader.GetString(2);
                    var stn = evaReader.IsDBNull(6) ? null : evaReader.GetString(6);
                    var tpn = evaReader.IsDBNull(4) ? null : evaReader.GetString(4);
                    var tpv = evaReader.IsDBNull(5) ? null : evaReader.GetString(5);
                    var key = evaReader.IsDBNull(7) ? null : evaReader.GetString(7);
                    var seq = evaReader.IsDBNull(8) ? null : evaReader.GetString(8);
                    rtn.Add(new EvaInfo()
                    {
                        DateTime = dte,
                        KeyPrt = key,
                        SeqKey = seq,
                        Material = mat,
                        Result = Converters.StringToUnitState(res),
                        UnitIdType = typ,
                        Station = stn,
                        TestPlanName = tpn,
                        TestPlanVersion = tpv
                    });
                }

                evaReader.Close();
            }

            return rtn;
        }

        public async Task<EvaTestInfo> GetEvaTestInfo(string unitId, string key, string seq,
            CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = new EvaTestInfo();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT mrk.mrk_reihe, mrk.mrk_num, mrk.mrk_num_lng, med2.mrk_sub_num, mrk.mrk_bez, med2.mrk_wert, med2.mrk_ein_gut, mrk.mrk_usg, mrk.mrk_osg, mrk.mrk_einheit, mrk.mrk_datentyp, aslp.aslp_kom, mxt2.mrk_txt " +
                    "FROM evaprod.pd_lfd_run plr, evaprod.pd_stm_prp prp, evaprod.pd_stm_mrk mrk, evaprod.pd_lfd_med2 med2, evaprod.pd_lfd_mxt2 mxt2, pd_stm_aslp aslp " +
                    $"WHERE plr.runid = '{unitId}' AND plr.run_key_prt = '{key}' AND  plr.run_key_prt = med2.run_key_prt AND plr.run_seq_key = '{seq}' AND  plr.run_seq_key = med2.run_seq_key AND plr.prp_date_id = prp.prp_date_id AND plr.prp_date_id = mrk.prp_date_id AND mrk.mrk_num = med2.mrk_num AND plr.run_key_prt = mxt2.run_key_prt(+) AND  plr.run_seq_key = mxt2.run_seq_key(+) AND  med2.mrk_num = mxt2.mrk_num(+) AND mrk.asl_date_id = aslp.asl_date_id(+) AND  med2.mrk_wert = aslp.aslp_num(+) " +
                    "ORDER BY med2.mrk_ein_gut, mrk.mrk_reihe, med2.mrk_sub_num";
                cmd.CommandType = CommandType.Text;
                var evaTrReader = await cmd.ExecuteReaderAsync(token);
                while (evaTrReader.ReadAsync(token).Result)
                {
                    rtn = new EvaTestInfo()
                    {
                        Sequence = evaTrReader.IsDBNull(0) ? null : evaTrReader.GetString(0),
                        SubSequence = evaTrReader.IsDBNull(2) ? null : evaTrReader.GetString(2),
                        Id = evaTrReader.IsDBNull(1)
                            ? null
                            :
                            evaTrReader.GetString(1).Contains("#")
                                ?
                                evaTrReader.IsDBNull(2) ? null : evaTrReader.GetString(2)
                                : evaTrReader.GetString(1),
                        Description = evaTrReader.IsDBNull(4) ? null : evaTrReader.GetString(4),
                        Value = evaTrReader.IsDBNull(5) ? 0F : evaTrReader.GetFloat(5),
                        Result = evaTrReader.IsDBNull(6)
                            ? UnitState.None
                            : Converters.StringToUnitState(evaTrReader.GetString(6)),
                        MinValue = evaTrReader.IsDBNull(7) ? 0F : evaTrReader.GetFloat(7),
                        MaxValue = evaTrReader.IsDBNull(8) ? 0F : evaTrReader.GetFloat(8),
                        ValueType = evaTrReader.IsDBNull(9) ? null : evaTrReader.GetString(9),
                        TextInfo = evaTrReader.IsDBNull(10) ? null : evaTrReader.GetString(10)
                    };
                }

                evaTrReader.Close();
            }

            return rtn;
        }

        public async Task<string> GetEvaTestTextInfo(string unitId, string key, string seq, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT ted2.txt_info " +
                    "FROM evaprod.pd_lfd_run plr " +
                    "JOIN evaprod.pd_lfd_ted2 ted2 ON plr.run_key_prt = ted2.run_key_prt AND plr.run_seq_key = ted2.run_seq_key " +
                    $"WHERE plr.runid = '{unitId}' AND plr.run_key_prt = '{key}' AND plr.run_seq_key = '{seq}'";
                cmd.CommandType = CommandType.Text;
                var tiReader = await cmd.ExecuteReaderAsync(token);
                if (await tiReader.ReadAsync(token))
                {
                    rtn = tiReader.IsDBNull(0) ? null : tiReader.GetString(0);
                }
                tiReader.Close();
            }
            return rtn;
            
        }

        public async Task<List<WipInfo>> GetWipInfo(string unitId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = new List<WipInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wip.job AS Order_info, wip.unit_id_in, wip.unit_id_in_type, wip.updated, wip.equipment, wip.sub_device, wip.qty_checkin, wip.qty_fail, wip.qty_yield, wip.qty_loss, wip.lock_descript, wipproc.description_short, wiplock.user_comment, wipjob.product_definition, wipjob.terminated, wipjob.lock_descript " +
                    "FROM wip.t_wip_subset wip " +
                    "JOIN wip.t_wip_process_step wipProc ON wip.process_step = wipProc.process_step AND wip.process_step_id = wipProc.process_step_id AND wip.job = wipProc.job " +
                    "JOIN wip.t_wip_job wipJob ON wip.job = wipJob.job " +
                    "LEFT JOIN wip.t_wip_lock wiplock ON wip.lock_descript = wiplock.lock_descript " +
                    $"WHERE wip.unit_id_in = '{unitId}' " +
                    "ORDER BY wip.updated DESC";
                cmd.CommandType = CommandType.Text;
                var wipReader = await cmd.ExecuteReaderAsync(token);
                while (wipReader.ReadAsync(token).Result)
                {
                    var ord = wipReader.IsDBNull(0) ? null : wipReader.GetString(0);
                    var uid = wipReader.IsDBNull(1) ? null : wipReader.GetString(1);
                    var uit = wipReader.IsDBNull(2) ? null : wipReader.GetString(2);
                    var dte = wipReader.IsDBNull(3) ? new DateTime() : wipReader.GetDateTime(3);
                    ;
                    var eqm = wipReader.IsDBNull(4) ? null : wipReader.GetString(4);
                    var stn = wipReader.IsDBNull(5) ? null : wipReader.GetString(5);
                    var res1 = wipReader.IsDBNull(6) ? null : wipReader.GetString(6);
                    var res2 = wipReader.IsDBNull(7) ? null : wipReader.GetString(7);
                    var res3 = wipReader.IsDBNull(8) ? null : wipReader.GetString(8);
                    var res4 = wipReader.IsDBNull(9) ? null : wipReader.GetString(9);
                    var lid = wipReader.IsDBNull(10) ? null : wipReader.GetString(10);
                    var sdc = wipReader.IsDBNull(11) ? null : wipReader.GetString(11);
                    var lcm = wipReader.IsDBNull(12) ? null : wipReader.GetString(12);
                    var opd = wipReader.IsDBNull(13) ? null : wipReader.GetString(13);
                    var otr = wipReader.IsDBNull(14) ? null : wipReader.GetString(14);
                    var oli = wipReader.IsDBNull(15) ? null : wipReader.GetString(15);
                    rtn.Add(new WipInfo()
                    {
                        Order = ord,
                        UnitId = uid,
                        UnitIdType = uit,
                        Updated = dte,
                        Equipment = eqm,
                        Station = stn,
                        Result = Converters.ResArrayToUnitState(res1, res2, res3, res4),
                        LockId = lid,
                        StationDescription = sdc,
                        LockComment = lcm,
                        ProductDescription = opd,
                        OrderTerminated = !string.IsNullOrEmpty(otr),
                        OrderLockComment = oli
                    });
                }

                wipReader.Close();
            }

            return rtn;
        }

        public async Task<string> GetPreUnitId(string unitId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wipLog.unit_id_in, wipLog.created " +
                    "FROM wip.t_wip_subset_log wipLog " +
                    $"WHERE wipLog.unit_id_out = '{unitId}' AND wipLog.transaction_type = 'unit_change'" +
                    "ORDER BY wipLog.created";
                cmd.CommandType = CommandType.Text;
                var preIdReader = await cmd.ExecuteReaderAsync(token);
                if (await preIdReader.ReadAsync(token))
                {
                    rtn = preIdReader.IsDBNull(0) ? null : preIdReader.GetString(0);
                }

                preIdReader.Close();
            }

            return rtn;
        }

        public async Task<string> GetNextUnitId(string unitId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wipLog.unit_id_out, wipLog.created " +
                    "FROM wip.t_wip_subset_log wipLog " +
                    $"WHERE wipLog.unit_id_in = '{unitId}' AND wipLog.transaction_type = 'unit_change'" +
                    "ORDER BY wipLog.created";
                cmd.CommandType = CommandType.Text;
                var nextIdReader = await cmd.ExecuteReaderAsync(token);
                if (await nextIdReader.ReadAsync(token))
                {
                    rtn = nextIdReader.IsDBNull(0) ? null : nextIdReader.GetString(0);
                }

                nextIdReader.Close();
            }

            return rtn;
        }

        public async Task<MamaInfo> GetMamaInfo(string unitId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = new MamaInfo();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT matCont.part_id, matCont.part_id_type, matDef.part_number, matCont.lock_descript, matCont.user_comment " +
                    "FROM mama.t_mat_container matCont " +
                    "JOIN mama.t_mat_def matDef ON matCont.mat_def_id = matDef.mat_def_id " +
                    $"WHERE matCont.part_id = '{unitId}' ";
                cmd.CommandType = CommandType.Text;
                var mamaReader = await cmd.ExecuteReaderAsync(token);
                if (await mamaReader.ReadAsync(token))
                {
                    rtn.PartId = mamaReader.IsDBNull(0) ? null : mamaReader.GetString(0);
                    rtn.PartNumber = mamaReader.IsDBNull(2) ? null : mamaReader.GetString(2);
                    rtn.PartIdType = mamaReader.IsDBNull(1) ? null : mamaReader.GetString(1);
                    rtn.LockId = mamaReader.IsDBNull(3) ? null : mamaReader.GetString(3);
                    rtn.UserComment = mamaReader.IsDBNull(4) ? null : mamaReader.GetString(4);
                }

                mamaReader.Close();
            }

            return rtn;
        }

        public async Task<CarmaInfo> GetCarmaPackageInfo(string subCarrierId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            
            var rtn = new CarmaInfo();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = "SELECT car.car_id, car.car_id_type, car.transaction_type, car.car_type, car.pos_id " +
                                  "FROM carma.t_car_subunit car " +
                                  $"WHERE car.subunit_id= '{subCarrierId}' " +
                                  "ORDER BY UPDATED DESC";
                cmd.CommandType = CommandType.Text;
                var carmaReader = await cmd.ExecuteReaderAsync(token);
                if (await carmaReader.ReadAsync(token))
                {
                    var id = carmaReader["car_id"].ToString();
                    var typ = carmaReader["car_id_type"].ToString();
                    var cty = carmaReader["car_type"].ToString();
                    var pos = carmaReader["pos_id"].ToString();
                    var trs = carmaReader["TRANSACTION_TYPE"].ToString();
                    rtn.CarrierId = id;
                    rtn.CarrierType = typ;
                    rtn.CarrierIdType = cty;
                    rtn.SubUnitPosition = pos;
                    var dte = string.Equals(trs, "Delete_Subunit", StringComparison.OrdinalIgnoreCase);
                    rtn.Deleted = dte;
                }
                carmaReader.Close();
            }
            
            return rtn;
        }

        public async Task<List<CarmaInfo>> GetCarmaInfo(string unitId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            
            var rtn = new List<CarmaInfo>();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = "SELECT car.car_id, car.car_id_type, car.transaction_type, car.car_type, car.pos_id " +
                                  "FROM carma.t_car_subunit_log car " +
                                  $"WHERE car.subunit_id= '{unitId}' " +
                                  "ORDER BY UPDATED DESC";
                cmd.CommandType = CommandType.Text;
                var carmaReader = await cmd.ExecuteReaderAsync(token);
                while (await carmaReader.ReadAsync(token))
                {
                    var id = carmaReader["car_id"].ToString();
                    var typ = carmaReader["car_id_type"].ToString();
                    var cty = carmaReader["car_type"].ToString();
                    var pos = carmaReader["pos_id"].ToString();
                    var trs = carmaReader["TRANSACTION_TYPE"].ToString();
                    if (rtn.Find(ci => ci.CarrierId == id) == null)
                    {
                        var dte = string.Equals(trs, "Delete_Subunit", StringComparison.OrdinalIgnoreCase);
                        rtn.Add(new CarmaInfo(){CarrierId = id, CarrierType = typ, CarrierIdType = cty, SubUnitPosition = pos, Deleted = dte});
                    }
                    else
                    {
                        rtn = rtn.Select(ci =>
                        {
                            if (ci.CarrierId != id) return ci;
                            if (string.Equals(trs, "Delete_Subunit", StringComparison.OrdinalIgnoreCase)) 
                            { ci.Deleted = true; }
                            return ci;
                        }).ToList();
                        
                    }
                }
                carmaReader.Close();
            }
            
            return rtn;
        }
        
        public async Task<List<CarmaSubUnitInfo>> GetCarmaSubUnitInfo(string carrierId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            
            var rtn = new List<CarmaSubUnitInfo>();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = "SELECT car.car_id, car.subunit_id, car.pos_id, car.subunit_id_type " +
                                  "FROM carma.t_car_subunit_log car " +
                                  $"WHERE car.car_id = '{carrierId}' " +
                                  "ORDER BY POS_ID";
                cmd.CommandType = CommandType.Text;
                var carmaReader = await cmd.ExecuteReaderAsync(token);
                while (await carmaReader.ReadAsync(token))
                {
                    var id = carmaReader["subunit_id"].ToString();
                    var pos = carmaReader["pos_id"].ToString();
                    var sty = carmaReader["subunit_id_type"].ToString();
                    if (rtn.Find(ci => ci.Id == id) == null)
                    {
                        rtn.Add(new CarmaSubUnitInfo(){Id = id, Position = pos, IdType = sty,Scrap = pos.Contains("S")});
                    }
                    else if(pos.Contains("S"))
                    {
                        rtn.Find(ci => ci.Id == id).Scrap = true;
                    }
                }
                carmaReader.Close();
            }
            
            return rtn;
        }

        public async Task<string> GetMaterialName(string material, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT matDef.part_number, matDef.part_name " +
                    "FROM mama.t_mat_def matDef " +
                    $"WHERE matDef.part_number = '{material}' ";
                cmd.CommandType = CommandType.Text;
                var matReader = await cmd.ExecuteReaderAsync(token);
                if (await matReader.ReadAsync(token))
                {
                    rtn = matReader.IsDBNull(1) ? null : matReader.GetString(1);
                }

                matReader.Close();
            }

            return rtn;
        }

        public async Task<List<BuildInfo>> GetBuildInfo(string unitId, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = new List<BuildInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT WIP.UNIT_ID_IN, WIP.UNIT_ID_IN_TYPE, WIP.created, partList.removed " +
                    "FROM WIP.t_wip_subset WIP " +
                    "JOIN WIP.t_wip_partslist partList ON partList.subset_id_l = WIP.subset_id_l " +
                    $"WHERE partList.PART_ID = '{unitId}' AND wip.job = partList.job " +
                    "ORDER BY wip.created";
                cmd.CommandType = CommandType.Text;
                var buildReader = await cmd.ExecuteReaderAsync(token);
                while (await buildReader.ReadAsync(token))
                {
                    rtn.Add(new BuildInfo()
                    {
                        IsPart = false,
                        UnitId = buildReader.IsDBNull(0) ? null : buildReader.GetString(0),
                        UnitIdType = buildReader.IsDBNull(1) ? null : buildReader.GetString(1),
                        Created = buildReader.IsDBNull(2) ? new DateTime() : buildReader.GetDateTime(2),
                        Removed = buildReader.IsDBNull(3) ? new DateTime() : buildReader.GetDateTime(3)
                    });
                }

                buildReader.Close();

                cmd.CommandText =
                    "SELECT partList.part_id, partList.part_id_type, partList.created, partList.removed " +
                    "FROM wip.t_wip_partslist partList " +
                    "JOIN wip.t_wip_subset wip ON partList.subset_id_l = wip.subset_id_l " +
                    $"WHERE wip.unit_id_in = '{unitId}' AND wip.job = partList.job " +
                    "ORDER BY partList.created";
                cmd.CommandType = CommandType.Text;
                buildReader = await cmd.ExecuteReaderAsync(token);
                while (await buildReader.ReadAsync(token))
                {
                    rtn.Add(new BuildInfo()
                    {
                        IsPart = true,
                        UnitId = buildReader.IsDBNull(0) ? null : buildReader.GetString(0),
                        UnitIdType = buildReader.IsDBNull(1) ? null : buildReader.GetString(1),
                        Created = buildReader.IsDBNull(2) ? new DateTime() : buildReader.GetDateTime(2),
                        Removed = buildReader.IsDBNull(3) ? new DateTime() : buildReader.GetDateTime(3)
                    });
                }

                buildReader.Close();
            }

            return rtn;
        }

        public async Task<MesUser> GetMesUserData(string username, CancellationToken token)
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = new MesUser();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT UA.LOGIN_NAME, UA.PASSWORD, UA.DESCRIPTION, UA.FIRST_NAME, UA.LAST_NAME " +
                    "FROM UA.T_USER UA " +
                    $"WHERE UA.LOGIN_NAME = '{username}' ";
                cmd.CommandType = CommandType.Text;
                var mesUserReader = await cmd.ExecuteReaderAsync(token);
                if (await mesUserReader.ReadAsync(token))
                {
                    rtn.LoginName = mesUserReader["LOGIN_NAME"].ToString();
                    rtn.Password = mesUserReader["PASSWORD"].ToString();
                    rtn.FirstName = mesUserReader["FIRST_NAME"].ToString();
                    rtn.LastName = mesUserReader["LAST_NAME"].ToString();
                }

                mesUserReader.Close();
            }

            return rtn;
        }

        public async Task<string[]> GetClmLabelTemplate(string templateName = null, string entryId = null, CancellationToken token = default(CancellationToken))
        {
            if (!ConnectionCheck()) await Connect();
            var rtn = new List<string>();
            using (var cmd = OraConnection.CreateCommand())
            {
                var adr = $"{(string.IsNullOrWhiteSpace(templateName) ? string.Empty : $"AND ent.KEY_NAME = '{templateName}'" )} {(string.IsNullOrWhiteSpace(entryId) ? string.Empty : $" AND ent.ENTRY_ID = '{entryId}' ")}";
                cmd.CommandText = "SELECT ent.PARENT_KEY_ID " +
                                  "FROM CLM.V_ALL_ENTRIES ent " +
                                  $"WHERE ent.ENTRY_NAME = 'Name' {adr} " +
                                  "ORDER BY UPDATED DESC";
                cmd.CommandType = CommandType.Text;
                
                var entryReader = await cmd.ExecuteReaderAsync(token);
                if (await entryReader.ReadAsync(token))
                {
                    var entry = entryReader["PARENT_KEY_ID"].ToString();
                    cmd.CommandText = "SELECT ent.TEXT_VALUE " +
                                      "FROM CLM.V_ALL_ENTRY_TEXT ent " +
                                      $"WHERE ent.ENTRY_NAME = 'Value' AND ent.PARENT_KEY_ID = '{entry}'" +
                                      "ORDER BY INDEX_NO";
                    cmd.CommandType = CommandType.Text;
                    var entryReader2 = await cmd.ExecuteReaderAsync(token);
                    while (await entryReader2.ReadAsync(token)) { rtn.Add(entryReader2["TEXT_VALUE"].ToString()); }
                }
            }
            return rtn.ToArray();
        }

        
        
        
        
        
    }
}