using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;
using System.Data.SqlClient;
using System.Threading;
using System.Windows.Forms;
using AnalyseToolExtension.DataObjects;

namespace AnalyseToolExtension.Clients
{
    public class PaDataBase
    {
        private static SqlConnection MsConnection { get; set; }

        private static string ConnString { get; } =
            "Data Source=BUDBSQL20;Initial Catalog=ProductionAnalyze;Persist Security Info=False;User ID=pa_read;Password=pa_read;TrustServerCertificate=True";
        
        public static Task Connect(CancellationToken token, string customConnectionString = null)
        {
            //DataBaseLogEvent?.Invoke(null, new DataBaseCommandArgs("Csatlakozás a MES adatbázishoz"));
            if (MsConnection != null)
            {
                MsConnection.Close();
                MsConnection.Dispose();
            }

            MsConnection = null;
            var cs = string.IsNullOrEmpty(customConnectionString)
                ? "Data Source=BUDBSQL20;Initial Catalog=ProductionAnalyze;Persist Security Info=False;User ID=pa_read;Password=pa_read;TrustServerCertificate=True"
                : customConnectionString;

            MsConnection = new SqlConnection(cs);

            try
            {
                MsConnection.OpenAsync(token);
                //DataBaseLogEvent?.Invoke(null, new DataBaseCommandArgs("Sikeres csatlakozás"));
                return Task.CompletedTask;
            }
            catch (Exception ex)
            {
                //throw new Exception(ex.Message, ex);
                //DataBaseLogEvent?.Invoke(null, new DataBaseCommandArgs("Sikertelen csatlakozás"));
                Task.FromException(ex);
            }

            return Task.CompletedTask;
        }
        
        private static bool ConnectionCheck()
        {
            try
            {
                //DataBaseLogEvent?.Invoke(null, new DataBaseCommandArgs("MES Kapcsolat ellenőrzése."));
                var si = MsConnection.Database;
                if (si != null) return true;
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
                //DataBaseLogEvent?.Invoke(null, new DataBaseCommandArgs("MES kapcsolat nem stabil."));
                return false;
            }

            return false;
        }

        public async Task<List<ProductAnalyzeInfo>> GetPaInfo(string unitId, CancellationToken token)
        {
            //if (!ConnectionCheck()) await Connect(token);
            var rtn = new List<ProductAnalyzeInfo>();

            try
            {
                using (var con = new SqlConnection(ConnString))
                {
                    con.Open();
                    var qry = "SELECT tabla.FullName, " +
                              "FORMAT (tabla.DetectionDate, 'yyyy-MM-dd HH:mm:ss') AS DetectionDate, " +
                              "tabla.DetectionStation, " +
                              "tabla.DetectedFault, " +
                              "tabla.Status, " +
                              "tabla.FullName2, " +
                              "FORMAT (tabla.Date2, 'yyyy-MM-dd HH:mm:ss') AS Date2, " +
                              "tabla.Status2, " +
                              "tabla.AnalyzeState, " +
                              "tabla.Message, " +
                              "sapm.Description, " +
                              "tabla.Customer " +
                              "FROM dbo.V_F_Analyze tabla " +
                              "JOIN V_L_SAPMaterials sapm ON tabla.SAP_ID = sapm.SAP_ID " +
                              $"WHERE UnitId = '{unitId}' " +
                              "ORDER BY DetectionDate DESC";
                    using (var com = new SqlCommand(qry, con))
                    {
                        using (var reader = com.ExecuteReader())
                        {
                            while (reader.Read())
                            {
                                var pai = new ProductAnalyzeInfo()
                                {
                                    DetectionUser = $"{reader["FullName"]}",
                                    DetectionDate = $"{reader["DetectionDate"]}",
                                    DetectionStation = $"{reader["DetectionStation"]}",
                                    DetectionFault = $"{reader["DetectedFault"]}",
                                    DetectionStatus = $"{reader["Status"]}",
                                    AnalyzerUser = $"{reader["FullName2"]}",
                                    AnalyzerDate = $"{reader["Date2"]}",
                                    AnalyzerStatus = $"{reader["Status2"]}",
                                    AnalyzeState = $"{reader["AnalyzeState"]}",
                                    AnalyzeDescription = $"{reader["Message"]}",
                                };
                                rtn.Add(pai);
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            
            
            return rtn;
        }
    }
}