using System;
using System.Data;
using System.Data.SqlClient;
using System.Threading;
using System.Threading.Tasks;

namespace AnalyseToolExtension.Clients
{
    public class ProductAnalyzeClient
    {
        public static SqlConnection MsConnection { get; private set; }
        private const string ConString = "Data Source=BUDBSQL20;Initial Catalog=ProductionAnalyze;Persist Security Info=False;User ID=pa_read;Password=pa_read;TrustServerCertificate=True";
        
        public static async Task Connect(string customConnectionString = null, bool directConnect = false)
        {
            if (await ConnectionCheck() && !directConnect) return;
            
            if (MsConnection != null && directConnect) { await Disconnect(); }
            
            var cs = string.IsNullOrEmpty(customConnectionString) ? ConString : customConnectionString;

            Console.WriteLine("ProductAnalyze database connecting...");
            MsConnection = new SqlConnection(cs);

            try
            {
                MsConnection.Open();
                Console.WriteLine("ProductAnalyze database connection successful.");
            }
            catch (Exception ex) { await Task.FromException(ex); }
        }
        
        public static Task<bool> ConnectionCheck()
        {
            if (MsConnection == null) return Task.FromResult(false);

            try
            {
                /*using (var cmd = new SqlCommand("SELECT 1 FROM DUAL",MsConnection))
                {
                    try
                    {
                        cmd.ExecuteScalar();
                    }
                    catch (Exception e) { return Task.FromResult(false); }
                }*/
                return Task.FromResult(MsConnection.State == ConnectionState.Open && MsConnection.State != ConnectionState.Broken);
            }
            catch (Exception e) { Task.FromException(e); }

            return Task.FromResult(false);
        }
        
        public static Task Disconnect()
        {
            if (MsConnection == null) return Task.FromResult(false);
            try
            {
                MsConnection.Close(); 
                MsConnection.Dispose();
                MsConnection = null;
                return Task.CompletedTask;
            }
            catch (Exception e) { Task.FromException(e); }
            return Task.FromResult(false);
        }
    }
}