using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace AnalyseToolExtension.DataObjects
{
    public class Andon
    {
        public AndonDefinition Definition { get; set; }
        public List<AndonHourTarget> Targets { get; set; }
        public List<AndonStationFlow> Stations { get; set; }

        public void Calculate()
        {
            /*if (Stations == null) return;
            if (Stations.Count <= 0) return;
            try
            {
                var lsh = Stations.FindAll(st => st.IsLast);
                var lth = lsh.SelectMany(sh => sh.Hours).ToList() ?? new List<AndonHour>();
                if (lth.Count <= 0) return;
                ShiftActual = lth.Sum(hs => hs.YieldRun);
                ShiftNok = Stations.Sum(str => str.Hours.Sum(hsr => hsr.FirstFailQty));
                var lst = new List<AndonHour>();
                foreach (var hour in lth.Where(hour => !lst.Exists(hr=>hr.Hour == hour.Hour))) { lst.Add(hour); }
                ShiftPlan = lst.Sum(hs => hs.TargetQty);
                var dtn = DateTime.Now;
                var dts = Date;
                dts = new DateTime(dts.Year, dts.Month, dts.Day, 06,00,00);
                if (IsNightShift) { dts = new DateTime(dts.Year, dts.Month, dts.Day, 18,00,00); }
                var wds = 12 * 60 * 60;
                var ess = (double)(dtn - dts).TotalSeconds;
                if (ess < 0 || ess > wds)
                {
                    if (ess < 0) { ShiftExpect = 0; }
                    if (ess > wds) { ShiftExpect = ShiftPlan; }
                }
                else
                {
                    var pps = (double)ShiftPlan / wds;
                    var exp = pps * ess;
                    //ShiftExpect = int.Parse($"{Math.Ceiling(exp):0000}");
                    ShiftExpect = int.Parse($"{Math.Floor(exp):0000}");
                }

                ShiftStatus = ShiftActual - ShiftExpect;
            }
            catch (Exception ex){ return; }*/
        }

        public async Task RefreshAndon()
        {
            /*var adb = await new AnalyseToolExtension.Clients.MesDataBase().GetAndonLine(this.Name,this.Date, this.IsNightShift);
            StdHourlyQty = adb.StdHourlyQty;
            Stations = adb.Stations;
            RawData = adb.RawData;
            MaterialInOut = adb.MaterialInOut;
            AdministratorNames = adb.AdministratorNames;
            this.Calculate();*/
        }
    }

    public class AndonDefinition
    {
        public string Name { get; set; }
        public string Building { get; set; }
        public string Shift { get; set; }
        public string ProductIn { get; set; }
        public string ProductOut { get; set; }
        public string[] Administrators { get; set; }
        public int StandardHourlyQty { get; set; }
    }

    public class AndonHourTarget
    {
        public DateTime? Hour { get; set; }
        public int Target { get; set; }
        public int YieldQty { get; set; }
        public int FirstPass { get; set; }
        public AndonTargetSetter Setter { get; set; }
    }

    public class AndonTargetSetter
    {
        public string User { get; set; }
        public string Comment { get; set; }
        public DateTime? Date { get; set; }
    }

    public class AndonSearchSettings
    {
        public string LineName { get; set; } = string.Empty;
        public bool StationFlow { get; set; } = true;
        public bool HourTarget { get; set; } = true;
        public bool AutoCalculate { get; set; } = true;

        public DateTime StartDate { get; set; } =
            new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, 6, 0, 0);

        public DateTime EndDate { get; set; } =
            new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, 18, 0, 0);

    }

    public class AndonStationFlow
    {
        public string Name { get; set; }
        public string Equipment { get; set; }
        public string Operator { get; set; }
        public int FirstEscalation { get; set; }
        public int SecondEscalation { get; set; }
        public string TransactionType { get; set; }
        public int Flow { get; set; }
        public bool IsFirst { get; set; }
        public bool IsLast { get; set; }
        public bool IsLocked { get; set; }
        public DateTime? LastUsed { get; set; }
        public int FirstPass { get; set; }
        public int FirstFail { get; set; }
        public int YieldQty { get; set; }
        public int TotalRun { get; set; }
        public double TotalFpyPercentage { get; set; }

    }
}