using System.Collections.Generic;
using System.Text;

namespace AnalyseToolExtension.DataObjects
{
    public static class Converters
    {
        public static UnitState StringToUnitState(string unitState)
        {
            switch (unitState)
            {
                case "PASS" : return UnitState.Pass;
                case "P" : return UnitState.Pass;
                case "FAIL" : return UnitState.Fail;
                case "F" : return UnitState.Fail;
                case "SCRAP" : return UnitState.Scrap;
                case "S" : return UnitState.Scrap;
                case "CHACKIN" : return UnitState.CheckIn;
                case "C" : return UnitState.CheckIn;
            }
            return UnitState.None;
        }
        public static string UnitStateToString(UnitState unitState)
        {
            switch (unitState)
            {
                case UnitState.None: return "";
                case UnitState.Pass: return "PASS";
                case UnitState.Fail: return "FAIL";
                case UnitState.Scrap: return "SCRAP";
                case UnitState.CheckIn: return "CHACKIN";
                default: return "";
            }
        }
        public static UnitState ResArrayToUnitState(string res1, string res2, string res3, string res4)
        {
            if (res1 != "0") return UnitState.CheckIn;
            if (res2 != "0") return UnitState.Fail;
            if (res3 != "0") return UnitState.Pass;
            if (res4 != "0") return UnitState.Scrap;
            return UnitState.None;
        }
        
        public static char[] GetPasswordShifts(string ecd, string kwt)
        {
            var sft = new char[ecd.Length];
            for (var i = 0; i < ecd.Length; i++)
            {
                sft[i] = (char)(ecd[i] ^ kwt[i]);
            }
            return sft;
        }

        public static string DecryptPassword(string text, char[] shifts)
        {
            var decrypted = new StringBuilder();
            for (var i = 0; i < text.Length; i++)
            {
                decrypted.Append((char)(text[i] ^ shifts[i]));
            }

            return decrypted.ToString();
        }
        
        public static Dictionary<char, char> GenerateSubstitutionTable(Dictionary<string, string> knownPairs)
        {
            var table = new Dictionary<char, char>();

            foreach (var pair in knownPairs)
            {
                string encrypted = pair.Key;
                string decrypted = pair.Value;

                for (int i = 0; i < encrypted.Length; i++)
                {
                    if (!table.ContainsKey(encrypted[i]))
                    {
                        table[encrypted[i]] = decrypted[i];
                    }
                }
            }

            return table;
        }

        public static string DecryptUsingTable(string encryptedText, Dictionary<char, char> table)
        {
            StringBuilder decrypted = new StringBuilder();

            foreach (char c in encryptedText)
            {
                if (table.ContainsKey(c))
                {
                    decrypted.Append(table[c]);
                }
                else
                {
                    // Ha a karakter nincs a táblában, ismeretlen karakterként kezeljük
                    decrypted.Append('?');
                }
            }

            return decrypted.ToString();
        }
    }
}