using System;

namespace AnalyseToolExtension.DataObjects
{
    public class EvaInfo : QueryObject
    {
        public EvaInfo() { this.Query  = "EvaInfo"; }
        public string UnitId { get; set; } = "";
        public string UnitIdType { get; set; } = "";
        public string Material { get; set; } = "";
        public string TestPlanVersion { get; set; } = "";
        public string TestPlanName { get; set; } = "";
        public string Station { get; set; } = "";
        public UnitState Result { get; set; } = UnitState.None;
        public DateTime? DateTime { get; set; }
        public string Bin { get; set; } = "";
        public string TestPlanGroup { get; set; } = "";
        public string Order { get; set; } = "";
        public string TestSoftware { get; set; } = "";
        public string TestSoftwareVersion { get; set; } = "";
        public string TestSoftwareType { get; set; } = "";
        public string KeyPrt { get; set; } = "";
        public string SeqKey { get; set; } = "";
    }
    
    public class EvaTestInfo : QueryObject
    {
        public EvaTestInfo() { this.Query  = "EvaTestInfo"; }
        public string Sequence { get; set; } = "";
        public string SubSequence { get; set; } = "";
        public string Id { get; set; } = "";
        public string Description { get; set; } = "";
        public float? Value { get; set; } = 0F;
        public float? MinValue { get; set; } = 0F;
        public float? MaxValue { get; set; } = 0F;
        public UnitState Result { get; set; } = UnitState.None;
        public string ValueType { get; set; } = "";
        public string Attribute { get; set; } = "";
        public string TextInfo { get; set; } = "";
    }
}