using System;

namespace AnalyseToolExtension.DataObjects
{
    public class ProductAnalyzeInfo : QueryObject
    {
        public ProductAnalyzeInfo(){this.Query  = "ProductAnalyzeInfo";}
        public string DetectionUser { get; set; } //FullName
        public string DetectionDate { get; set; }
        public string DetectionStation { get; set; }
        public string DetectionFault { get; set; }
        public string DetectionStatus { get; set; } //Status
        
        public string AnalyzerUser { get; set; } //FullName2
        public string AnalyzerDate { get; set; } //Date2
        public string AnalyzerStatus { get; set; } //Status2
        public string AnalyzeState { get; set; }
        
        public string AnalyzeDescription { get; set; } //Message

        public bool RegistryLevel => !string.IsNullOrEmpty(DetectionUser) || !string.IsNullOrEmpty(DetectionDate) ||
                                     !string.IsNullOrEmpty(DetectionStation) || !string.IsNullOrEmpty(DetectionFault) ||
                                     !string.IsNullOrEmpty(DetectionStatus);

        public bool AnalyzerLevel => !string.IsNullOrEmpty(AnalyzerUser) || !string.IsNullOrEmpty(AnalyzerDate) ||
                                     !string.IsNullOrEmpty(AnalyzerStatus) || !string.IsNullOrEmpty(AnalyzeState);

        public bool DescriptionLevel => !string.IsNullOrEmpty(AnalyzeDescription);
        
        public string Plant { get; set; }
        public string Building { get; set; }
        public string FocusFactory { get; set; }
        public string ProductFamily { get; set; }
        public string UnitId { get; set; }
        public string UnitIdType { get; set; }
        public string SubsetId { get; set; }
        public string SapId { get; set; }
        public string Location { get; set; }
        public string Order { get; set; }
        public string ProductionVersion { get; set; }
        public string Customer { get; set; }
        public string ProductType { get; set; }
        public string Subgroup { get; set; }
    }
    public class ProductAnalyzeInfo2 : QueryObject
    {
        public string Plant { get; set; }
        public string Building { get; set; }
        public string FocusFactory  { get; set; }
        public string ProductFamily { get; set; }
        public string UnitId { get; set; }
        public string UnitIdType { get; set; }
        public string Material { get; set; }
        public string Subset { get; set; }
        public string Location { get; set; }
        public string Order { get; set; }
        public string ProductionVersion { get; set; }
        public string Customer  { get; set; }
        public string ProductType { get; set; }
        public string SubGroup { get; set; }
        public string Message { get; set; }
        public string Protocol { get; set; }
        public string ProtocolType { get; set; }
        public string CostCollection  { get; set; }
        public string Price  { get; set; }
        public string Week { get; set; }
        public string Shift { get; set; }
        public string ComputerName { get; set; }
        public string MesStation { get; set; }
        public DateTime? MesDate { get; set; }
        public ProductAnalyzeInfo2Record Detection { get; set; } =  new ProductAnalyzeInfo2Record();
        public ProductAnalyzeInfo2Record Causer { get; set; } =  new ProductAnalyzeInfo2Record();
        public ProductAnalyzeMaterialInfo MaterialInfo { get; set; } = new ProductAnalyzeMaterialInfo();
    }

    public class ProductAnalyzeInfo2Record
    {
        public string Building { get; set; }
        public string Production { get; set; }
        public string Line { get; set; }
        public string Station { get; set; }
        public string OperationNumber { get; set; }
        public string WorkCenterGroup  { get; set; }
        public string Fault  { get; set; }
        public string Params { get; set; }
        public string Status { get; set; }
        public string AnalyzeState { get; set; }
        public DateTime? Date {get;set;}
        public string User { get; set; }
        public string UserFullName { get; set; }
    }

    public class ProductAnalyzeMaterialInfo
    {
        public string Material { get; set; }
        public string Plant { get; set; }
        public string FocusFactory { get; set; }
        public string ProductFamily { get; set; }
        public string Type { get; set; }
        public string Description { get; set; }
        public string Customer  { get; set; }
        public string ProductType { get; set; }
        public string SubGroup { get; set; }
        public string Quantity { get; set; }
        public string Unit  { get; set; }
        public string Price { get; set; }
        public string CustomerPrice { get; set; }
        public bool IsActive  { get; set; }
        public string StorageLocation { get; set; }
        public string SaMag { get; set; }
    }
}