using System;
using System.Threading;
using System.Threading.Tasks;
using AnalyseToolExtension.DataObjects;
using static AnalyseToolExtension.Query.MesQuery;
using static AnalyseToolExtension.Query.ProductAnalyseQuery;

namespace AnalyseToolExtension.Query
{
    public class ComplexQuery
    {
        #region ComplexQuery

        public async Task<UnitInfo> GetUnitInfo(string unitId, CancellationToken token = new CancellationToken())
        {
            await AnalyseToolExtension.Clients.MesClient.Connect();
            await AnalyseToolExtension.Clients.ProductAnalyzeClient.Connect();
            var rtn = new UnitInfo
            {
                UnitId = unitId
            };

            var preId = await GetPreUnitId(unitId, token);
            rtn.PreUnitId = preId;
            
            var nextId = await GetNextUnitId(unitId, token);
            rtn.NextUnitId = nextId;
            
            var evaRun = await GetEvaInfo(unitId, token);
            rtn.EvaInfo = evaRun;
            
            var wipRun = await GetWipInfo(unitId, token);
            rtn.WipInfo = wipRun;
            
            var mama = await GetMamaInfo(unitId, token);
            
            var buildInfo = await GetBuildInfo(unitId, token);
            rtn.BuildInfos = buildInfo;

            var pai = await GetProductAnalyzeInfo(unitId, token);
            rtn.ProductAnalyzeInfo = pai;

            if (wipRun?.Count > 0)
            {
                //ar wipStatus = UnitStatus.None;
                switch (wipRun?[0].Result)
                {
                    case UnitState.None: rtn.WipMama = UnitStatus.None; break;
                    case UnitState.Pass:
                    case UnitState.CheckIn: 
                    case UnitState.Fail: rtn.WipMama = UnitStatus.Wip; break;
                    case UnitState.Scrap: rtn.WipMama = UnitStatus.Scrap; break;
                }
                rtn.UnitIdType = wipRun[0].UnitIdType;
                rtn.Order = wipRun[0].Order;
                rtn.Material = wipRun[0].ProductDescription;
                rtn.Description = await GetMaterialName(rtn.Material, token);
            }

            if (!string.IsNullOrEmpty(mama?.PartNumber))
            {
                rtn.WipMama = UnitStatus.Mama;
                rtn.UnitIdType = mama.PartIdType;
                rtn.Material = mama.PartNumber;
                rtn.Description = await GetMaterialName(rtn.Material, token);
            }

            if (wipRun?.Count > 0 && wipRun[0].Result != UnitState.None && !string.IsNullOrEmpty(mama?.PartNumber))
            {
                rtn.WipMama = UnitStatus.WipMama;
                rtn.UnitIdType = $"[WIP] {wipRun[0].UnitIdType} | [MAMA] {mama.PartIdType}";
                rtn.Material = $"[WIP] {wipRun[0].ProductDescription} | [MAMA] {mama.PartNumber}";
                
            }
            if (wipRun?.Count <= 0 && string.IsNullOrEmpty(mama?.PartNumber)) rtn.WipMama = UnitStatus.None;
            
            var carma = await GetCarmaInfo(unitId, token);
            if (carma?.Count > 0)
            {
                rtn.CarrierId = carma[0].CarrierId;
            }
            
            return rtn;
        }

        #endregion
    }
}