using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AnalyseToolExtension.DataObjects;
using AnalyseToolExtension.QueryCodes;
using static AnalyseToolExtension.Clients.MesClient;

namespace AnalyseToolExtension.Query
{
    public class MesQuery
    {
        
        #region Wip

        public static async Task<List<WipInfo>> GetWipInfo(string unitId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<WipInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wip.job AS Order_info, wip.unit_id_in, wip.unit_id_in_type, wip.updated, wip.equipment, wip.sub_device, wip.qty_checkin, wip.qty_fail, wip.qty_yield, wip.qty_loss, wip.lock_descript, wipproc.description_short, wiplock.user_comment, wipjob.product_definition, wipjob.terminated, wipjob.lock_descript " +
                    "FROM wip.t_wip_subset wip " +
                    "JOIN wip.t_wip_process_step wipProc ON wip.process_step = wipProc.process_step AND wip.process_step_id = wipProc.process_step_id AND wip.job = wipProc.job " +
                    "JOIN wip.t_wip_job wipJob ON wip.job = wipJob.job " +
                    "LEFT JOIN wip.t_wip_lock wiplock ON wip.lock_descript = wiplock.lock_descript " +
                    $"WHERE wip.unit_id_in = '{unitId}' " +
                    "ORDER BY wip.updated DESC";
                cmd.CommandType = CommandType.Text;
                var wipReader = await cmd.ExecuteReaderAsync(token);
                while (wipReader.ReadAsync(token).Result)
                {
                    var ord = wipReader.IsDBNull(0) ? null : wipReader.GetString(0);
                    var uid = wipReader.IsDBNull(1) ? null : wipReader.GetString(1);
                    var uit = wipReader.IsDBNull(2) ? null : wipReader.GetString(2);
                    var dte = wipReader.IsDBNull(3) ? new DateTime() : wipReader.GetDateTime(3);
                    ;
                    var eqm = wipReader.IsDBNull(4) ? null : wipReader.GetString(4);
                    var stn = wipReader.IsDBNull(5) ? null : wipReader.GetString(5);
                    var res1 = wipReader.IsDBNull(6) ? null : wipReader.GetString(6);
                    var res2 = wipReader.IsDBNull(7) ? null : wipReader.GetString(7);
                    var res3 = wipReader.IsDBNull(8) ? null : wipReader.GetString(8);
                    var res4 = wipReader.IsDBNull(9) ? null : wipReader.GetString(9);
                    var lid = wipReader.IsDBNull(10) ? null : wipReader.GetString(10);
                    var sdc = wipReader.IsDBNull(11) ? null : wipReader.GetString(11);
                    var lcm = wipReader.IsDBNull(12) ? null : wipReader.GetString(12);
                    var opd = wipReader.IsDBNull(13) ? null : wipReader.GetString(13);
                    var otr = wipReader.IsDBNull(14) ? null : wipReader.GetString(14);
                    var oli = wipReader.IsDBNull(15) ? null : wipReader.GetString(15);
                    rtn.Add(new WipInfo()
                    {
                        Order = ord,
                        UnitId = uid,
                        UnitIdType = uit,
                        Updated = dte,
                        Equipment = eqm,
                        Station = stn,
                        Result = Converters.ResArrayToUnitState(res1, res2, res3, res4),
                        LockId = lid,
                        StationDescription = sdc,
                        LockComment = lcm,
                        ProductDescription = opd,
                        OrderTerminated = !string.IsNullOrEmpty(otr),
                        OrderLockComment = oli
                    });
                }

                wipReader.Close();
            }

            return rtn;
        }
        public static async Task<string> GetPreUnitId(string unitId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wipLog.unit_id_in, wipLog.created " +
                    "FROM wip.t_wip_subset_log wipLog " +
                    $"WHERE wipLog.unit_id_out = '{unitId}' AND wipLog.transaction_type = 'unit_change'" +
                    "ORDER BY wipLog.created";
                cmd.CommandType = CommandType.Text;
                var preIdReader = await cmd.ExecuteReaderAsync(token);
                if (await preIdReader.ReadAsync(token))
                {
                    rtn = preIdReader.IsDBNull(0) ? null : preIdReader.GetString(0);
                }

                preIdReader.Close();
            }
            
            return unitId == rtn ? string.Empty : rtn;
        }
        public static async Task<string> GetNextUnitId(string unitId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wipLog.unit_id_out, wipLog.created " +
                    "FROM wip.t_wip_subset_log wipLog " +
                    $"WHERE wipLog.unit_id_in = '{unitId}' AND wipLog.transaction_type = 'unit_change'" +
                    "ORDER BY wipLog.created";
                cmd.CommandType = CommandType.Text;
                var nextIdReader = await cmd.ExecuteReaderAsync(token);
                if (await nextIdReader.ReadAsync(token))
                {
                    rtn = nextIdReader.IsDBNull(0) ? null : nextIdReader.GetString(0);
                }

                nextIdReader.Close();
            }

            return unitId == rtn ? string.Empty : rtn;
        }
        public static async Task<List<BuildInfo>> GetBuildInfo(string unitId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<BuildInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("BuildInfoPax", "BuildInFullInfo", new Dictionary<string, string>()
                {
                    { ":unitId", unitId }
                });
                cmd.CommandType = CommandType.Text;
                var buildReader = await cmd.ExecuteReaderAsync(token);
                while (await buildReader.ReadAsync(token))
                {
                    var uid = buildReader["UNIT_ID"].ToString();
                    var find = rtn.Find(bi => bi.UnitId == uid && bi.IsPart == true);
                    if (find != null)
                    {
                        find.StackCount += 1;
                    }
                    else
                    {
                        rtn.Add(new BuildInfo()
                        {
                            IsPart = true,
                            Created = buildReader.IsDBNull(buildReader.GetOrdinal("CREATED")) ? (DateTime?)null : buildReader.GetDateTime(buildReader.GetOrdinal("CREATED")),
                            Removed = buildReader.IsDBNull(buildReader.GetOrdinal("REMOVED")) ? (DateTime?)null : buildReader.GetDateTime(buildReader.GetOrdinal("REMOVED")),
                            Description = buildReader["DESCRIPTION"].ToString(),
                            UnitId = buildReader["UNIT_ID"].ToString(),
                            UnitIdType = buildReader["UNIT_ID_TYPE"].ToString(),
                        });
                    }
                    
                }

                buildReader.Close();

                cmd.CommandText = QuerySelector.Get("BuildInfoPax", "BuildOutFullInfo", new Dictionary<string, string>()
                {
                    { ":unitId", unitId }
                });
                cmd.CommandType = CommandType.Text;
                buildReader = await cmd.ExecuteReaderAsync(token);
                while (await buildReader.ReadAsync(token))
                {
                    var uid = buildReader["UNIT_ID"].ToString();
                    var find = rtn.Find(bi => bi.UnitId == uid && bi.IsPart == false);
                    if (find != null)
                    {
                        find.StackCount += 1;
                    }
                    else
                    {
                        rtn.Add(new BuildInfo()
                        {
                            IsPart = false,
                            Created = buildReader.IsDBNull(buildReader.GetOrdinal("CREATED")) ? (DateTime?)null : buildReader.GetDateTime(buildReader.GetOrdinal("CREATED")),
                            Removed = buildReader.IsDBNull(buildReader.GetOrdinal("REMOVED")) ? (DateTime?)null : buildReader.GetDateTime(buildReader.GetOrdinal("REMOVED")),
                            Description = buildReader["DESCRIPTION"].ToString(),
                            UnitId = buildReader["UNIT_ID"].ToString(),
                            UnitIdType = buildReader["UNIT_ID_TYPE"].ToString(),
                        });
                    }
                    
                }

                buildReader.Close();
            }

            return rtn;
        }

        #endregion
        #region Eva

        public static async Task<List<EvaInfo>> GetEvaInfo(string unitId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<EvaInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("EvaInfo", new Dictionary<string, string>()
                {
                    { ":unitId", unitId }
                });
                cmd.CommandType = CommandType.Text;
                var evaReader = await cmd.ExecuteReaderAsync(token);
                while (evaReader.ReadAsync(token).Result)
                {
                    var id = evaReader["RUNID"].ToString();
                    var idType = evaReader["ID_TYPE"].ToString();
                    var date = evaReader.IsDBNull(evaReader.GetOrdinal("RUN_DATE"))
                        ? (DateTime?)null
                        : evaReader.GetDateTime(evaReader.GetOrdinal("RUN_DATE"));
                    var result = Converters.StringToUnitState(evaReader["RESULT"].ToString());
                    var bin = evaReader["BIN_NUM"].ToString();
                    var station = evaReader["STATION"].ToString();
                    var mat = evaReader["MATERIAL"].ToString();
                    var tsw = evaReader["TSW"].ToString();
                    var tswVersion = evaReader["TSW_VERSION"].ToString();
                    var tswType = evaReader["TSW_Type"].ToString();
                    var testPlan  = evaReader["TESTPLAN"].ToString();
                    var testPlanVersion = evaReader["TESTPLAN_VERSION"].ToString();
                    var testPlanGroup = evaReader["TESTPLAN_GROUP"].ToString();
                    var job = evaReader["JOB"].ToString();
                    var key = evaReader["KEY"].ToString();
                    var seq = evaReader["SEQ"].ToString();
                    rtn.Add(new EvaInfo()
                    {
                        UnitId = id,
                        UnitIdType = idType,
                        DateTime = date,
                        Result = result,
                        Bin = bin,
                        Station = station,
                        Material = mat,
                        TestSoftware = tsw,
                        TestSoftwareVersion = tswVersion,
                        TestSoftwareType = tswType,
                        TestPlanName = testPlan,
                        TestPlanVersion = testPlanVersion,
                        TestPlanGroup = testPlanGroup,
                        Order = job,
                        KeyPrt = key,
                        SeqKey = seq
                    });
                }

                evaReader.Close();
            }

            return rtn;
        }
        public static async Task<List<EvaTestInfo>> GetEvaTestInfo(string unitId, string key, string seq, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<EvaTestInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("EvaTestRun", new Dictionary<string, string>()
                {
                    { ":unitId", unitId },
                    { ":key", key },
                    { ":seq", seq }
                });
                cmd.CommandType = CommandType.Text;
                var evaTrReader = await cmd.ExecuteReaderAsync(token);
                while (evaTrReader.ReadAsync(token).Result)
                {
                    var sequence = evaTrReader["ORDER_ID"].ToString();
                    var subSequence = evaTrReader["SUB_ORDER_ID"].ToString();
                    var testId = evaTrReader["TEST_ID"].ToString();
                    var desc = evaTrReader["DESCRIPTION"].ToString();
                    var val = float.TryParse(evaTrReader["VALUE"].ToString(), out var value) ? value : float.NaN;
                    var res = Converters.StringToUnitState(evaTrReader["RESULT"].ToString());
                    var minVal = float.TryParse(evaTrReader["MIN_VAL"].ToString(), out var min) ? min : float.NaN;
                    var maxVal = float.TryParse(evaTrReader["MAX_VAL"].ToString(), out var max) ? max : float.NaN;
                    var valTyp = evaTrReader["VALUE_TYPE"].ToString();
                    var att = evaTrReader["ATTRIBUTE"].ToString();
                    var ttx = evaTrReader["TEST_TEXTINFO"].ToString();
                    rtn.Add(new EvaTestInfo()
                    {
                        Sequence = sequence,
                        SubSequence = subSequence,
                        Id = testId,
                        Description = desc,
                        Value = val,
                        Result = res,
                        MinValue = minVal,
                        MaxValue = maxVal,
                        ValueType = valTyp,
                        Attribute = att,
                        TextInfo = ttx,
                    });
                }

                evaTrReader.Close();
            }

            return rtn;
        }
        public static async Task<string> GetEvaTestTextInfo(string unitId, string key, string seq, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT ted2.txt_info " +
                    "FROM evaprod.pd_lfd_run plr " +
                    "JOIN evaprod.pd_lfd_ted2 ted2 ON plr.run_key_prt = ted2.run_key_prt AND plr.run_seq_key = ted2.run_seq_key " +
                    $"WHERE plr.runid = '{unitId}' AND plr.run_key_prt = '{key}' AND plr.run_seq_key = '{seq}'";
                cmd.CommandType = CommandType.Text;
                var tiReader = await cmd.ExecuteReaderAsync(token);
                if (await tiReader.ReadAsync(token))
                {
                    rtn = tiReader.IsDBNull(0) ? null : tiReader.GetString(0);
                }
                tiReader.Close();
            }
            return rtn;
            
        }

        #endregion
        #region Carma
        
        public static async Task<CarmaInfo> GetCarmaPackageInfo(string subCarrierId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            
            var rtn = new CarmaInfo();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = "SELECT car.car_id, car.car_id_type, car.transaction_type, car.car_type, car.pos_id " +
                                  "FROM carma.t_car_subunit car " +
                                  $"WHERE car.subunit_id= '{subCarrierId}' " +
                                  "ORDER BY UPDATED DESC";
                cmd.CommandType = CommandType.Text;
                var carmaReader = await cmd.ExecuteReaderAsync(token);
                if (await carmaReader.ReadAsync(token))
                {
                    var id = carmaReader["car_id"].ToString();
                    var typ = carmaReader["car_id_type"].ToString();
                    var cty = carmaReader["car_type"].ToString();
                    var pos = carmaReader["pos_id"].ToString();
                    var trs = carmaReader["TRANSACTION_TYPE"].ToString();
                    rtn.CarrierId = id;
                    rtn.CarrierType = typ;
                    rtn.CarrierIdType = cty;
                    rtn.SubUnitPosition = pos;
                    var dte = string.Equals(trs, "Delete_Subunit", StringComparison.OrdinalIgnoreCase);
                    rtn.Deleted = dte;
                }
                carmaReader.Close();
            }
            
            return rtn;
        }
        public static async Task<List<CarmaInfo>> GetCarmaInfo(string unitId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            
            var rtn = new List<CarmaInfo>();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = "SELECT car.car_id, car.car_id_type, car.transaction_type, car.car_type, car.pos_id " +
                                  "FROM carma.t_car_subunit_log car " +
                                  $"WHERE car.subunit_id= '{unitId}' " +
                                  "ORDER BY UPDATED DESC";
                cmd.CommandType = CommandType.Text;
                var carmaReader = await cmd.ExecuteReaderAsync(token);
                while (await carmaReader.ReadAsync(token))
                {
                    var id = carmaReader["car_id"].ToString();
                    var typ = carmaReader["car_id_type"].ToString();
                    var cty = carmaReader["car_type"].ToString();
                    var pos = carmaReader["pos_id"].ToString();
                    var trs = carmaReader["TRANSACTION_TYPE"].ToString();
                    if (rtn.Find(ci => ci.CarrierId == id) == null)
                    {
                        var dte = string.Equals(trs, "Delete_Subunit", StringComparison.OrdinalIgnoreCase);
                        rtn.Add(new CarmaInfo(){CarrierId = id, CarrierType = typ, CarrierIdType = cty, SubUnitPosition = pos, Deleted = dte});
                    }
                    else
                    {
                        rtn = rtn.Select(ci =>
                        {
                            if (ci.CarrierId != id) return ci;
                            if (string.Equals(trs, "Delete_Subunit", StringComparison.OrdinalIgnoreCase)) 
                            { ci.Deleted = true; }
                            return ci;
                        }).ToList();
                        
                    }
                }
                carmaReader.Close();
            }
            
            return rtn;
        }
        public static async Task<List<CarmaSubUnitInfo>> GetCarmaSubUnitInfo(string carrierId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            
            var rtn = new List<CarmaSubUnitInfo>();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = "SELECT car.car_id, car.subunit_id, car.pos_id, car.subunit_id_type " +
                                  "FROM carma.t_car_subunit_log car " +
                                  $"WHERE car.car_id = '{carrierId}' " +
                                  "ORDER BY POS_ID";
                cmd.CommandType = CommandType.Text;
                var carmaReader = await cmd.ExecuteReaderAsync(token);
                while (await carmaReader.ReadAsync(token))
                {
                    var id = carmaReader["subunit_id"].ToString();
                    var pos = carmaReader["pos_id"].ToString();
                    var sty = carmaReader["subunit_id_type"].ToString();
                    if (rtn.Find(ci => ci.Id == id) == null)
                    {
                        rtn.Add(new CarmaSubUnitInfo(){Id = id, Position = pos, IdType = sty,Scrap = pos.Contains("S")});
                    }
                    else if(pos.Contains("S"))
                    {
                        rtn.Find(ci => ci.Id == id).Scrap = true;
                    }
                }
                carmaReader.Close();
            }
            
            return rtn;
        }
        
        #endregion
        #region Mama

        public static async Task<MamaInfo> GetMamaInfo(string unitId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new MamaInfo();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT matCont.part_id, matCont.part_id_type, matDef.part_number, matCont.lock_descript, matCont.user_comment " +
                    "FROM mama.t_mat_container matCont " +
                    "JOIN mama.t_mat_def matDef ON matCont.mat_def_id = matDef.mat_def_id " +
                    $"WHERE matCont.part_id = '{unitId}' ";
                cmd.CommandType = CommandType.Text;
                var mamaReader = await cmd.ExecuteReaderAsync(token);
                if (await mamaReader.ReadAsync(token))
                {
                    rtn.PartId = mamaReader.IsDBNull(0) ? null : mamaReader.GetString(0);
                    rtn.PartNumber = mamaReader.IsDBNull(2) ? null : mamaReader.GetString(2);
                    rtn.PartIdType = mamaReader.IsDBNull(1) ? null : mamaReader.GetString(1);
                    rtn.LockId = mamaReader.IsDBNull(3) ? null : mamaReader.GetString(3);
                    rtn.UserComment = mamaReader.IsDBNull(4) ? null : mamaReader.GetString(4);
                }

                mamaReader.Close();
            }

            return rtn;
        }
        public static async Task<string> GetMaterialName(string material, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT matDef.part_number, matDef.part_name " +
                    "FROM mama.t_mat_def matDef " +
                    $"WHERE matDef.part_number = '{material}' ";
                cmd.CommandType = CommandType.Text;
                var matReader = await cmd.ExecuteReaderAsync(token);
                if (await matReader.ReadAsync(token))
                {
                    rtn = matReader.IsDBNull(1) ? null : matReader.GetString(1);
                }

                matReader.Close();
            }

            return rtn;
        }

        #endregion
        #region Ua

        public static async Task<MesUser> GetMesUserData(string username, CancellationToken token)
        {
            await Connect();
            var rtn = new MesUser();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT UA.LOGIN_NAME, UA.PASSWORD, UA.DESCRIPTION, UA.FIRST_NAME, UA.LAST_NAME " +
                    "FROM UA.T_USER UA " +
                    $"WHERE UA.LOGIN_NAME = '{username}' ";
                cmd.CommandType = CommandType.Text;
                var mesUserReader = await cmd.ExecuteReaderAsync(token);
                if (await mesUserReader.ReadAsync(token))
                {
                    rtn.LoginName = mesUserReader["LOGIN_NAME"].ToString();
                    rtn.Password = mesUserReader["PASSWORD"].ToString();
                    rtn.FirstName = mesUserReader["FIRST_NAME"].ToString();
                    rtn.LastName = mesUserReader["LAST_NAME"].ToString();
                }

                mesUserReader.Close();
            }

            return rtn;
        }

        #endregion
        #region Andon
        
        public static async Task<Andon[]> GetAndonLines(AndonSearchSettings settings,CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<Andon>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("AndonLines");
                cmd.CommandType = CommandType.Text;
                using (var andonReader = await cmd.ExecuteReaderAsync(token))
                {
                    while (await andonReader.ReadAsync(token))
                    {
                        var lin = andonReader["PROD_LINE"].ToString();

                        var adn = new Andon()
                        {
                            Definition = new AndonDefinition()
                            {
                                Name = lin,
                                StandardHourlyQty = int.TryParse(andonReader["STANDARD_HOURLY_QTY"].ToString(), out var hqt) ? hqt : 0,
                                Administrators = string.IsNullOrWhiteSpace(andonReader["ADMINISTRATOR"].ToString()) ? null : andonReader["ADMINISTRATOR"].ToString().Split(',').ToArray(),
                                ProductIn = andonReader["PRDUCT_DEFINITION_IN"].ToString(),
                                ProductOut = andonReader["PRDUCT_DEFINITION_OUT"].ToString(),
                                Building = andonReader["Bu"].ToString()
                            }
                        };
                        if (settings.HourTarget)
                        {
                            var htg = await GetAndonHourTargets(settings.StartDate, settings.EndDate, lin, token);
                            adn.Targets = htg;
                        }
                        rtn.Add(adn);
                    }
                }
            }
            return rtn.ToArray();
        }
        public static async Task<List<AndonHourTarget>> GetAndonHourTargets(DateTime startDate, DateTime endDate, string lineName,CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<AndonHourTarget>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("AndonHourTarget",new Dictionary<string, string>
                {
                    { ":startDate", $"{startDate:yyyy-MM-dd HH:mm:ss}" },
                    { ":endDate", $"{endDate:yyyy-MM-dd HH:mm:ss}" },
                    { ":prodLine", $"{lineName}" }
                });
                cmd.CommandType = CommandType.Text;
                using (var andonReader = await cmd.ExecuteReaderAsync(token))
                {
                    while (await andonReader.ReadAsync(token))
                    {
                        try
                        {
                            rtn.Add(new AndonHourTarget()
                            {
                                Hour = andonReader.GetDateTime(andonReader.GetOrdinal("AFFECTED_HOUR")),
                                Target = int.TryParse(andonReader["TARGET_QTY"].ToString(),out var tqy) ? tqy : 0,
                                YieldQty = int.TryParse(andonReader["YIELD_QTY"].ToString(),out var yqy) ? yqy : 0,
                                FirstPass = int.TryParse(andonReader["FIRST_PASS_QTY"].ToString(),out var fpq) ? fpq : 0,
                                Setter = new AndonTargetSetter()
                                {
                                    User = andonReader["TARGET_UPDATED_BY"].ToString(),
                                    Comment = andonReader["HOUR_COMMENT"].ToString(),
                                    Date = andonReader.IsDBNull(andonReader.GetOrdinal("TARGET_UPDATED")) ? default : andonReader.GetDateTime(andonReader.GetOrdinal("TARGET_UPDATED"))
                                }
                            }); 
                        }
                        catch{}
                    }
                    andonReader.Close();
                }
            }
            return rtn;
        }
        public static async Task<List<AndonStationFlow>> GetAndonStationData(AndonSearchSettings settings,CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<AndonStationFlow>();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("AndonStationFlow", new Dictionary<string, string>()
                {
                    {":prodLine", settings.LineName},
                    {":startDate", settings.StartDate.ToString("yyyy-MM-dd HH:mm:ss")},
                    {":endDate", settings.EndDate.ToString("yyyy-MM-dd HH:mm:ss")}
                });
                
                var andonReader = await cmd.ExecuteReaderAsync(token);
                while (await andonReader.ReadAsync(token))
                {
                    try
                    {
                        var asf = new AndonStationFlow();
                        var visualNameSt = andonReader["VISUALISATION_NAME"].ToString();
                        var equipmentSt = andonReader["EQUIPMENT"].ToString();
                        var operatorSt = andonReader["OPERATOR"].ToString();
                        var firstEscalation = int.TryParse(andonReader["FIRST_ESCALATION"].ToString(), out var firstEsc) ? firstEsc : 0;
                        var secondEscalation = int.TryParse(andonReader["SECOND_ESCALATION"].ToString(), out var secEsc) ? secEsc : 0;
                        var transactionType = andonReader["CHECKED_TRANSACTION_TYPE"].ToString();
                        var visualFlowIt = int.TryParse(andonReader["VISUALISATION_FLOW"].ToString(), out var visualFlowId) ? visualFlowId : 0;
                        var isFirstBl = andonReader["IS_FIRST"].ToString() == "y";
                        var isLastBl = andonReader["IS_LAST"].ToString() == "y";
                        var isLockedBl = andonReader["IS_LOCKED"].ToString() == "Y";
                        var lastUsedDt = andonReader.IsDBNull(andonReader.GetOrdinal("LAST_USED"))
                            ? (DateTime?)null
                            : andonReader.GetDateTime(andonReader.GetOrdinal("LAST_USED"));
                        var firstPass = int.TryParse(andonReader["TOTAL_FIRST_PASS_QTY"].ToString(), out var fp) ? fp : 0;
                        var firstFail = int.TryParse(andonReader["TOTAL_FIRST_FAIL_QTY"].ToString(), out var fa) ? fa : 0;
                        var yieldQty = int.TryParse(andonReader["TOTAL_YIELD_QTY"].ToString(), out var yq) ? yq : 0;
                        var totalRun = int.TryParse(andonReader["TOTAL_RUN"].ToString(), out var tqy) ? tqy : 0;
                        var totalFpy = double.TryParse(andonReader["TOTAL_FPY_PERCENTAGE"].ToString(), out var fpy) ? fpy : 0;
                        asf.Name = visualNameSt;
                        asf.Equipment = equipmentSt;
                        asf.Operator = operatorSt;
                        asf.FirstEscalation = firstEscalation;
                        asf.SecondEscalation = secondEscalation;
                        asf.TransactionType = transactionType;
                        asf.Flow = visualFlowIt;
                        asf.IsFirst = isFirstBl;
                        asf.IsLast = isLastBl;
                        asf.IsLocked = isLockedBl;
                        asf.LastUsed = lastUsedDt;
                        asf.FirstPass = firstPass;
                        asf.FirstFail = firstFail;
                        asf.YieldQty = yieldQty;
                        asf.TotalRun = totalRun;
                        asf.TotalFpyPercentage = totalFpy;
                        
                        rtn.Add(asf);
                    }catch{}
                }
                andonReader.Close();
            }
            return rtn;
        }
        public static async Task<string[]> GetAndonLinesString(CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<string>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("AndonLines");
                cmd.CommandType = CommandType.Text;
                
                var andonReader = await cmd.ExecuteReaderAsync(token);
                while (await andonReader.ReadAsync(token)) { rtn.Add(andonReader["PROD_LINE"].ToString()); }
                andonReader.Close();
            }
            return rtn.ToArray();
        }
        public static async Task<Andon> GetAndonLine(AndonSearchSettings settings,CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new Andon();
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("AndonLine",new Dictionary<string, string>
                {
                    {":prodLine",$"{settings.LineName}"}
                });
                cmd.CommandType = CommandType.Text;
                var andonReader = await cmd.ExecuteReaderAsync(token);
                
                    if (await andonReader.ReadAsync(token))
                    {
                        var lin = andonReader["PROD_LINE"].ToString();
                        rtn = new Andon()
                        {
                            Definition = new AndonDefinition()
                            {
                                Name = lin,
                                StandardHourlyQty = int.TryParse(andonReader["STANDARD_HOURLY_QTY"].ToString(), out var hqt) ? hqt : 0,
                                Administrators = string.IsNullOrWhiteSpace(andonReader["ADMINISTRATOR"].ToString()) ? null : andonReader["ADMINISTRATOR"].ToString().Split(',').ToArray(),
                                ProductIn = andonReader["PRDUCT_DEFINITION_IN"].ToString(),
                                ProductOut = andonReader["PRDUCT_DEFINITION_OUT"].ToString(),
                                Building = andonReader["Bu"].ToString()
                            }
                        };
                        if (settings.HourTarget)
                        {
                            var htg = await GetAndonHourTargets(settings.StartDate, settings.EndDate, lin, token);
                            rtn.Targets = htg;
                        }

                        if (settings.StationFlow)
                        {
                            var asf = await GetAndonStationData(settings, token);
                            rtn.Stations = asf;
                        }
                    }
                    andonReader.Close();
            }

            return rtn;
        }
        public static async Task<Andon> GetAndonData(string prodLine,DateTime date,bool isNightShift,CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new Andon();
            
            /*var startDate = new DateTime(date.Year, date.Month, date.Day, 06,00,00);
            var endDate = new DateTime(date.Year, date.Month, date.Day, 17,00,00);
            if (isNightShift)
            {
                startDate = new DateTime(date.Year, date.Month, date.Day, 18, 00, 00);
                var nxd = date.AddDays(1);
                endDate = new DateTime(nxd.Year, nxd.Month, nxd.Day, 05, 00, 00);
            }
            
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("AndonData")
                    .Replace(":prodLine",$"'{prodLine}'")
                    .Replace(":startDate",$"'{startDate:yyyy-MM-dd HH:mm:ss}'")
                    .Replace(":endDate",$"'{endDate:yyyy-MM-dd HH:mm:ss}'");

                //cmd.CommandType = CommandType.Text;
                
                var andonReader = await cmd.ExecuteReaderAsync(token);
                while (await andonReader.ReadAsync(token))
                {
                    rtn.RawData.Add(new AndonRawData()
                    {
                        Equipment = andonReader["EQUIPMENT"].ToString(),
                        Operator = andonReader["OPERATOR"].ToString(),
                        VisualName = andonReader["VISUALISATION_NAME"].ToString(),
                        VisualFlow = int.TryParse(andonReader["VISUALISATION_FLOW"].ToString(),out var visualFlowId) ? visualFlowId : 0,
                        LastUsed = andonReader.IsDBNull(andonReader.GetOrdinal("LAST_USED")) ? DateTime.Now : andonReader.GetDateTime(andonReader.GetOrdinal("LAST_USED")),
                        IsLocked = andonReader["IS_LOCKED"].ToString() == "Y",
                        IsFirst = andonReader["IS_FIRST"].ToString() == "y",
                        IsLast = andonReader["IS_LAST"].ToString() == "y",
                        Material = andonReader["MATERIAL"].ToString(),
                        MaterialName = andonReader["MATERIAL_NAME"].ToString(),
                        MaterialGroup = andonReader["MATERIAL_GROUP"].ToString(),
                        MaterialType = andonReader["MATERIAL_TYPE"].ToString(),
                        Hour = andonReader.IsDBNull(andonReader.GetOrdinal("AFFECTED_HOUR")) ? DateTime.Now : andonReader.GetDateTime(andonReader.GetOrdinal("AFFECTED_HOUR")),
                        FirstPassQuantity = int.TryParse(andonReader["FIRST_PASS_QTY"].ToString(),out var firstPassQuantity) ? firstPassQuantity : 0,
                        TotalProcessedUnit = int.TryParse(andonReader["TOTAL_PROCESSED_UNIT"].ToString(),out var totalProcessedUnit) ? totalProcessedUnit : 0,
                        TotalRun = int.TryParse(andonReader["TOTAL_RUN"].ToString(),out var totalRun) ? totalRun : 0,
                        YieldQuantity = int.TryParse(andonReader["YIELD_QTY"].ToString(),out var yieldQuantity) ? yieldQuantity : 0,
                        FirstFailQuantity = int.TryParse(andonReader["FIRST_FAIL_QTY"].ToString(),out var firstFailQuantity) ? firstFailQuantity : 0,
                        YieldRun = int.TryParse(andonReader["YIELD_RUN"].ToString(),out var yieldRun) ? yieldRun : 0,
                        TargetQuantity = int.TryParse(andonReader["TARGET_QTY"].ToString(),out var targetQuantity) ? targetQuantity : 0,
                        TargetUpdatedBy = andonReader["TARGET_UPDATED_BY"].ToString(),
                        HourComment = andonReader["HOUR_COMMENT"].ToString()
                    });
                    //rtn.Add(andonReader["PROD_LINE"].ToString());
                }
                andonReader.Close();
            }*/
            return rtn;
        }
        
        #endregion
        #region Clm
        
        public static async Task<List<ClmEntry>> GetClmEntry(string keyName = null,bool keyLike = false,string division = null,bool divLike = false, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<ClmEntry>();
            using (var cmd = OraConnection.CreateCommand())
            {
                var knmSq = !string.IsNullOrEmpty(keyName) ? keyLike ? $"ent.KEY_NAME LIKE '%{keyName}%'" : $"ent.KEY_NAME = '{keyName}'" : "";
                var divSq = !string.IsNullOrEmpty(division) ? divLike ? $"ent.DIVISION LIKE '%{division}%'" : $"ent.DIVISION = '{division}'" : "";
                cmd.CommandText = QuerySelector.Get("ClmEntry", new Dictionary<string, string>
                {
                    {":where", $"{knmSq} {divSq}"}
                });
                cmd.CommandType = CommandType.Text;
                
                var entryReader = await cmd.ExecuteReaderAsync(token);
                while (await entryReader.ReadAsync(token))
                {
                    var parent = entryReader["PARENT_KEY_ID"].ToString();
                    var entry = entryReader["ENTRY_ID"].ToString();
                    var entName = entryReader["ENTRY_NAME"].ToString();
                    var entType = entryReader["ENTRY_TYPE"].ToString();
                    var entDesc = entryReader["ENTRY_DESC"].ToString();
                    var key = entryReader["KEY_NAME"].ToString();
                    var keyType = entryReader["KEY_TYPE"].ToString();
                    var keyDesc = entryReader["KEY_DESC"].ToString();
                    var div = entryReader["DIVISION"].ToString();
                    var crtIdx = entryReader.GetOrdinal("CREATED");
                    var crt = entryReader.IsDBNull(crtIdx) ? (DateTime?)null : entryReader.GetDateTime(crtIdx);
                    var updIdx = entryReader.GetOrdinal("UPDATED");
                    var upd = entryReader.IsDBNull(updIdx) ? (DateTime?)null : entryReader.GetDateTime(updIdx);

                    rtn.Add(new ClmEntry()
                    {
                        ParentKeyId = parent,
                        EntryId = entry,
                        EntryName = entName,
                        EntryType = entType,
                        EntryDescription = entDesc,
                        KeyName = key,
                        KeyType = keyType,
                        KeyDescription = keyDesc,
                        Division = div,
                        Created = crt,
                        Modified = upd
                    });
                }
                entryReader.Close();
            }
            return rtn;
        }
        
        public static async Task<string[]> GetClmTextValue(string entryId, CancellationToken token = new CancellationToken())
        {
            await Connect();
            var rtn = new List<string>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = QuerySelector.Get("ClmTextValue", new Dictionary<string, string>
                {
                    {":entryId", entryId}
                });
                cmd.CommandType = CommandType.Text;
                
                var entryReader = await cmd.ExecuteReaderAsync(token);
                while(await entryReader.ReadAsync(token))
                {
                    rtn.Add(entryReader["TEXT_VALUE"].ToString());
                }
                entryReader.Close();
            }
            return rtn.ToArray();
        }

        #endregion
    }
}