using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using AnalyseToolExtension.DataObjects;
using AnalyseToolExtension.QueryCodes;
using static AnalyseToolExtension.Clients.ProductAnalyzeClient;

namespace AnalyseToolExtension.Query
{
    public class ProductAnalyseQuery
    {
        public static async Task<List<ProductAnalyzeInfo2>> GetProductAnalyzeInfo(string unitId, CancellationToken token)
        {
            await Connect();
            var rtn = new List<ProductAnalyzeInfo2>();

            
                using (var cmd = MsConnection.CreateCommand())
                {
                    cmd.CommandText = QuerySelector.Get("ProductAnalyse","FullUnitRecordInfo",
                        new Dictionary<string, string>()
                    {
                        {":unitId", unitId}
                    });
                    cmd.CommandType = CommandType.Text;
                    var paReader = await cmd.ExecuteReaderAsync(token);
                    while (paReader.ReadAsync(token).Result)
                    {
                        var pai = new ProductAnalyzeInfo2()
                        {
                            Plant = paReader["Plant"].ToString(),
                            Building = paReader["Building"].ToString(),
                            FocusFactory = paReader["FocusFactory"].ToString(),
                            ProductFamily = paReader["ProductFamily"].ToString(),
                            UnitId = paReader["UnitId"].ToString(),
                            UnitIdType = paReader["UnitIdType"].ToString(),
                            Subset = paReader["SubsetId"].ToString(),
                            Material = paReader["SAP_ID"].ToString(),
                            Location = paReader["Location"].ToString(),
                            Order = paReader["OrderName"].ToString(),
                            ProductionVersion = paReader["ProductionVersion"].ToString(),
                            Customer = paReader["Customer"].ToString(),
                            ProductType = paReader["ProductType"].ToString(),
                            SubGroup = paReader["Subgroup"].ToString(),
                            Message = paReader["Message"].ToString(),
                            Shift = paReader["Shift"].ToString(),
                            Week = paReader["Week"].ToString(),
                            Protocol = paReader["Protocol"].ToString(),
                            ProtocolType = paReader["ProtocolType"].ToString(),
                            CostCollection = paReader["CostCollector"].ToString(),
                            Price = paReader["Price"].ToString(),
                            ComputerName = paReader["ComputerName"].ToString(),
                            MesStation = paReader["MESStation"].ToString(),
                            MesDate = paReader.IsDBNull(paReader.GetOrdinal("MESDate")) 
                                ? (DateTime?)null 
                                : paReader.GetDateTime(paReader.GetOrdinal("MESDate")),
                        };
                        pai.Detection = new ProductAnalyzeInfo2Record()
                        {
                            Building = pai.Building,
                            Production = paReader["DetectionProduction"].ToString(),
                            Line = paReader["DetectionLine"].ToString(),
                            Station = paReader["DetectionStation"].ToString(),
                            OperationNumber = paReader["DetectionOperationNumber"].ToString(),
                            WorkCenterGroup = paReader["DetectionWorkCenterGroup"].ToString(),
                            Fault = paReader["DetectedFault"].ToString(),
                            Params = paReader["DetectionParams"].ToString(),
                            Status = paReader["Status"].ToString(),
                            AnalyzeState = paReader["AnalyzeState"].ToString(),
                            Date = paReader.IsDBNull(paReader.GetOrdinal("DetectionDate"))
                                ? (DateTime?)null
                                : paReader.GetDateTime(paReader.GetOrdinal("DetectionDate")),
                            User = paReader["UserName"].ToString(),
                            UserFullName = paReader["FullName"].ToString(),
                        };
                        pai.Causer = new ProductAnalyzeInfo2Record()
                        {
                            Building = paReader["CauserBuilding"].ToString(),
                            Production = paReader["CauserProduction"].ToString(),
                            Line = paReader["CauserLine"].ToString(),
                            Station = paReader["CauserStation"].ToString(),
                            OperationNumber = null,
                            WorkCenterGroup = null,
                            Fault = paReader["CauserFault"].ToString(),
                            Params = paReader["CauserParams"].ToString(),
                            Status = paReader["Status2"].ToString(),
                            AnalyzeState = paReader["AnalyzeState"].ToString(),
                            Date = paReader.IsDBNull(paReader.GetOrdinal("Date2"))
                                ? (DateTime?)null
                                : paReader.GetDateTime(paReader.GetOrdinal("Date2")),
                            User = paReader["UserName2"].ToString(),
                            UserFullName = paReader["FullName2"].ToString(),
                        };
                        pai.MaterialInfo = new ProductAnalyzeMaterialInfo()
                        {
                            Material = pai.Material,
                            Plant = paReader["SAP_PLANT"].ToString(),
                            FocusFactory = paReader["SAP_FOCUSFACTORY"].ToString(),
                            ProductFamily = paReader["SAP_PRODUCTFAMILY"].ToString(),
                            Type = paReader["SAP_TYPE"].ToString(),
                            Description = paReader["SAP_DESCRIPTION"].ToString(),
                            Customer = paReader["SAP_CUSTOMER"].ToString(),
                            ProductType = paReader["SAP_PRODUCTTYPE"].ToString(),
                            SubGroup = paReader["SAP_SUBGROUP"].ToString(),
                            Quantity = paReader["SAP_QTY"].ToString(),
                            Unit = paReader["SAP_UNIT"].ToString(),
                            Price = paReader["SAP_PRICE"].ToString(),
                            CustomerPrice = paReader["SAP_CUTOMERPRICE"].ToString(),
                            IsActive = !paReader.IsDBNull(paReader.GetOrdinal("SAP_ACTIVE")) && paReader.GetBoolean(paReader.GetOrdinal("SAP_ACTIVE")),
                            StorageLocation = paReader["SAP_STORAGE"].ToString(),
                            SaMag = paReader["SAP_SAMAG"].ToString(),
                        };
                        rtn.Add(pai);
                    }
                    paReader.Close();
                }
            
            
            return rtn;
        }
    }
}