WITH HourRange AS (
    SELECT TO_DATE(:startDate, 'YYYY-MM-DD HH24:MI:SS') + (LEVEL - 1) / 24 AS AFFECTED_HOUR
    FROM DUAL
    CONNECT BY LEVEL <= (TO_DATE(:endDate, 'YYYY-MM-DD HH24:MI:SS') - TO_DATE(:startDate, 'YYYY-MM-DD HH24:MI:SS')) * 24 + 1
)
SELECT
    ld.EQUIPMENT,
    ld.OPERATOR,
    ld.VISUALISATION_NAME,
    ld.VISUALISATION_FLOW,
    ld.FIRST_ESCALATION,
    ld.SECOND_ESCALATION,
    AP.LAST_USED,
    AP.IS_LOCKED,
    ld.IS_FIRST,
    ld.IS_LAST,
    scv.MATERIAL,
    mat.PART_NAME AS MATERIAL_NAME,
    mat.PART_GROUP AS MATERIAL_GROUP,
    mat.PART_TYPE AS MATERIAL_TYPE,
    hr.AFFECTED_HOUR,
    NVL(scv.FIRST_PASS_QTY, 0) AS FIRST_PASS_QTY,
    NVL(scv.TOTAL_PROCESSED_UNIT, 0) AS TOTAL_PROCESSED_UNIT,
    NVL(scv.TOTAL_RUN, 0) AS TOTAL_RUN,
    NVL(scv.YIELD_QTY, 0) AS YIELD_QTY,
    NVL(scv.FIRST_FAIL_QTY, 0) AS FIRST_FAIL_QTY,
    NVL(scv.YIELD_RUN, 0) AS YIELD_RUN,
    NVL(AC.TARGET_QTY, 0) AS TARGET_QTY,
    AC.TARGET_UPDATED_BY,
    AC.HOUR_COMMENT
FROM HourRange hr
         CROSS JOIN ANDON.ANDON_LINE_DEFINITION ld
         LEFT JOIN ANDON.ANDON_STATION_COUNTER_VIEW scv
                   ON ld.EQUIPMENT = scv.EQUIPMENT
                       AND ld.OPERATOR = scv.OPERATOR
                       AND hr.AFFECTED_HOUR = scv.AFFECTED_HOUR
         LEFT JOIN MAMA.T_MAT_DEF mat
                   ON scv.MATERIAL = mat.PART_NUMBER
         LEFT JOIN ANDON.ANDON_PROCESS AP
                   ON ld.EQUIPMENT = AP.EQUIPMENT
                       AND ld.OPERATOR = AP.OPERATOR
         LEFT JOIN ANDON.ANDON_COUNTER AC
                   ON AP.PROD_LINE = AC.PROD_LINE
                       AND hr.AFFECTED_HOUR = AC.AFFACTED_HOUR
WHERE ld.PROD_LINE = :prodLine
ORDER BY ld.VISUALISATION_FLOW, hr.AFFECTED_HOUR