WITH HourRange AS (
    SELECT TO_DATE(:startDate, 'YYYY-MM-DD HH24:MI:SS') + (LEVEL - 1) / 24 AS AFFECTED_HOUR
    FROM DUAL
    CONNECT BY LEVEL <= (TO_DATE(:endDate, 'YYYY-MM-DD HH24:MI:SS') - TO_DATE(:startDate, 'YYYY-MM-DD HH24:MI:SS')) * 24 + 1
)
SELECT 
    hr.AFFECTED_HOUR,
    CVW.TARGET_QTY,
    CVW.YIELD_QTY,
    CVW.FIRST_PASS_QTY,
    CVW.TARGET_UPDATED,
    CVW.TARGET_UPDATED_BY,
    CVW.HOUR_COMMENT
FROM HourRange hr
         CROSS JOIN ANDON.ANDON_ADMINISTRATION ld 
    LEFT JOIN ANDON.ANDON_COUNTER_VIEW CVW ON hr.AFFECTED_HOUR = CVW.AFFACTED_HOUR AND ld.PROD_LINE = CVW.PROD_LINE 
WHERE ld.PROD_LINE = :prodLine