WITH StationFlow AS (
    SELECT *
    FROM (
             SELECT t.*
             FROM ANDON.ANDON_LINE_DEFINITION t
             WHERE PROD_LINE = :prodLine AND VISUALISATION_FLOW > 0
             ORDER BY VISUALISATION_FLOW
         )
    WHERE ROWNUM <= 501
),
     AggregatedCounts AS (
         SELECT
             ASCT.OPERATOR,
             ASCT.EQUIPMENT,
             ASCT.PROD_LINE,
             SUM(NVL(ASCT.FIRST_PASS_QTY, 0)) AS TOTAL_FIRST_PASS_QTY,
             SUM(NVL(ASCT.FIRST_FAIL_QTY, 0)) AS TOTAL_FIRST_FAIL_QTY,
             SUM(NVL(ASCT.YIELD_RUN, 0)) AS TOTAL_YIELD_RUN,
             SUM(NVL(ASCT.YIELD_QTY, 0)) AS TOTAL_YIELD_QTY,
             SUM(NVL(ASCT.TOTAL_RUN, 0)) AS TOTAL_RUN,
             SUM(NVL(ASCT.TOTAL_PROCESSED_UNIT, 0)) AS TOTAL_PROCESSED_UNIT
         FROM ANDON.ANDON_STATION_COUNTER ASCT
         WHERE ASCT.AFFECTED_HOUR BETWEEN TO_DATE(:startDate, 'YYYY-MM-DD HH24:MI:SS')
             AND TO_DATE(:endDate, 'YYYY-MM-DD HH24:MI:SS')
           AND ASCT.PROD_LINE = :prodLine
         GROUP BY ASCT.OPERATOR, ASCT.EQUIPMENT, ASCT.PROD_LINE
     )
SELECT
    sf.VISUALISATION_FLOW,
    sf.VISUALISATION_NAME,
    sf.EQUIPMENT,
    sf.OPERATOR,
    sf.FIRST_ESCALATION,
    sf.SECOND_ESCALATION,
    sf.CHECKED_TRANSACTION_TYPE,
    sf.IS_FIRST,
    sf.IS_LAST,
    aps.LAST_USED,
    aps.IS_LOCKED,
    NVL(ac.TOTAL_FIRST_PASS_QTY, 0) AS TOTAL_FIRST_PASS_QTY,
    NVL(ac.TOTAL_FIRST_FAIL_QTY, 0) AS TOTAL_FIRST_FAIL_QTY,
    NVL(ac.TOTAL_YIELD_RUN, 0) AS TOTAL_YIELD_RUN,
    NVL(ac.TOTAL_YIELD_QTY, 0) AS TOTAL_YIELD_QTY,
    NVL(ac.TOTAL_RUN, 0) AS TOTAL_RUN,
    NVL(ac.TOTAL_PROCESSED_UNIT, 0) AS TOTAL_PROCESSED_UNIT,
    CASE
        WHEN (NVL(ac.TOTAL_FIRST_PASS_QTY, 0) + NVL(ac.TOTAL_FIRST_FAIL_QTY, 0)) = 0
            THEN 0
        ELSE ROUND(
                (NVL(ac.TOTAL_FIRST_PASS_QTY, 0) /
                 (NVL(ac.TOTAL_FIRST_PASS_QTY, 0) + NVL(ac.TOTAL_FIRST_FAIL_QTY, 0))) * 100, 2
             )
        END AS TOTAL_FPY_PERCENTAGE
FROM StationFlow sf
         LEFT JOIN ANDON.ANDON_PROCESS aps
                   ON sf.OPERATOR = aps.OPERATOR
                       AND sf.EQUIPMENT = aps.EQUIPMENT
         LEFT JOIN AggregatedCounts ac
                   ON sf.OPERATOR = ac.OPERATOR
                       AND sf.EQUIPMENT = ac.EQUIPMENT
                       AND sf.PROD_LINE = ac.PROD_LINE
WHERE sf.VISUALISATION_FLOW > 0
ORDER BY VISUALISATION_FLOW