SELECT
    ASCT.AFFECTED_HOUR,
    NVL(ASCT.FIRST_PASS_QTY, 0) AS FIRST_PASS_QTY,
    NVL(ASCT.FIRST_FAIL_QTY,0) AS FIRST_FAIL_QTY,
    NVL(ASCT.YIELD_RUN,0) AS YIELD_RUN,
    NVL(ASCT.YIELD_QTY,0) AS YIELD_QTY,
    NVL(ASCT.TOTAL_RUN,0) AS TOTAL_RUN,
    NVL(ASCT.TOTAL_PROCESSED_UNIT,0) AS TOTAL_PROCESSED_UNIT,
    NVL(ASCT.MATERIAL,'') AS MATERIAL,
    NVL(ASCT.PRODUCTION_VERSION,'') AS PRODUCTION_VERSION
FROM ANDON.ANDON_STATION_COUNTER ASCT 
WHERE ASCT.AFFECTED_HOUR BETWEEN TO_DATE(:startDate, 'YYYY-MM-DD HH24:MI:SS') AND TO_DATE(:endDate, 'YYYY-MM-DD HH24:MI:SS') 
  AND :Operator = ASCT.OPERATOR 
  AND :Equipment = ASCT.EQUIPMENT
  AND :ProdLine = ASCT.PROD_LINE
ORDER BY ASCT.AFFECTED_HOUR