-- BLOCK_START BuildIn
    SELECT partList.part_id AS UNIT_ID,
           partList.part_id_type AS UNIT_ID_TYPE,
           partList.created AS CREATED,
           partList.removed AS REMOVED 
    FROM wip.t_wip_partslist partList
             JOIN wip.t_wip_subset wip ON partList.subset_id_l = wip.subset_id_l
    WHERE wip.unit_id_in = :unitId AND wip.job = partList.job
    ORDER BY partList.created;
-- BLOCK_END

-- BLOCK_START BuildInHis
    SELECT partListHis.part_id AS UNIT_ID, 
           partListHis.part_id_type AS UNIT_ID_TYPE, 
           partListHis.created AS CREATED, 
           partListHis.removed AS REMOVED 
    FROM wip.t_wip_partslist_his partListHis
             JOIN wip.t_wip_subset_his wipHis ON partListHis.subset_id_l = wipHis.subset_id_l
    WHERE wipHis.unit_id_in = :unitId AND wipHis.job = partListHis.job
    ORDER BY partListHis.created;
-- BLOCK_END

-- BLOCK_START BuildOut
    SELECT wip.unit_id_in AS UNIT_ID, 
           wip.unit_id_in_type AS UNIT_ID_TYPE, 
           wip.created AS CREATED, 
           partList.removed AS REMOVED 
    FROM wip.t_wip_subset wip
             JOIN wip.t_wip_partslist partList ON partList.subset_id_l = wip.subset_id_l
    WHERE partList.PART_ID = :unitId AND wip.job = partList.job
    ORDER BY wip.created;
-- BLOCK_END
    
-- BLOCK_START BuildOutHis
    SELECT wipHis.unit_id_in AS UNIT_ID, 
           wipHis.unit_id_in_type AS UNIT_ID_TYPE, 
           wipHis.created AS CREATED, 
           partListHis.removed AS REMOVED 
    FROM wip.t_wip_subset_his wipHis
             JOIN wip.t_wip_partslist_his partListHis ON partListHis.subset_id_l = wipHis.subset_id_l
    WHERE partListHis.PART_ID = :unitId AND wipHis.job = partListHis.job
    ORDER BY wipHis.created;
-- BLOCK_END

-- BLOCK_START BuildName
    SELECT wip.job AS ORDER_INFO, 
           wip.unit_id_in_type AS UNIT_ID_TYPE, 
           wip.updated AS UPDATED, 
           wipjob.product_definition AS MATERIAL, 
           matDef.part_name AS DESCRIPTION 
    FROM wip.t_wip_subset wip
             JOIN wip.t_wip_job wipJob ON wip.job = wipJob.job
             JOIN  mama.t_mat_def matDef ON wipjob.product_definition = matDef.part_number
    WHERE wip.unit_id_in= :unitId
    ORDER BY wip.updated DESC;
-- BLOCK_END

-- BLOCK_START BuildNameHis
    SELECT wipHis.job AS ORDER_INFO, 
           wipHis.unit_id_in_type AS UNIT_ID_TYPE, 
           wipHis.updated AS UPDATED, 
           wipJobHis.product_definition AS MATERIAL, 
           matDef.part_name AS DESCRIPTION 
    FROM wip.t_wip_subset_his wipHis
             JOIN wip.t_wip_job_his wipJobHis ON wipHis.job = wipJobHis.job
             JOIN  mama.t_mat_def matDef ON wipJobHis.product_definition = matDef.part_number
    WHERE wipHis.unit_id_in= :unitId
    ORDER BY wipHis.updated DESC;
-- BLOCK_END

-- BLOCK_START BuildInFullInfo
    WITH FirstParts AS (
        SELECT partList.part_id AS UNIT_ID,
               partList.part_id_type AS UNIT_ID_TYPE,
               partList.created AS CREATED,
               partList.removed AS REMOVED
        FROM wip.t_wip_partslist partList
                 JOIN wip.t_wip_subset wip ON partList.subset_id_l = wip.subset_id_l
        WHERE wip.unit_id_in = :unitId AND wip.job = partList.job
    ),
         SecondParts AS (
             SELECT partList.part_id AS UNIT_ID,
                    partList.part_id_type AS UNIT_ID_TYPE,
                    partList.created AS CREATED,
                    partList.removed AS REMOVED
             FROM wip.t_wip_partslist_his partList
                      JOIN wip.t_wip_subset_his wip ON partList.subset_id_l = wip.subset_id_l
             WHERE wip.unit_id_in = :unitId AND wip.job = partList.job
         ),
         AllParts AS (
             SELECT * FROM FirstParts
             UNION ALL
             SELECT * FROM SecondParts
             WHERE NOT EXISTS (SELECT 1 FROM FirstParts)
         ),
         FirstQuery AS (
             SELECT wip.job AS ORDER_INFO,
                    wip.unit_id_in_type AS UNIT_ID_TYPE,
                    wip.updated AS UPDATED,
                    wipJob.product_definition AS MATERIAL,
                    matDef.part_name AS DESCRIPTION,
                    wip.unit_id_in AS UNIT_ID,
                    ROW_NUMBER() OVER (PARTITION BY wip.unit_id_in ORDER BY wip.updated DESC) AS RN
             FROM wip.t_wip_subset wip
                      JOIN wip.t_wip_job wipJob ON wip.job = wipJob.job
                      JOIN mama.t_mat_def matDef ON wipJob.product_definition = matDef.part_number
             WHERE wip.unit_id_in IN (SELECT UNIT_ID FROM AllParts)
         ),
         SecondQuery AS (
             SELECT wipHis.job AS ORDER_INFO,
                    wipHis.unit_id_in_type AS UNIT_ID_TYPE,
                    wipHis.updated AS UPDATED,
                    wipJobHis.product_definition AS MATERIAL,
                    matDef.part_name AS DESCRIPTION,
                    wipHis.unit_id_in AS UNIT_ID,
                    ROW_NUMBER() OVER (PARTITION BY wipHis.unit_id_in ORDER BY wipHis.updated DESC) AS RN
             FROM wip.t_wip_subset_his wipHis
                      JOIN wip.t_wip_job_his wipJobHis ON wipHis.job = wipJobHis.job
                      JOIN mama.t_mat_def matDef ON wipJobHis.product_definition = matDef.part_number
             WHERE wipHis.unit_id_in IN (SELECT UNIT_ID FROM AllParts)
         ),
         FinalResult AS (
             SELECT A.UNIT_ID,
                    COALESCE(FIRST.ORDER_INFO, SECOND.ORDER_INFO) AS ORDER_INFO,
                    COALESCE(FIRST.UNIT_ID_TYPE, SECOND.UNIT_ID_TYPE) AS UNIT_ID_TYPE,
                    COALESCE(FIRST.UPDATED, SECOND.UPDATED) AS UPDATED,
                    COALESCE(FIRST.MATERIAL, SECOND.MATERIAL) AS MATERIAL,
                    COALESCE(FIRST.DESCRIPTION, SECOND.DESCRIPTION) AS DESCRIPTION
             FROM AllParts A
                      LEFT JOIN FirstQuery FIRST ON A.UNIT_ID = FIRST.UNIT_ID AND FIRST.RN = 1
                      LEFT JOIN SecondQuery SECOND ON A.UNIT_ID = SECOND.UNIT_ID AND SECOND.RN = 1
         )
    SELECT A.UNIT_ID,
           A.UNIT_ID_TYPE,
           A.CREATED,
           A.REMOVED,
           F.ORDER_INFO,
           F.UNIT_ID_TYPE AS ORDER_UNIT_ID_TYPE,
           F.UPDATED,
           F.MATERIAL,
           F.DESCRIPTION
    FROM AllParts A
             LEFT JOIN FinalResult F ON A.UNIT_ID = F.UNIT_ID
    ORDER BY A.CREATED;
-- BLOCK_END

-- BLOCK_START BuildOutFullInfo
    WITH FirstParts AS (
        SELECT wip.unit_id_in AS UNIT_ID,
               wip.unit_id_in_type AS UNIT_ID_TYPE,
               wip.created AS CREATED,
               partList.removed AS REMOVED
        FROM wip.t_wip_subset wip
                 JOIN wip.t_wip_partslist partList ON partList.subset_id_l = wip.subset_id_l
        WHERE partList.PART_ID = :unitId AND wip.job = partList.job
        ORDER BY wip.created
    ),
         SecondParts AS (
             SELECT wipHis.unit_id_in AS UNIT_ID,
                    wipHis.unit_id_in_type AS UNIT_ID_TYPE,
                    wipHis.created AS CREATED,
                    partListHis.removed AS REMOVED
             FROM wip.t_wip_subset_his wipHis
                      JOIN wip.t_wip_partslist_his partListHis ON partListHis.subset_id_l = wipHis.subset_id_l
             WHERE partListHis.PART_ID = :unitId AND wipHis.job = partListHis.job
             ORDER BY wipHis.created
         ),
         AllParts AS (
             SELECT * FROM FirstParts
             UNION ALL
             SELECT * FROM SecondParts
             WHERE NOT EXISTS (SELECT 1 FROM FirstParts)
         ),
         FirstQuery AS (
             SELECT wip.job AS ORDER_INFO,
                    wip.unit_id_in_type AS UNIT_ID_TYPE,
                    wip.updated AS UPDATED,
                    wipJob.product_definition AS MATERIAL,
                    matDef.part_name AS DESCRIPTION,
                    wip.unit_id_in AS UNIT_ID,
                    ROW_NUMBER() OVER (PARTITION BY wip.unit_id_in ORDER BY wip.updated DESC) AS RN
             FROM wip.t_wip_subset wip
                      JOIN wip.t_wip_job wipJob ON wip.job = wipJob.job
                      JOIN mama.t_mat_def matDef ON wipJob.product_definition = matDef.part_number
             WHERE wip.unit_id_in IN (SELECT UNIT_ID FROM AllParts)
         ),
         SecondQuery AS (
             SELECT wipHis.job AS ORDER_INFO,
                    wipHis.unit_id_in_type AS UNIT_ID_TYPE,
                    wipHis.updated AS UPDATED,
                    wipJobHis.product_definition AS MATERIAL,
                    matDef.part_name AS DESCRIPTION,
                    wipHis.unit_id_in AS UNIT_ID,
                    ROW_NUMBER() OVER (PARTITION BY wipHis.unit_id_in ORDER BY wipHis.updated DESC) AS RN
             FROM wip.t_wip_subset_his wipHis
                      JOIN wip.t_wip_job_his wipJobHis ON wipHis.job = wipJobHis.job
                      JOIN mama.t_mat_def matDef ON wipJobHis.product_definition = matDef.part_number
             WHERE wipHis.unit_id_in IN (SELECT UNIT_ID FROM AllParts)
         ),
         FinalResult AS (
             SELECT A.UNIT_ID,
                    COALESCE(FIRST.ORDER_INFO, SECOND.ORDER_INFO) AS ORDER_INFO,
                    COALESCE(FIRST.UNIT_ID_TYPE, SECOND.UNIT_ID_TYPE) AS UNIT_ID_TYPE,
                    COALESCE(FIRST.UPDATED, SECOND.UPDATED) AS UPDATED,
                    COALESCE(FIRST.MATERIAL, SECOND.MATERIAL) AS MATERIAL,
                    COALESCE(FIRST.DESCRIPTION, SECOND.DESCRIPTION) AS DESCRIPTION
             FROM AllParts A
                      LEFT JOIN FirstQuery FIRST ON A.UNIT_ID = FIRST.UNIT_ID AND FIRST.RN = 1
                      LEFT JOIN SecondQuery SECOND ON A.UNIT_ID = SECOND.UNIT_ID AND SECOND.RN = 1
         )
    SELECT A.UNIT_ID,
           A.UNIT_ID_TYPE,
           A.CREATED,
           A.REMOVED,
           F.ORDER_INFO,
           F.UNIT_ID_TYPE AS ORDER_UNIT_ID_TYPE,
           F.UPDATED,
           F.MATERIAL,
           F.DESCRIPTION
    FROM AllParts A
             LEFT JOIN FinalResult F ON A.UNIT_ID = F.UNIT_ID
    ORDER BY A.CREATED;
-- BLOCK_END