SELECT mrk.mrk_reihe AS ORDER_ID, 
       mrk.mrk_num AS TEST_ID, 
       mrk.mrk_num_lng, 
       med2.mrk_sub_num AS SUB_ORDER_ID, 
       mrk.mrk_bez AS DESCRIPTION, 
       med2.mrk_wert AS VALUE, 
       med2.mrk_ein_gut AS RESULT, 
       mrk.mrk_usg AS MIN_VAL, 
       mrk.mrk_osg AS MAX_VAL, 
       mrk.mrk_einheit AS VALUE_TYPE, 
       mrk.mrk_datentyp, 
       aslp.aslp_kom AS ATTRIBUTE, 
       mxt2.mrk_txt AS TEST_TEXTINFO
FROM evaprod.pd_lfd_run plr, 
     evaprod.pd_stm_prp prp, 
     evaprod.pd_stm_mrk mrk, 
     evaprod.pd_lfd_med2 med2, 
     evaprod.pd_lfd_mxt2 mxt2, 
     pd_stm_aslp aslp 
WHERE plr.runid = :unitId
  AND plr.run_key_prt = :key 
  AND  plr.run_key_prt = med2.run_key_prt 
  AND plr.run_seq_key = :seq 
  AND  plr.run_seq_key = med2.run_seq_key 
  AND plr.prp_date_id = prp.prp_date_id 
  AND plr.prp_date_id = mrk.prp_date_id 
  AND mrk.mrk_num = med2.mrk_num 
  AND plr.run_key_prt = mxt2.run_key_prt(+) 
  AND  plr.run_seq_key = mxt2.run_seq_key(+) 
  AND  med2.mrk_num = mxt2.mrk_num(+) 
  AND mrk.asl_date_id = aslp.asl_date_id(+) 
  AND  med2.mrk_wert = aslp.aslp_num(+)
ORDER BY med2.mrk_ein_gut, mrk.mrk_reihe, med2.mrk_sub_num