using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text.RegularExpressions;

namespace AnalyseToolExtension.QueryCodes
{
    public static class QuerySelector
    {
        public static void Get(string query,out string data)
        {
            if (string.IsNullOrEmpty(query)) {data = null; return;}
            query = query.Replace(".sql", "");
            var resourceName = $"AnalyseToolExtension.QueryCodes.{query}.sql";

            var assembly = Assembly.GetExecutingAssembly();

            using (var stream = assembly.GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    Console.WriteLine($"Resource not found! Time : {DateTime.Now} | File : {resourceName} | Query : {query}");
                    data = null;
                    return;
                }
                using (var reader = new StreamReader(stream))
                {
                    var sqlQuery = reader.ReadToEnd();
                    data = sqlQuery;
                }
            }
        }

        public static string Get(string query,Dictionary<string,string> properties = null)
        {
            if(string.IsNullOrEmpty(query)) return null;
            QuerySelector.Get(query, out var data);
            if (properties != null && properties.Count > 0)
            {
                properties.Keys.ToList().ForEach(ps => { data = data.Replace(ps, $"'{properties[ps]}'"); });
            }
            return data;
        }

        public static string Get(string query, string blockName, Dictionary<string, string> properties = null)
        {
            if (string.IsNullOrEmpty(query)) return null;
            QuerySelector.Get(query, out var data);
            if (properties != null && properties.Count > 0)
            {
                properties.Keys.ToList().ForEach(ps => { data = data.Replace(ps, $"'{properties[ps]}'"); });
            }
            var regex = new Regex($@"-- BLOCK_START\s*{blockName}\s*([\s\S]*?)-- BLOCK_END", RegexOptions.IgnoreCase);
            var match = regex.Match(data);

            return match.Success ? match.Groups[1].Value.Trim().Replace(";","") : throw new Exception($"Lekérdezés '{blockName}' nem található.");
        }

        public static List<string> QueryNames()
        {
            return Assembly.GetExecutingAssembly().GetManifestResourceNames()
                .Where(r => r.StartsWith("AnalyseToolExtension.QueryCodes") && r.EndsWith(".sql")).ToList();
        }
    }
}