﻿using System;
using System.Diagnostics;
using System.Windows;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Threading;

namespace AnalyseToolWpf
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App
    {
        private readonly DispatcherTimer memoryCheckTimer;
        private bool isSoftwareModeActive = false;
        /*protected override void OnStartup(StartupEventArgs e)
        {
            RenderOptions.ProcessRenderMode = RenderMode.SoftwareOnly;
            base.OnStartup(e);
        }*/
        public App()
        {
            memoryCheckTimer = new DispatcherTimer
            {
                Interval = TimeSpan.FromSeconds(5)
            };
            memoryCheckTimer.Tick += CheckMemoryUsage;
            memoryCheckTimer.Start();
        }
        private void CheckMemoryUsage(object sender, EventArgs e)
        {
            long memoryUsed = Process.GetCurrentProcess().PrivateMemorySize64 / (1024 * 1024); // MB-ban

            if (memoryUsed >= 500 && !isSoftwareModeActive)
            {
                // Ha elérte az 500MB-ot, váltsunk szoftveres módra
                SetRenderMode(true);
                isSoftwareModeActive = true;

                // 10 másodperc után állítsuk vissza hardveres módra
                DispatcherTimer resetTimer = new DispatcherTimer
                {
                    Interval = TimeSpan.FromSeconds(10)
                };
                resetTimer.Tick += (s, args) =>
                {
                    SetRenderMode(false);
                    isSoftwareModeActive = false;
                    resetTimer.Stop();
                };
                resetTimer.Start();
            }
        }

        private void SetRenderMode(bool softwareMode)
        {
            HwndSource hwndSource = PresentationSource.FromVisual(MainWindow) as HwndSource;
            if (hwndSource != null)
            {
                hwndSource.CompositionTarget.RenderMode = softwareMode ? RenderMode.SoftwareOnly : RenderMode.Default;
            }
            Console.WriteLine("RenderModeChanged");
        }
    }
    
}