using System;
using System.Data;
using System.Runtime;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using Microsoft.Win32;

namespace AnalyseToolWpf.CustomControls
{
    public partial class CaptionButtons : UserControl
    {
        protected override System.Windows.Automation.Peers.AutomationPeer OnCreateAutomationPeer() { return null; }
        
        private Window _parentWindow;
        public Window ParentWindow { get => _parentWindow; set { _parentWindow = value; ParentWindowStateChanged(); } }

        private bool? _useCloseButton = true;
        public bool? UseCloseButton { get => _useCloseButton; set { _useCloseButton = value; ButtonStateChanged(); } }
        
        private bool? _useMinimizeButton = true;
        public bool? UseMinimizeButton { get => _useMinimizeButton; set { _useMinimizeButton = value; ButtonStateChanged(); } }
        
        private bool? _useMaximizeRestoreButton = true;
        public bool? UseMaximizeRestoreButton { get => _useMaximizeRestoreButton; set { _useMaximizeRestoreButton = value; ButtonStateChanged(); } }

        private void ButtonStateChanged()
        {
            Dispatcher.Invoke(() =>
            {
                CloseBtn.Visibility = _useCloseButton == true? Visibility.Visible : Visibility.Collapsed;
                MinimizeBtn.Visibility = _useMinimizeButton == true? Visibility.Visible : Visibility.Collapsed;
                MaximizeBtn.Visibility = _useMaximizeRestoreButton == true? Visibility.Visible : Visibility.Collapsed;
            });
        }

        private void ParentWindowStateChanged()
        {
            if (_parentWindow != null)
            {
                //_parentWindow.SizeChanged += Window_SizeChanged;
                //_parentWindow.SourceInitialized += CaptionButtons_SourceInitialized;
                _parentWindow.StateChanged += Window_StateChanged;
                if (_parentWindow.ResizeMode != ResizeMode.CanResize &&
                    _parentWindow.ResizeMode != ResizeMode.CanResizeWithGrip)
                {
                    Dispatcher.Invoke(() =>
                    {
                        MaximizeBtn.Visibility = Visibility.Collapsed;
                    });
                }
            }
        }
        
        public CaptionButtons() { InitializeComponent(); }
        private void Maximize_Click(object sender, RoutedEventArgs e)
        {
            //var hwnd = new WindowInteropHelper(this._parentWindow).Handle;
            if (this._parentWindow.WindowState == WindowState.Maximized)
            {
                //SendMessage(hwnd, WM_SYSCOMMAND, (IntPtr)SC_RESTORE, IntPtr.Zero);
                this._parentWindow.WindowState = WindowState.Normal;
            }
            else
            {
                //SendMessage(hwnd, WM_SYSCOMMAND, (IntPtr)SC_MAXIMIZE, IntPtr.Zero);
                this._parentWindow.WindowState = WindowState.Maximized;
            }
        }
        private void Minimize_Click(object sender, RoutedEventArgs e) { this.ParentWindow.WindowState = WindowState.Minimized; }
        private void Close_Click(object sender, RoutedEventArgs e) { this.ParentWindow.Close(); }
        private void Window_StateChanged(object sender, EventArgs e)
        {
            if (_parentWindow.WindowState == WindowState.Maximized)
            {
                _parentWindow.BorderThickness = new System.Windows.Thickness(8);
                this.MaximizeBtn.Content = this.FindResource("RestoreIcon");
            }
            else
            {
                _parentWindow.BorderThickness = new System.Windows.Thickness(0,0,0,0);
                this.MaximizeBtn.Content = this.FindResource("MaximizeIcon");
            }

            GCSettings.LargeObjectHeapCompactionMode = GCLargeObjectHeapCompactionMode.CompactOnce;
            GC.SuppressFinalize(_parentWindow);
            GC.Collect();
        }
    }
}