using System.Collections.Generic;
using System.Linq;
using System.Windows.Media;
using AnalyseToolExtension.DataObjects;

namespace AnalyseToolWpf.DataObjects;

public class EvaRunPopUpViewModel
{
    public string IdType { get; set; }
    public string RunDate { get; set; }
    public string Result { get; set; }
    public Brush ResultBrush { get; set; }
    public string Material { get; set; }
    public string TestPlan { get; set; }
    public string TestPlanVersion { get; set; }
    public string Station { get; set; }
    public string Order { get; set; }
    public string Tsw { get; set; }
    public string TswVersion { get; set; }
    public string TswType { get; set; }
    public string GlobalText { get; set; }
    public List<EvaTestInfoViewModel> TestInfo { get; set; }

    public EvaRunPopUpViewModel(EvaInfo eva, List<EvaTestInfo> testInfo, string globalText)
    {
        IdType = eva.UnitIdType;
        RunDate = eva.DateTime?.ToString("yyyy-MM-dd HH:mm:ss");
        switch (eva.Result)
        {
            case UnitState.None: { Result = string.Empty; ResultBrush = Brushes.Transparent; break;}
            case UnitState.Pass: { Result = "PASS"; ResultBrush = new SolidColorBrush(Color.FromArgb(200,0,238,0)); break;}
            case UnitState.Fail: { Result = "FAIL"; ResultBrush = new SolidColorBrush(Color.FromArgb(200,255,0,0)); break;}
            case UnitState.Scrap: { Result = "SCRAP"; ResultBrush = new SolidColorBrush(Color.FromArgb(200,255,165,0)); break;}
            case UnitState.CheckIn: { Result = "CHECKIN"; ResultBrush = new SolidColorBrush(Color.FromArgb(200,0,191,255)); break;}
        }
        Material = eva.Material;
        TestPlan = eva.TestPlanName;
        TestPlanVersion = eva.TestPlanVersion;
        Station = eva.Station;
        GlobalText = globalText;
        Order = eva.Order;
        Tsw = eva.TestSoftware;
        TswVersion = eva.TestSoftwareVersion;
        TswType = eva.TestSoftwareType;
        TestInfo = testInfo.Select(ti => new EvaTestInfoViewModel()
        {
            TestId = ti.Id,
            TestCount = ti.Sequence,
            SubCount = ti.SubSequence,
            Attribute = ti.Attribute,
            Description = ti.Description,
            Result = ti.Result.ToString("G"),
            Value = ti.Value?.ToString("0.#"),
            ValueType = ti.ValueType,
            MinValue = ti.MinValue?.ToString("0.#"),
            MaxValue = ti.MaxValue?.ToString("0.#"),
            TestInfo = ti,
        }).ToList();
    }
}

public class EvaTestInfoViewModel
{
    public string TestCount { get; set; }
    public string SubCount { get; set; }
    public string TestId { get; set; }
    public string Description { get; set; }
    public string Result { get; set; }
    public string Value {get; set;}
    public string MinValue { get; set; }
    public string MaxValue { get; set; }
    public string ValueType { get; set; }
    public string Attribute { get; set; }
    public EvaTestInfo TestInfo { get; set; }
    public Brush RowHeaderBrush => TestInfo.Result == UnitState.Fail ? new SolidColorBrush(Colors.Red) : new SolidColorBrush(Colors.Transparent);
    
}