using System;
using System.ComponentModel;
using System.Windows;
using MaterialDesignThemes.Wpf;

namespace AnalyseToolWpf.DataObjects
{
    public class PageData : INotifyPropertyChanged
    {
        public event EventHandler SelectedEvent;
        public event EventHandler<MaterialDesignThemes.Wpf.BaseTheme> ThemeChanged;
        public event PropertyChangedEventHandler PropertyChanged;
        public void SelectedInvoke() => SelectedEvent?.Invoke(this, EventArgs.Empty);
        public void ThemeChangedInvoke(MaterialDesignThemes.Wpf.BaseTheme theme) => ThemeChanged?.Invoke(this, theme);
        public string Name { get; set; }
        public string DisplayName { get; set; }
        public PackIconKind? MenuItemIcon { get; set; } = null;
        public string MenuItemText { get; set; } = null;
        public DependencyObject MenuItemContent { get; set; } = null;
        public DependencyObject PageContent { get; set; } = null;
        public Visibility IsMenuIconShow => MenuItemIcon == null ? Visibility.Collapsed : Visibility.Visible;
        public Visibility IsMenuTextShow => MenuItemText == null ? Visibility.Collapsed : Visibility.Visible;
        public Visibility IsMenuContentShow => MenuItemContent == null ? Visibility.Collapsed : Visibility.Visible;
        private Visibility _chipVisibility = Visibility.Collapsed;

        public Visibility ChipVisibility
        {
            get => _chipVisibility;
            set { _chipVisibility = value; OnPropertyChanged("ChipVisibility"); }
        }
        protected void OnPropertyChanged(string name)
        {
            var handler = PropertyChanged;
            handler?.Invoke(this, new PropertyChangedEventArgs(name));
        }

        private bool _isWorkingOn = false;

        public bool IsWorkingOn
        {
            get => _isWorkingOn;
            set { _isWorkingOn = value; OnPropertyChanged("IsWorkingOn"); }
        }

        public bool IsExtendedPage { get; set; } = false;
    }
}