using System;
using System.Collections.Generic;
using System.Reflection;
using System.Windows;
using MaterialDesignThemes.Wpf;

namespace AnalyseToolWpf.DataObjects
{
    public class PluginData
    {
        public event EventHandler ValueChanged;
        public PluginInfo Info { get; set; }
        public PluginContentPage ContentPage { get; set; }
        public List<PluginOption> Options { get; set; }
    }

    public class PluginInfo
    {
        public string Id { get; set; }
        public string Name { get; set; }
        public Version Version { get; set; }
        public string Description { get; set; }
        public string Author { get; set; }
        public string Copyright { get; set; }
    }

    public class PluginContentPage
    {
        public string Name { get; set; }
        public PackIconKind? MenuItemIcon { get; set; } = null;
        public string MenuItemText { get; set; } = null;
        public DependencyObject MenuItemContent { get; set; } = null;
        public string MenuItemToolTip { get; set; } = null;
        public DependencyObject PageContent { get; set; } = null;
        public Visibility SearchBarVisibility { get; set; } = Visibility.Visible;
        public Visibility PageStepButtonVisibility { get; set; } = Visibility.Visible;
        public Visibility RefreshButtonVisibility { get; set; } = Visibility.Visible;
        public Visibility IsMenuIconShow => MenuItemIcon == null ? Visibility.Collapsed : Visibility.Visible;
        public Visibility IsMenuTextShow => MenuItemText == null ? Visibility.Collapsed : Visibility.Visible;
        public Visibility IsMenuContentShow => MenuItemContent == null ? Visibility.Collapsed : Visibility.Visible;
    }

    public class PluginOption
    {
        public string Name { get; set; }
        public string Description { get; set; }
        public object DefaultValue { get; set; }
        public bool IsVisible { get; set; } = true;
        private object _value = null;
        public object Value
        {
            get => _value ?? DefaultValue;
            set => _value = value;
        }
    }

    public class PluginOptionInt : PluginOption
    {
        public int? MinValue { get; set; } = null;
        public int? MaxValue { get; set; } = null;
        public bool UseUpDownButtons { get; set; } = false;
        public int Increment { get; set; } = 1;
        public int? GetValue => int.TryParse(Value?.ToString(), out var result) ? result : (int?)null;
    }

    public class PluginOptionNullableBool : PluginOption
    {
        public bool? GetValue => bool.TryParse(Value?.ToString(), out var result) ? result : (bool?)null;
    }

    public class PluginOptionBool : PluginOption
    {
        public bool GetValue => bool.TryParse(Value?.ToString(), out var result) && result;
    }

    public class PluginOptionSelector : PluginOption
    {
        public List<string> Options { get; set; } = new List<string>();
        public int DefaultOptionIndex { get; set; } = -1;
        public int GetSelectedIndex => Options.IndexOf(Value?.ToString());
    }
    
    public enum PluginContentType { Page, Window, Console, DirectCode, IndirectCode, PopUp, Theme, ExternalWindow, CalExtension }
}