using System;
using System.Windows;
using AnalyseToolExtension.DataObjects;


namespace AnalyseToolWpf.DataObjects
{
    public static class StaticSettings
    {
        public static event EventHandler<string> SearchBarInvoke;
        public static event EventHandler<string> DebugTextFieldInvoke;
        public static event EventHandler NextPageClick;
        public static event EventHandler PrevPageClick;
        public static event EventHandler RefreshClick;
        public static event EventHandler<QueryObject> QueryDataInvoke;
        public static event EventHandler<DependencyObject> PopUpContentInvoke;
        public static string CurrentSelId = null;

        public static void InvokeSearchBarInvoke(string text) { SearchBarInvoke?.Invoke(null, text.Trim());
            CurrentSelId = text.Trim();
        }
        public static void InvokeNextPageClick() { NextPageClick?.Invoke(null, null); }
        public static void InvokePrevPageClick() { PrevPageClick?.Invoke(null, null); }
        public static void InvokeRefreshClick() { RefreshClick?.Invoke(null, null); }
        public static void InvokeQueryDataInvoke(QueryObject query) { QueryDataInvoke?.Invoke(null, query); }

        public static void ShowPopUp(DependencyObject content)
        {
            PopUpContentInvoke?.Invoke(content, null);
        }

        public static void SetDebugTextField(string text)
        {
            DebugTextFieldInvoke?.Invoke(text, null);
        }
    }
    
}