using System;
using System.Windows;
using System.Windows.Media.Imaging;
using AnalyseToolWpf.DataObjects;
using AnalyseToolWpf.Pages;
using MaterialDesignThemes.Wpf;
using SharpDX.Direct2D1;

namespace AnalyseToolWpf.IntegratedPlugins
{
    public class AimPageData : PageData
    {
        public AimPageData()
        {
            this.Name = "AutomatedItemManipulator";
            this.DisplayName = "Automated Item Manipulator";
            this.MenuItemText = "AIM";
            PageContent = new AimPage();
            StaticSettings.SearchBarInvoke += SearchFieldChanged;
            this.SelectedEvent += (sender, args) =>
            {
                if(ChipVisibility == Visibility.Visible) ChipVisibility = Visibility.Collapsed;
            };
            this.ThemeChanged += (sender, args) =>
            {
                /*if (PageContent is AimPage ap)
                {
                    if (args == BaseTheme.Dark)
                    {
                        ap.BgImageTest.Source =
                            new BitmapImage(new Uri("pack://application:,,,/CustomResources/Images/DarkColorFlow.png"));
                    }
                    else
                    {
                        ap.BgImageTest.Source =
                            new BitmapImage(new Uri("pack://application:,,,/CustomResources/Images/LightColorFlow.jpg"));
                    }
                }*/
            };
            IsExtendedPage = true;
        }

        public async void SearchFieldChanged(object sender, string e)
        {
            ChipVisibility = Visibility.Visible;
            /*var qry = new AnalyseToolExtension.Query.ComplexQuery();
            if (this.ContentPage.PageContent is DefaultPage dp)
            {
                dp.DataContext = new UnitInfoViewModel(await qry.GetUnitInfo(e));
            }*/
        }
    }
}