using System;
using System.Linq;
using System.Reflection;
using AnalyseToolPluginContracts;
using AnalyseToolWpf.DataObjects;
using MaterialDesignThemes.Wpf;
using PageData = AnalyseToolWpf.DataObjects.PageData;

namespace AnalyseToolWpf.IntegratedPlugins;

public class TestPageData : PageData
{
    public TestPageData()
    {
        var pluginAssembly = Assembly.LoadFrom(@"C:\Users\uif16603\Documents\ContiCom\AtTestPlugin\bin\Debug\AtTestPlugin.dll");
        var type = pluginAssembly.GetType("AtTestPlugin.TestPlugin");
        var plugin = (IAnalyseToolPlugin)Activator.CreateInstance(type);
        var pgd = (AnalyseToolPluginContracts.PageData)plugin.Contents.FirstOrDefault(pg=>pg.GetType() == typeof(AnalyseToolPluginContracts.PageData));
        this.Name = plugin.Name;
        this.DisplayName = plugin.Name;
        var mit = pgd?.MenuItem.MenuItemText;
        if (mit != null && mit.Contains("Icon."))
        {
            this.MenuItemIcon = Enum.TryParse<PackIconKind>(mit.Replace("Icon.",""),out var res) ? res : null;
        }
        else
        {
            this.MenuItemText = mit;
        }
        this.PageContent = pgd?.PageContent;
        //StaticSettings.SearchBarInvoke += SearchFieldChanged;
        /*this.SelectedEvent += (sender, args) =>
        {
            if(ChipVisibility == Visibility.Visible) ChipVisibility = Visibility.Collapsed;
        };*/
    }
}