using System;
using System.Runtime;
using System.Windows;
using System.Windows.Controls;
using AnalyseToolWpf.DataObjects;
using AnalyseToolWpf.Pages;
using MaterialDesignThemes.Wpf;

namespace AnalyseToolWpf.IntegratedPlugins
{
    public class UnitInfoPageData : PageData
    {
        public UnitInfoPageData()
        {
            this.Name = "Unit Info";
            this.DisplayName = "Egység keresés";
            this.MenuItemIcon = PackIconKind.DataMatrix;
            this.PageContent = new DefaultPage();
            StaticSettings.SearchBarInvoke += SearchFieldChanged;
            this.SelectedEvent += (sender, args) =>
            {
                if(ChipVisibility == Visibility.Visible) ChipVisibility = Visibility.Collapsed;
            };
        }

        public async void SearchFieldChanged(object sender, string e)
        {
            var qry = new AnalyseToolExtension.Query.ComplexQuery();
            if (this.PageContent is DefaultPage dp)
            {
                dp.IsEnabled = false;
                this.IsWorkingOn = true;
                dp.DataContext = null;
                dp.DataContext = new UnitInfoViewModel(await qry.GetUnitInfo(e));
                this.IsWorkingOn = false;
                dp.IsEnabled = true;
                dp.SearchTextBox.Focus();
                GCSettings.LargeObjectHeapCompactionMode = GCLargeObjectHeapCompactionMode.CompactOnce;
                GC.Collect();
            }
            GC.Collect(0, GCCollectionMode.Forced, true,true);
        }
    }
}