using System;
using System.Linq;
using System.Windows;

namespace AnalyseToolWpf.Languages
{
    public class ChangeLanguage
    {
        public ChangeLanguage(string lang)
        {
            var dictPath = $"Languages/Strings.{lang}.xaml";
            
            var newDict = new ResourceDictionary { Source = new Uri(dictPath, UriKind.Relative) };

            var oldDict = Application.Current.Resources.MergedDictionaries
                .FirstOrDefault(d => d.Source != null && d.Source.OriginalString.Contains("Languages/Strings"));

            if (oldDict != null)
            {
                var index = Application.Current.Resources.MergedDictionaries.IndexOf(oldDict);
                Application.Current.Resources.MergedDictionaries[index] = newDict;
            }
            else
            {
                Application.Current.Resources.MergedDictionaries.Add(newDict);
            }
        }
    }
}