﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using AnalyseToolWpf.DataObjects;
using AnalyseToolWpf.IntegratedPlugins;
using MaterialDesignThemes.Wpf;

namespace AnalyseToolWpf
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow
    {
        private bool _darkMode = true;

        public void ShowPopUp(DependencyObject popUpObject)
        {
            Dispatcher.Invoke(() =>
            {
                PopUpBase.Visibility = Visibility.Visible;
                //ContentGrid.Visibility = Visibility.Collapsed;
                PopUpContent.Content = popUpObject;
                GC.Collect();
                GCSettings.LargeObjectHeapCompactionMode = GCLargeObjectHeapCompactionMode.CompactOnce;
                GC.Collect();
                //SetRenderMode(true);
            });
        }

        public void HidePopUp()
        {
            Dispatcher.Invoke(() =>
            {
                PopUpBase.Visibility = Visibility.Collapsed;
                //ContentGrid.Visibility = Visibility.Visible;
                PopUpContent.Content = null;
                GC.Collect();
                GCSettings.LargeObjectHeapCompactionMode = GCLargeObjectHeapCompactionMode.CompactOnce;
                GC.Collect();
                //SetRenderMode(false);
            });
        }
        public void SetRenderMode(bool softwareMode)
        {
            HwndSource hwndSource = PresentationSource.FromVisual(Application.Current.MainWindow) as HwndSource;
            if (hwndSource != null)
            {
                hwndSource.CompositionTarget.RenderMode = softwareMode ? RenderMode.SoftwareOnly : RenderMode.Default;
            }
        }


        private List<PageData> _pages = new List<PageData>()
        {
            new UnitInfoPageData(),
            new ListViewPageData(),
            new AimPageData(),
            new TestPageData()
        };
        public MainWindow()
        {
            InitializeComponent();
            StartUpPage();
        }

        public async void StartUpPage()
        {
            if (PresentationSource.FromVisual(this) is HwndSource { CompositionTarget: not null } hwndSource) hwndSource.CompositionTarget.RenderMode = RenderMode.SoftwareOnly;
            await AnalyseToolExtension.Clients.MesClient.Connect();
            await AnalyseToolExtension.Clients.ProductAnalyzeClient.Connect();
            await Task.Run(() => { Thread.Sleep(1500); });
            LoadingPageControl.IsEnabled = false;
            StartUpGrid.IsHitTestVisible = false;
            PluginListBox.ItemsSource = _pages;
            StaticSettings.PopUpContentInvoke += (sender, o) =>
            {
                ShowPopUp(sender as DependencyObject);
            };
            StaticSettings.DebugTextFieldInvoke += (sender, o) =>
            {
                Dispatcher.Invoke(() =>
                {
                    this.DebugTextField.Text = sender.ToString();
                });
            };
            StaticSettings.SearchBarInvoke += (sender, o) =>
            {
                if (PluginListBox.SelectedIndex != 0) Dispatcher.Invoke(() => { PluginListBox.SelectedIndex = 0; });
            };
            //UpdatePopupShadow();
        }
        

        #region WindowControls
        
        private void Window_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            
            //this.DebugTextField.Text = $"Size[W:{ActualWidth}px | H:{ActualHeight}px] | WindowStyle: {WindowStyle:G} | WindowState: {WindowState:G}";
            //FrameContent.Width = Presenter.ActualWidth;
            //FrameContent.Height = Presenter.ActualHeight;
            /*
            _resizeTokenSource?.Cancel();
            _resizeTokenSource = new CancellationTokenSource();
            var token = _resizeTokenSource.Token;

            Task.Run(() =>
            {
                try
                {
                    Task.Delay(1, token).Wait(token);
                    if (token.IsCancellationRequested) return;
                    Dispatcher.Invoke(() =>
                    {
                        FrameContent.Width = Presenter.ActualWidth;
                        FrameContent.Height = Presenter.ActualHeight;
                    });
                }
                catch (OperationCanceledException) { }
            }, token);*/
        }
        
        
        #endregion
        
        private void SwitchThemeBtn_OnClick(object sender, RoutedEventArgs e)
        {
            _darkMode = !_darkMode;
            //SwitchThemeBtnIcon.Kind = _darkMode ? PackIconKind.LightbulbVariant : PackIconKind.LightbulbVariantOutline;
            SetTheme(_darkMode);
        }
        
        private void SetTheme(bool darkMode)
        {
            var paletteHelper = new PaletteHelper();
            var theme = paletteHelper.GetTheme();

            theme.SetBaseTheme(darkMode ? BaseTheme.Dark : BaseTheme.Light);

            paletteHelper.SetTheme(theme);
            _pages.ForEach(pg => { pg.ThemeChangedInvoke(darkMode ? BaseTheme.Dark : BaseTheme.Light); });
        }

        private void Selector_OnSelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            Dispatcher.Invoke(() =>
            {
                if (PluginListBox.SelectedItem is PageData data)
                {
                    FrameContent.Content = null;
                    FrameContent.Content = data.PageContent;
                    data.SelectedInvoke();
                    Grid.SetColumnSpan(FrameContent, data.IsExtendedPage ? 2 : 1);
                    Grid.SetColumn(FrameContent, data.IsExtendedPage ? 0 : 1);
                }
            });
            GC.Collect();
            GCSettings.LargeObjectHeapCompactionMode = GCLargeObjectHeapCompactionMode.CompactOnce;
            GC.Collect();
        }

        private void PopUpOpenExternalButton_OnClick(object sender, RoutedEventArgs e)
        {
            var ext = new ExternalWindow();
            ext.SetContent(PopUpContent.Content as DependencyObject);
            ext.Owner = this;
            ext.Show();
            HidePopUp();
        }

        private void PopUpClose_OnClick(object sender, RoutedEventArgs e)
        {
            HidePopUp();
        }

        private void PopUpBackground_OnPreviewMouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            HidePopUp();
        }

        private void ResetPluginButton_OnClick(object sender, RoutedEventArgs e)
        {
            
        }
    }
}