using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using AnalyseToolWpf.DataObjects;

namespace AnalyseToolWpf.Pages
{
    public partial class DefaultPage : UserControl
    {
        public DefaultPage()
        {
            InitializeComponent();
        }

        public void CopyBox(object sender, RoutedEventArgs e)
        {
            if (sender is TextBox tb)
            {
                Dispatcher.Invoke(() =>
                {
                    Clipboard.SetText(tb.Text);
                });
            }
        }

        private async void EvaRunDataGrid_OnMouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            DependencyObject source = e.OriginalSource as DependencyObject;

            while (source != null && !(source is DataGridRow))
                source = VisualTreeHelper.GetParent(source);

            if (source is DataGridRow row && EvaRunDataGrid.SelectedItem is EvaInfoViewModel eva)
            {
                var etr = await AnalyseToolExtension.Query.MesQuery.GetEvaTestInfo(eva.EvaInfo.UnitId, eva.Key, eva.Seq);
                var gti = await AnalyseToolExtension.Query.MesQuery.GetEvaTestTextInfo(eva.EvaInfo.UnitId, eva.Key, eva.Seq);
                var erpVm = new EvaRunPopUpViewModel(eva.EvaInfo, etr, gti);
                StaticSettings.ShowPopUp(new EvaRunPopUp { DataContext = erpVm });
                erpVm = null;
            }
        }

        private void SearchTextBox_OnPreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key != Key.Return || SearchTextBox.IsReadOnly) return;
            var srcString = string.Empty;
            Dispatcher.Invoke(() =>
            {
                srcString = SearchTextBox.Text;
                SearchTextBox.Text = string.Empty;
            });
            StaticSettings.InvokeSearchBarInvoke(srcString);
        }

        private void PrevButton_OnClick(object sender, RoutedEventArgs e)
        {
            //throw new System.NotImplementedException();
        }

        private void NextButton_OnClick(object sender, RoutedEventArgs e)
        {
            //throw new System.NotImplementedException();
        }

        private void RefreshButton_OnClick(object sender, RoutedEventArgs e)
        {
            StaticSettings.InvokeSearchBarInvoke(StaticSettings.CurrentSelId);
        }

        private void BuildInDataGrid_OnMouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            var source = e.OriginalSource as DependencyObject;

            while (source != null && !(source is DataGridRow))
                source = VisualTreeHelper.GetParent(source);

            if (source is DataGridRow row && BuildInDataGrid.SelectedItem is BuildInfoViewModel biv)
            {
                StaticSettings.InvokeSearchBarInvoke(biv.UnitId);
            }
        }
    }
}