using System;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using AnalyseToolWpf.DataObjects;
using Microsoft.Win32;

namespace AnalyseToolWpf.Pages
{
    public partial class ListSearchPage : UserControl
    {
        public event EventHandler<bool> IsWorkingOn;
        public ListSearchPage()
        {
            InitializeComponent();
        }

        private void SearchTextBox_OnTextChanged(object sender, TextChangedEventArgs e)
        {
            /*LineNumbersPanel.Children.Clear();
            var lines = SearchTextBox.Text.Split('\n');
            var carPos = SearchTextBox.GetLineIndexFromCharacterIndex(SearchTextBox.CaretIndex);
            
            
            for (int i = 0; i < lines.Length; i++)
            {
                var inRow = carPos == i;
                var textBlock = new TextBlock
                {
                    Text = (i + 1).ToString(),
                    FontFamily = SearchTextBox.FontFamily,
                    FontSize = SearchTextBox.FontSize,
                    Background = inRow ? new SolidColorBrush(Color.FromArgb(150,180,180,180)) : Brushes.Transparent,
                    Margin = new Thickness(5, 0, 0, 0),
                    Opacity = 0.5,
                };
                textBlock.SetResourceReference(ForegroundProperty, "MaterialDesignBody");
                LineNumbersPanel.Children.Add(textBlock);
            }*/
            UpdateLineNumbers();
        }

        private void SearchTextBox_OnScrollChanged(object sender, ScrollChangedEventArgs e)
        {
            Dispatcher.Invoke(() =>
            {
                //TextBoxLineNumbersViewer.ScrollToVerticalOffset(e.VerticalOffset);
                TextBoxLineNumbers.ScrollToVerticalOffset(SearchTextBox.VerticalOffset);
            });
            //UpdateLineNumbers();
        }

        //private int _totalLines = 0;
        private void UpdateLineNumbers()
        {
            var data = SearchTextBox.Text;
            var spt = data.Split('\n');
            var noLines = string.IsNullOrEmpty(data) ? 0 : spt.Length;
            var sb = new StringBuilder();
            var ri = 1;
            for (var i = 1; i <= noLines; i++)
            {
                if (string.IsNullOrWhiteSpace(spt[i - 1]))
                {
                    sb.AppendLine(" ");
                }
                else
                {
                    sb.AppendLine(ri.ToString());
                    ri++;
                }
            }

            TextBoxLineNumbers.Text = sb.ToString();
            SearchTextBox.Text = data??"";
        }

        private void StartSearchButton_OnClick(object sender, RoutedEventArgs e)
        {
            var data = SearchTextBox.Text;
            var noLines = data.Split('\n');
            LoadUnitList(noLines);
        }

        private async void LoadUnitList(string[] unitIds)
        {
            var qry = new AnalyseToolExtension.Query.ComplexQuery();
            ListReturnDataGrid.Items.Clear();
            IsWorkingOn?.Invoke(this, true);
            SearchTextBox.IsReadOnly = true;
            SearchBoxButtonsPanel.IsEnabled = false;
            foreach (var id in unitIds)
            {
                if(string.IsNullOrWhiteSpace(id)) continue;
                var uiv = new UnitInfoViewModel(await qry.GetUnitInfo(id.Trim()));
                ListReturnDataGrid.Items.Add(uiv);
            }
            SearchTextBox.IsReadOnly = false;
            SearchBoxButtonsPanel.IsEnabled = true;
            IsWorkingOn?.Invoke(this, false);
        }

        private void ImportListButton_OnClick(object sender, RoutedEventArgs e)
        {
            var dlg = new OpenFileDialog();
            dlg.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*";
            if (dlg.ShowDialog() == true)
            {
                var ctn = File.ReadAllText(dlg.FileName);
                SearchTextBox.Text = ctn;
            }

            dlg = null;
        }

        private void CopyListButton_OnClick(object sender, RoutedEventArgs e)
        {
            Clipboard.SetText(SearchTextBox.Text);
        }

        private void PasteListButton_OnClick(object sender, RoutedEventArgs e)
        {
            SearchTextBox.Text = Clipboard.GetText();
        }

        private void ClearListButton_OnClick(object sender, RoutedEventArgs e)
        {
            SearchTextBox.Text = string.Empty;
        }

        private void ListReturnDataGrid_OnMouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            var source = e.OriginalSource as DependencyObject;

            while (source != null && !(source is DataGridRow))
                source = VisualTreeHelper.GetParent(source);

            if (source is DataGridRow row && ListReturnDataGrid.SelectedItem is UnitInfoViewModel biv)
            {
                StaticSettings.InvokeSearchBarInvoke(biv.UnitId);
            }
        }
    }
}