﻿using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Timers;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Threading;
using AnalyseToolExtension.DataObjects;
using AnalyseToolExtension.Query;
using AndonMonitor.StaticWorkers;
using AndonMonitor.ViewModels;
using MaterialDesignThemes.MahApps;
using MaterialDesignThemes.Wpf;
using Timer = System.Threading.Timer;

namespace AndonMonitor
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow
    {
        //private readonly AnalyseToolExtension.Clients.MesDataBase _mdb = new AnalyseToolExtension.Clients.MesDataBase();
        private Timer _timer;
        private Andon _and01;
        private string[] _lines;
        private string _selectedLine;
        public MainWindow()
        {
            InitializeComponent();
            SuggestBox.Loaded += (s, e) =>
            {
                var lib = (ListBox)SuggestBox.Template.FindName("PART_AutoSuggestBoxList", SuggestBox);
                var poe = (Card)SuggestBox.Template.FindName("PopupCard", SuggestBox);
                if (lib != null)
                {
                    lib.Style = (Style)FindResource("MaterialDesignListBoxModify");
                    ScrollViewer.SetVerticalScrollBarVisibility(lib, ScrollBarVisibility.Auto);
                    ScrollViewer.SetHorizontalScrollBarVisibility(lib, ScrollBarVisibility.Disabled);
                    VirtualizingPanel.SetIsVirtualizing(lib, true);
                    VirtualizingPanel.SetVirtualizationMode(lib, VirtualizationMode.Recycling);
                    ScrollViewerAssist.SetCornerRectangleVisibility(lib, Visibility.Collapsed);
                }

                if (poe != null)
                {
                    poe.UniformCornerRadius = 15;
                }
            };
            InitData();
        }

        public async void InitData()
        {
            _lines = await MesQuery.GetAndonLinesString();
            SuggestBox.Suggestions = _lines;
            _timer = new Timer(OnTimerElapsed, state: null, dueTime: 0, period: 5000);
        }

        public async void LoadAndon()
        {
            StaticValues.CurrentShiftSelect();
            if(_selectedLine == null || !_lines.Contains(_selectedLine))
            {
                Dispatcher.Invoke(() => { DefaultView01.Visibility = Visibility.Collapsed; });
                return;
            }
            _and01 = await MesQuery.GetAndonLine(new AndonSearchSettings()
            {
                LineName = _selectedLine,
                StartDate = StaticValues.ShiftStartTime,
                EndDate = StaticValues.ShiftEndTime,
                HourTarget = true,
            });
            Dispatcher.Invoke(() =>
            {
                DefaultView01.DataContext = new FluentViewModel(_and01);
                if(DefaultView01.Visibility == Visibility.Collapsed){DefaultView01.Visibility = Visibility.Visible;}
            });
        }

        private async void OnTimerElapsed(object state) { if(!string.IsNullOrWhiteSpace(_selectedLine))LoadAndon(); }
        
        #region WindowControls
        private void Minimize_Click(object sender, RoutedEventArgs e) { this.WindowState = WindowState.Minimized; }
        private void Maximize_Click(object sender, RoutedEventArgs e) { ToggleWindowState(); }
        private async void Maximize_Hover(object sender, RoutedEventArgs e)
        {
            /*
            await Task.Run(() => { Thread.Sleep(1500); });
            if (!MaximizeBtn.IsMouseOver) return;
            KeyboardSend.KeyDown(Keys.LWin);
            KeyboardSend.KeyDown(Keys.Z);
            KeyboardSend.KeyUp(Keys.LWin);
            KeyboardSend.KeyUp(Keys.Z);
            */
        }
        private void MainWindow_OnMouseDown(object sender, MouseButtonEventArgs e)
        {
            Keyboard.ClearFocus();
        }
        private void Close_Click(object sender, RoutedEventArgs e) { this.Close(); }
        private void ToggleWindowState()
        {
            this.WindowState = this.WindowState == WindowState.Maximized ? WindowState.Normal : WindowState.Maximized;
        }
        
        private CancellationTokenSource _resizeTokenSource;
        private void Window_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            if (this.WindowState == WindowState.Maximized)
            {
                this.BorderThickness = new System.Windows.Thickness(8);
                this.MaximizeBtn.Content = this.FindResource("RestoreIcon");
            }
            else
            {
                this.BorderThickness = new System.Windows.Thickness(0);
                this.MaximizeBtn.Content = this.FindResource("MaximizeIcon");
                this.WindowStyle = WindowStyle.SingleBorderWindow;
                FullScreenButton.IsEnabled = true;
            }
            
            _resizeTokenSource?.Cancel();
            
            _resizeTokenSource = new CancellationTokenSource();
            
            var token = _resizeTokenSource.Token;
            
            Task.Run(() =>
            {
                try
                {
                    Task.Delay(15, token).Wait(token);
                    if (token.IsCancellationRequested) return;
                    Dispatcher.Invoke(() =>
                    {
                        DefaultViewGrid.Width = this.ActualWidth;
                        DefaultViewGrid.Height = this.ActualHeight;
                    });
                }
                catch (OperationCanceledException) { }
            }, token);
            
        }
        
        private void FullScreenButton_OnClick(object sender, RoutedEventArgs e)
        {
            if (this.WindowState == WindowState.Maximized) { this.WindowState = WindowState.Minimized; }
            this.WindowStyle = WindowStyle.None;
            this.WindowState = WindowState.Maximized;
            FullScreenButton.IsEnabled = false;
        }
        
        #endregion
        
        private void SuggestBox_OnMouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            /*Dispatcher.Invoke(() =>
            {
                SuggestBox.IsSuggestionOpen = true;
            });*/
        }

        private void SuggestBox_OnTextChanged(object sender, TextChangedEventArgs e)
        {
            Dispatcher.Invoke(() =>
            {
                var tx = SuggestBox.Text.Replace(" ","_");
                if (string.IsNullOrEmpty(tx)) { SuggestBox.Suggestions = _lines; return; }
                SuggestBox.Suggestions = _lines.ToList().FindAll(s => s.ToUpper().Contains(tx.ToUpper()));
            });
        }

        private void SuggestBox_OnSelectionChanged(object sender, RoutedEventArgs e)
        {
            Dispatcher.Invoke(() =>
            {
                _selectedLine = SuggestBox.Text;
                LoadAndon();
            });

        }

        
    }
}