using System;
using System.Windows.Media;

namespace AndonMonitor.StaticWorkers
{
    public static class StaticValues
    {
        public static Brush GetBr(StaticBr brush)
        {
            switch (brush)
            {
                case StaticBr.Green: return new SolidColorBrush(Color.FromArgb(255,24,221,63));
                case StaticBr.Red: return new SolidColorBrush(Color.FromArgb(255,255,0,26));
                case StaticBr.Blue: return new SolidColorBrush(Color.FromArgb(255,0,118,186));
                case StaticBr.Gray: return new SolidColorBrush(Color.FromArgb(255,128,128,128));
                case StaticBr.Yellow: return new SolidColorBrush(Color.FromArgb(255,255,222,16));
                default: throw new ArgumentOutOfRangeException(nameof(brush), brush, null);
            }
        }
        public static DateTime ShiftStartTime { get; set; }
        public static DateTime ShiftEndTime { get; set; }

        public static void CurrentShiftSelect()
        {
            var now = DateTime.Now;
            var msd = new DateTime(now.Year, now.Month, now.Day, 06, 00, 00);
            var med = new DateTime(now.Year, now.Month, now.Day, 18, 00, 00);
            if (now < msd)
            {
                var nss = now.AddDays(-1);
                ShiftStartTime = new DateTime(nss.Year, nss.Month, nss.Day, 18, 00, 00);
                ShiftEndTime = new DateTime(now.Year, now.Month, now.Day, 05, 59, 59);
                return;
            }

            if (now > med)
            {
                var nse = now.AddDays(1);
                ShiftStartTime = new DateTime(now.Year, now.Month, now.Day, 18, 00, 00);
                ShiftEndTime = new DateTime(nse.Year, nse.Month, nse.Day, 05, 59, 59);
                return;
            }
            ShiftStartTime = new DateTime(now.Year, now.Month, now.Day, 06, 00, 00);
            ShiftEndTime = new DateTime(now.Year, now.Month, now.Day, 17, 59, 59);
        }
    }
    public enum StaticBr { Green, Red, Blue, Gray, Yellow }
}