using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Web.UI.HtmlControls;
using System.Windows.Media;
using AndonMonitor.StaticWorkers;
using MahApps.Metro.Controls;

namespace AndonMonitor.ViewModels
{
    public class DefaultViewModel
    {
        public string Line { get; set; }
        public string Building { get; set; }
        public string Shift { get; set; }
        public string Product { get; set; }
        public string ShiftPlan { get; set; }
        public string ShiftExpect { get; set; }
        public string ShiftActual { get; set; }
        public string ShiftNok { get; set; }
        public string ShiftStatus { get; set; }
        public Brush ShiftBrush { get; set; }
        public Color ShiftBrushToColor => ShiftBrush is SolidColorBrush sbr ? sbr.Color : Colors.Transparent; 
        public string HourPlan { get; set; }
        public string HourExpect { get; set; }
        public string HourActual { get; set; }
        public string HourNok { get; set; }
        public string HourStatus { get; set; }
        public Brush HourBrush { get; set; }
        public Brush HourForeground { get; set; } = new SolidColorBrush(Colors.White);
        
        public List<DefaultViewModelHour> Targets { get; set; }
        public List<DefaultViewModelStation> Stations { get; set; }

        public DefaultViewModel(AnalyseToolExtension.DataObjects.Andon andon)
        {
            var shiftPlan = 0;
            var shiftExpect = 0;
            var shiftActual = 0;
            var shiftNok = 0;
            var shiftStatus = 0;
            
            var hourPlan = 0;
            var hourExpect = 0;
            var hourActual = 0;
            var hourNok = 0;
            var hourStatus = 0;
            
            HourForeground = new SolidColorBrush(Colors.White);
            
            #region LineHeaders
            
            Line = andon.Definition.Name;
            Building = andon.Definition.Building;
            var mat = andon.Definition.ProductIn;
            if (andon.Definition.ProductIn != andon.Definition.ProductOut) mat = string.Join(",", andon.Definition.ProductIn, andon.Definition.ProductOut);
            Product = mat;
            
            #endregion
            #region HourTargets

            Targets = andon.Targets.Select(tg =>
            {
                var hrm = new DefaultViewModelHour();
                var hc = tg.Hour?.Hour ?? 0;
                var hp = tg.Hour.HasValue ? tg.Hour.Value.Hour + 1 : 0;
                hrm.HourString = $"{hc:00}-{hp:00}";
                hrm.YieldString = tg.YieldQty.ToString();
                var maxDiv = Math.Ceiling((double)tg.Target * 0.1);
                if (tg.YieldQty >= tg.Target - maxDiv)
                {
                    hrm.Color = StaticValues.GetBr(StaticBr.Yellow);
                    hrm.Foreground = new SolidColorBrush(Colors.Black);
                }
                else { hrm.Color = StaticValues.GetBr(StaticBr.Red); }
                if (tg.YieldQty >= tg.Target) { hrm.Color = StaticValues.GetBr(StaticBr.Green); hrm.Foreground = new SolidColorBrush(Colors.Black);}
                if (tg.Target == 0){ hrm.Color = StaticValues.GetBr(StaticBr.Blue); hrm.Foreground = new SolidColorBrush(Colors.White);}
                if (DateTime.Now < tg.Hour) { hrm.Color = StaticValues.GetBr(StaticBr.Gray); hrm.Foreground = new SolidColorBrush(Colors.White);}

                if (DateTime.Now.Year == tg.Hour?.Year && DateTime.Now.Month == tg.Hour?.Month &&
                    DateTime.Now.Day == tg.Hour?.Day && DateTime.Now.Hour == tg.Hour?.Hour)
                {
                    hrm.IsCurrent = true;  
                    hrm.Color = new SolidColorBrush(Colors.Transparent);
                    hrm.Foreground = new SolidColorBrush(Colors.White);
                    hourActual = tg.YieldQty;
                    hourPlan = tg.Target;
                }

                hrm.Target = tg.Target.ToString();
                return hrm;
            }).ToList();

            #endregion
            #region ShiftValues
            
            shiftPlan = andon.Targets.Sum(tg=> tg.Target);
            shiftActual = andon.Targets.Sum(tg => tg.YieldQty);
            var dtn = DateTime.Now;
            const int wds = 43200;
            var ess = (double)(dtn - StaticValues.ShiftStartTime).TotalSeconds;
            if (ess < 0 || ess > wds)
            {
                if (ess < 0) { shiftExpect = 0; }
                if (ess > wds) { shiftExpect = shiftPlan; }
            }
            else
            {
                shiftExpect = int.Parse($"{Math.Floor(((double)shiftPlan / wds)*ess):0000}");
            }
            shiftStatus = shiftActual - shiftExpect;
            
            ShiftPlan = shiftPlan.ToString();
            ShiftExpect = shiftExpect.ToString();
            ShiftActual = shiftActual.ToString();
            ShiftNok = shiftNok.ToString();
            ShiftStatus = shiftStatus > 0 ? $"+{shiftStatus}" : $"{shiftStatus}";

            var shiftDiv = Math.Ceiling((double)shiftExpect * 0.1);
            ShiftBrush = shiftActual >= shiftExpect - shiftDiv ? shiftStatus >= 0 ? StaticValues.GetBr(StaticBr.Green) : StaticValues.GetBr(StaticBr.Yellow) : StaticValues.GetBr(StaticBr.Red) ;

            #endregion
            #region HourValues

            const int whs = 3600;
            var ehs = (double)(dtn - new DateTime(dtn.Year, dtn.Month, dtn.Day,dtn.Hour,0,0)).TotalSeconds;
            if (ehs < 0 || ehs > whs)
            {
                if (ehs < 0) { hourExpect = 0; }
                if (ehs > whs) { hourExpect = hourPlan; }
            }
            else
            {
                hourExpect = int.Parse($"{Math.Floor(((double)hourPlan / whs)*ehs):0000}");
            }
            hourStatus = hourActual - hourExpect;
            
            HourActual = hourActual.ToString();
            HourPlan = hourPlan.ToString();
            HourExpect = hourExpect.ToString();
            HourNok = hourNok.ToString();
            HourStatus = hourStatus > 0 ? $"+{hourStatus}" : $"{hourStatus}";

            var hourDiv = Math.Ceiling((double)hourExpect * 0.1);
            if (hourActual >= hourExpect - hourDiv)
            {
                HourBrush = StaticValues.GetBr(hourStatus >= 0 ? StaticBr.Green : StaticBr.Yellow);
                HourForeground = new SolidColorBrush(Colors.Black);
            }
            else { HourBrush = StaticValues.GetBr(StaticBr.Red); }
            if (hourPlan == 0){HourBrush = StaticValues.GetBr(StaticBr.Blue); HourForeground = new SolidColorBrush(Colors.White);}
            
            #endregion

            #region Stations

            

            #endregion

            //ShiftBrush = andon.ShiftStatus >= 0 ? green : andon.ShiftStatus < -2 ? red : yellow;
            //if (andon.ShiftPlan == 0) ShiftBrush = blue;
            //Stations = new List<DefaultViewModelStation>();
            /*foreach (var s in andon.Stations)
            {
                var tip = s.LastUsed - DateTime.Now;

                var rts = string.Empty;
                if (Math.Abs(tip.TotalSeconds) > s.Escalation)
                {
                    rts = $"{tip.Seconds}sec";
                    if (tip.Minutes <= -1) { rts = $"{tip.Minutes}m {tip.Seconds}sec"; }
                    if (tip.Hours <= -1) { rts = $"{tip.Hours}h {tip.Minutes}m"; }
                    if (tip.Days <= -1) { rts = $"{tip.Days}d {tip.Hours}h"; }
                    if (tip.Days <= -365) { rts = $"{tip.Days}d"; }
                }
                var sbr = Math.Abs(tip.TotalSeconds) > s.Escalation ? red : green;
                Stations.Add(new DefaultViewModelStation()
                {
                    Name = s.VisualName,
                    Operator = s.Operator,
                    TimeLeft = rts,
                    StatusColor = sbr,
                    IsLocked = s.IsLocked,
                    Selected = s.IsLast
                });
            }*/
        }
    }

    public class DefaultViewModelHour
    {
        public string HourString { get; set; }
        public string YieldString { get; set; }
        public Brush Color { get; set; }
        public Color ColorToColor => Color is SolidColorBrush br ? br.Color : Colors.Transparent;
        public Brush Foreground { get; set; } = new SolidColorBrush(Colors.White);
        public bool IsCurrent { get; set; }
        public string Target { get; set; }
    }

    public class DefaultViewModelStation
    {
        public string Name { get; set; }
        public string Operator { get; set; }
        public string TimeLeft { get; set; }
        public bool? IsLocked { get; set; }
        public bool? Selected { get; set; }
        public Brush StatusColor { get; set; }
    }
}