using System;
using System.Collections.Generic;
using AnalyseToolPluginContracts;

namespace AtTestPlugin
{
    public class TestPlugin : IAnalyseToolPlugin
    {
        public string Name => "TestPlugin";
        public string Description => "TestPlugin";
        public string Author => "";
        public string Contact => "";
        public Uri IconUri => null;
        public string VersionApply => null;

        public IEnumerable<IAnalyseToolPluginContent> Contents => new IAnalyseToolPluginContent[]
        {
            new PageData()
            {
                Name = "TestPluginPage",
                IsExtendedPage = false,
                IsOverlay = false,
                PageContent = new TestPage(),
                MenuItem = new MenuItemData(0)
                {
                    MenuItemText = "Icon.Search",
                    MenuItemToolTip = "Test Plugin Page"
                }
            }
        };
        public IEnumerable<IAnalyseToolPluginOption> Options { get; set; }
    }
}