using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Windows.Forms;
using System.Windows.Forms.VisualStyles;
using Oracle.ManagedDataAccess.Client;

namespace ContiCom.Workers
{
    public static class ContinentalDataBase
    {
        private static OracleConnection OraConnection { get; set; }
        public static void Connect(string customConnectionString = null)
        {
            string cs;
            if(OraConnection != null){OraConnection.Close(); OraConnection.Dispose();}
            OraConnection = null;
            if (string.IsNullOrEmpty(customConnectionString))
            { cs = "User Id=mesread;Password=mesread;Data Source=budbmes2.auto.contiwan.com:1521/REPORTING.auto.contiwan.com";}
            else { cs = customConnectionString; }

            OraConnection = new OracleConnection(cs);

            try
            {
                OraConnection.SqlNetAllowedLogonVersionClient = (OracleAllowedLogonVersionClient)5;
                OraConnection.SqlNetAllowedLogonVersionClient = (OracleAllowedLogonVersionClient)3;
                OraConnection.Open();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message, ex);
            }
        }
        public static void Dispose()
        {
            OraConnection.Close();
            OraConnection.Dispose();
        }
        
        public static void GetData(string command, out DataTable data)
        {
            using (var cmd = OraConnection.CreateCommand())
            {
                try
                {
                    cmd.CommandText = command;
                    cmd.CommandType = CommandType.Text;
                    var reader = cmd.ExecuteReader();
                    var dt = new DataTable();
                    var fc = reader.FieldCount;
                    for (var i = 0; i < fc; i++) { dt.Columns.Add(reader.GetColumnSchema()[i].ColumnName); }

                    while (reader.Read())
                    {
                        var obs = new List<object>();
                        for (var i = 0; i < fc; i++) { obs.Add(reader.GetString(i)); }
                        dt.Rows.Add(obs);
                    }
                    
                    reader.Close();

                    data = dt;
                }
                catch (Exception ex)
                {
                    data = null;
                    throw new Exception(ex.Message, ex);
                }
            }
        }
        public static void GetUnit(string unitId, out UnitData unitData)
        {
            try
            {
                var ud = new UnitData() { UnitId = unitId };
                    
                #region EVA
                GetEva(unitId, out var eva);
                ud.EvaInfo = eva;
                #endregion

                #region WIP
                GetWip(unitId, out var wip);
                ud.WipInfo = wip;
                #endregion

                #region PreId
                GetPreUnitId(unitId, out var preId);
                ud.PreUnitId = preId;
                #endregion
                    
                #region NextId
                GetNextUnitId(unitId, out var nxtId);
                ud.NextUnitId = nxtId;
                #endregion
                    
                #region Material description
                if (ud.WipInfo.Count > 0)
                {
                    if (!string.IsNullOrEmpty(ud.WipInfo[0].ProductDescription))
                    {
                        GetMaterialName(ud.WipInfo[0].ProductDescription,out var matName);
                        ud.Description = matName;
                        ud.Material = ud.WipInfo[0].ProductDescription;
                        ud.UnitIdType = ud.WipInfo[0].UnitIdType;
                        ud.WipMama = UnitStatus.Wip;
                        ud.Order = ud.WipInfo[0].Order;
                        ud.OrderTerminated = ud.WipInfo[0].OrderTerminated;
                    }
                }
                #endregion

                #region Mama check
                GetMama(unitId,out var mama);

                if (!string.IsNullOrEmpty(mama.PartId))
                {
                    if (mama.PartNumber == ud.Material) { ud.WipMama = UnitStatus.Mama; }
                    else
                    {
                        ud.WipMama = UnitStatus.WipMama;
                        ud.Material = $"(MAMA) {mama.PartNumber}, (WIP) {ud.Material}";
                        ud.UnitIdType = $"(MAMA) {mama.PartIdType}, (WIP) {ud.UnitIdType}";
                    }
                }
                #endregion
                    
                #region Carrier
                GetCarrier(unitId, out var carma);
                ud.CarrierId = carma.Id;
                #endregion
                
                #region BuildIn
                GetBuildIn(unitId,out var buildIn);
                ud.BuildIn = buildIn;
                #endregion
                    
                unitData = ud;
            }
            catch (Exception ex)
            {
                unitData = null;
                throw new Exception(ex.Message, ex);
            }
        }
        public static void GetEva(string unitId, out List<EvaInfo> evaInfo)
        {
            var rtn = new List<EvaInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                        "SELECT plr.RUN_DATE, plr.RUNID_TYPE, mat.pdk_material AS Material_Number, plr.RUN_STATE, psp.PRP_VAR AS TestplanName, psp.PRP_VER, bmn.bmt_name AS Station, plr.run_key_prt, plr.run_seq_key " +
                        "FROM evaprod.pd_lfd_run plr " +
                        "JOIN evaprod.pd_stm_prp psp ON plr.prp_date_id = psp.prp_date_id "+
                        "JOIN evaprod.pd_lfd_mat mat ON plr.prd_mat_sid = mat.prd_mat_sid "+
                        "JOIN evaprod.pd_lfd_bmn bmn ON plr.bmt_dat_id = bmn.bmt_dat_id "+
                        $"WHERE plr.runid = '{unitId}' "+
                        "ORDER BY run_date DESC";
                cmd.CommandType = CommandType.Text;
                var evaReader = cmd.ExecuteReader();
                while (evaReader.Read())
                {
                    var typ = evaReader.IsDBNull(1) ? null : evaReader.GetString(1);
                    var res = evaReader.IsDBNull(3) ? null : evaReader.GetString(3);
                    var dte = evaReader.IsDBNull(0) ? new DateTime() : evaReader.GetDateTime(0);
                    var mat = evaReader.IsDBNull(2) ? null : evaReader.GetString(2);
                    var stn = evaReader.IsDBNull(6) ? null : evaReader.GetString(6);
                    var tpn = evaReader.IsDBNull(4) ? null : evaReader.GetString(4);
                    var tpv = evaReader.IsDBNull(5) ? null : evaReader.GetString(5);
                    var key = evaReader.IsDBNull(7) ? null : evaReader.GetString(7);
                    var seq = evaReader.IsDBNull(8) ? null : evaReader.GetString(8);
                    rtn.Add(new EvaInfo()
                    {
                        DateTime = dte,
                        KeyPrt = key,
                        SeqKey = seq,
                        Material = mat,
                        Result = Converters.StringToUnitState(res),
                        UnitIdType = typ,
                        Station = stn,
                        TestPlanName = tpn,
                        TestPlanVersion = tpv
                    });
                }
                evaReader.Close();
            }
            evaInfo = rtn;
        }
        public static void GetEvaTestRun(string unitId,string key, string seq, out List<EvaTestInfo> evaTestInfo)
        {
            var rtn = new List<EvaTestInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                        "SELECT mrk.mrk_reihe, mrk.mrk_num, mrk.mrk_num_lng, med2.mrk_sub_num, mrk.mrk_bez, med2.mrk_wert, med2.mrk_ein_gut, mrk.mrk_usg, mrk.mrk_osg, mrk.mrk_einheit, mrk.mrk_datentyp, aslp.aslp_kom, mxt2.mrk_txt " +
                        "FROM evaprod.pd_lfd_run plr, evaprod.pd_stm_prp prp, evaprod.pd_stm_mrk mrk, evaprod.pd_lfd_med2 med2, evaprod.pd_lfd_mxt2 mxt2, pd_stm_aslp aslp " +
                        $"WHERE plr.runid = '{unitId}' AND plr.run_key_prt = '{key}' AND  plr.run_key_prt = med2.run_key_prt AND plr.run_seq_key = '{seq}' AND  plr.run_seq_key = med2.run_seq_key AND plr.prp_date_id = prp.prp_date_id AND plr.prp_date_id = mrk.prp_date_id AND mrk.mrk_num = med2.mrk_num AND plr.run_key_prt = mxt2.run_key_prt(+) AND  plr.run_seq_key = mxt2.run_seq_key(+) AND  med2.mrk_num = mxt2.mrk_num(+) AND mrk.asl_date_id = aslp.asl_date_id(+) AND  med2.mrk_wert = aslp.aslp_num(+) " +
                        "ORDER BY med2.mrk_ein_gut, mrk.mrk_reihe, med2.mrk_sub_num";
                cmd.CommandType = CommandType.Text;
                var evaTrReader = cmd.ExecuteReader();
                while (evaTrReader.Read())
                {
                    rtn.Add(new EvaTestInfo()
                    {
                        Sequence = evaTrReader.IsDBNull(0) ? null : evaTrReader.GetString(0),
                        SubSequence = evaTrReader.IsDBNull(2) ? null : evaTrReader.GetString(2),
                        Id = evaTrReader.IsDBNull(1) ? null : evaTrReader.GetString(1).Contains("#") ? evaTrReader.IsDBNull(2) ? null : evaTrReader.GetString(2) : evaTrReader.GetString(1),
                        Description = evaTrReader.IsDBNull(4) ? null : evaTrReader.GetString(4),
                        Value = evaTrReader.IsDBNull(5) ? 0F : evaTrReader.GetFloat(5),
                        Result = evaTrReader.IsDBNull(6) ? UnitState.None : Converters.StringToUnitState(evaTrReader.GetString(6)),
                        MinValue = evaTrReader.IsDBNull(7) ? 0F : evaTrReader.GetFloat(7),
                        MaxValue = evaTrReader.IsDBNull(8) ? 0F : evaTrReader.GetFloat(8),
                        ValueType = evaTrReader.IsDBNull(9) ? null : evaTrReader.GetString(9)
                    });
                }
                evaTrReader.Close();
            }
            evaTestInfo = rtn;
        }
        public static void GetWip(string unitId, out List<WipInfo> wipInfo)
        {
            var rtn = new List<WipInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                        "SELECT wip.job AS Order_info, wip.unit_id_in, wip.unit_id_in_type, wip.updated, wip.equipment, wip.sub_device, wip.qty_checkin, wip.qty_fail, wip.qty_yield, wip.qty_loss, wip.lock_descript, wipproc.description_short, wiplock.user_comment, wipjob.product_definition, wipjob.terminated, wipjob.lock_descript " +
                        "FROM wip.t_wip_subset wip " +
                        "JOIN wip.t_wip_process_step wipProc ON wip.process_step = wipProc.process_step AND wip.process_step_id = wipProc.process_step_id AND wip.job = wipProc.job "+
                        "JOIN wip.t_wip_job wipJob ON wip.job = wipJob.job "+
                        "LEFT JOIN wip.t_wip_lock wiplock ON wip.lock_descript = wiplock.lock_descript "+
                        $"WHERE wip.unit_id_in = '{unitId}' "+
                        "ORDER BY wip.updated DESC";
                cmd.CommandType = CommandType.Text;
                var wipReader = cmd.ExecuteReader();
                while (wipReader.Read())
                {
                    var ord = wipReader.IsDBNull(0) ? null : wipReader.GetString(0);
                    var uid = wipReader.IsDBNull(1) ? null : wipReader.GetString(1);
                    var uit = wipReader.IsDBNull(2) ? null : wipReader.GetString(2);
                    var dte = wipReader.IsDBNull(3) ? new DateTime() : wipReader.GetDateTime(3);;
                    var eqm = wipReader.IsDBNull(4) ? null : wipReader.GetString(4);
                    var stn = wipReader.IsDBNull(5) ? null : wipReader.GetString(5);
                    var res1 = wipReader.IsDBNull(6) ? null : wipReader.GetString(6);
                    var res2 = wipReader.IsDBNull(7) ? null : wipReader.GetString(7);
                    var res3 = wipReader.IsDBNull(8) ? null : wipReader.GetString(8);
                    var res4 = wipReader.IsDBNull(9) ? null : wipReader.GetString(9);
                    var lid = wipReader.IsDBNull(10) ? null : wipReader.GetString(10);
                    var sdc = wipReader.IsDBNull(11) ? null : wipReader.GetString(11);
                    var lcm = wipReader.IsDBNull(12) ? null : wipReader.GetString(12);
                    var opd = wipReader.IsDBNull(13) ? null : wipReader.GetString(13);
                    var otr = wipReader.IsDBNull(14) ? null : wipReader.GetString(14);
                    var oli = wipReader.IsDBNull(15) ? null : wipReader.GetString(15);
                    rtn.Add(new WipInfo()
                    {
                        Order = ord,
                        UnitId = uid,
                        UnitIdType = uit,
                        Updated = dte,
                        Equipment = eqm,
                        Station = stn,
                        Result = Converters.ResArrayToUnitState(res1,res2,res3,res4),
                        LockId = lid,
                        StationDescription = sdc,
                        LockComment = lcm,
                        ProductDescription = opd,
                        OrderTerminated = !string.IsNullOrEmpty(otr),
                        OrderLockComment = oli
                    });
                }
                wipReader.Close();
            }
            wipInfo = rtn;
        }
        public static void GetPreUnitId(string unitId, out string preUnitId)
        {
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wipLog.unit_id_in, wipLog.created " +
                    "FROM wip.t_wip_subset_log wipLog " +
                    $"WHERE wipLog.unit_id_out = '{unitId}' AND wipLog.transaction_type = 'unit_change'"+
                    "ORDER BY wipLog.created";
                cmd.CommandType = CommandType.Text;
                var preIdReader = cmd.ExecuteReader();
                if (preIdReader.Read())
                {
                    rtn = preIdReader.IsDBNull(0) ? null : preIdReader.GetString(0);
                }
                preIdReader.Close();
            }
            preUnitId = rtn;
        }
        public static void GetNextUnitId(string unitId, out string nextUnitId)
        {
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT wipLog.unit_id_out, wipLog.created " +
                    "FROM wip.t_wip_subset_log wipLog " +
                    $"WHERE wipLog.unit_id_in = '{unitId}' AND wipLog.transaction_type = 'unit_change'"+
                    "ORDER BY wipLog.created";
                cmd.CommandType = CommandType.Text;
                var nextIdReader = cmd.ExecuteReader();
                if (nextIdReader.Read())
                {
                    rtn = nextIdReader.IsDBNull(0) ? null : nextIdReader.GetString(0);
                }
                nextIdReader.Close();
            }
            nextUnitId = rtn;
        }
        public static void GetMama(string unitId, out MamaInfo mamaInfo)
        {
            var rtn = new MamaInfo();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT matCont.part_id, matCont.part_id_type, matDef.part_number, matCont.lock_descript, matCont.user_comment " +
                    "FROM mama.t_mat_container matCont " +
                    "JOIN mama.t_mat_def matDef ON matCont.mat_def_id = matDef.mat_def_id " +
                    $"WHERE matCont.part_id = '{unitId}' ";
                cmd.CommandType = CommandType.Text;
                var mamaReader = cmd.ExecuteReader();
                if (mamaReader.Read())
                {
                    rtn.PartId = mamaReader.IsDBNull(0) ? null : mamaReader.GetString(0);
                    rtn.PartNumber = mamaReader.IsDBNull(2) ? null : mamaReader.GetString(2);
                    rtn.PartIdType = mamaReader.IsDBNull(1) ? null : mamaReader.GetString(1);
                    rtn.LockId = mamaReader.IsDBNull(3) ? null : mamaReader.GetString(3);
                    rtn.UserComment = mamaReader.IsDBNull(4) ? null : mamaReader.GetString(4);
                }
                mamaReader.Close();
            }
            mamaInfo = rtn;
        }
        public static void GetCarrier(string unitId, out CarrierInfo carrierInfo)
        {
            var rtn = new CarrierInfo();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText = "SELECT car.subunit_id, car.car_id, car.car_id_type, car.created, car.updated " +
                                  "FROM carma.t_car_subunit car " +
                                  $"WHERE car.subunit_id= '{unitId}' " +
                                  "ORDER BY created";
                cmd.CommandType = CommandType.Text;
                var carmaReader = cmd.ExecuteReader();
                if (carmaReader.Read())
                {
                    rtn.Id = carmaReader.IsDBNull(1) ? null : carmaReader.GetString(1);
                    rtn.IdType = carmaReader.IsDBNull(2) ? null : carmaReader.GetString(2);
                    rtn.Created = carmaReader.IsDBNull(3) ? new DateTime() : carmaReader.GetDateTime(3);
                    rtn.Updated = carmaReader.IsDBNull(4) ? new DateTime() : carmaReader.GetDateTime(4);
                }
                carmaReader.Close();

                if (string.IsNullOrEmpty(rtn.Id))
                {
                    cmd.CommandText = "SELECT car_id, car_id_type, pos_id, car_type, subunit_id_type, created, updated, deleted " +
                                      "FROM t_car_subunit_log " +
                                      $"WHERE subunit_id = '{unitId}' AND transaction_type = 'Delete_Subunit' " +
                                      "ORDER BY deleted DESC ";
                    cmd.CommandType = CommandType.Text;
                    carmaReader = cmd.ExecuteReader();
                    if (carmaReader.Read())
                    {
                        rtn.Id = carmaReader.IsDBNull(0) ? null : carmaReader.GetString(0);
                        rtn.IdType = carmaReader.IsDBNull(1) ? null : carmaReader.GetString(1);
                        rtn.Created = carmaReader.IsDBNull(5) ? new DateTime() : carmaReader.GetDateTime(5);
                        rtn.Updated = carmaReader.IsDBNull(6) ? new DateTime() : carmaReader.GetDateTime(6);
                        rtn.Deleted = !carmaReader.IsDBNull(7);
                    }
                    carmaReader.Close();
                    if (!string.IsNullOrEmpty(rtn.Id))
                    {
                        cmd.CommandText = "SELECT carHis.car_id, carHis.car_id_type, carHis.subunit_id, carHis.pos_id, carHis.created, carHis.updated " +
                                          "FROM carma.t_car_subunit_log carHis " +
                                          $"WHERE carHis.car_id= '{rtn.Id}' AND transaction_type = 'Create_Subunit' " +
                                          "ORDER BY pos_id";
                        cmd.CommandType = CommandType.Text;
                        carmaReader = cmd.ExecuteReader();
                        while (carmaReader.Read())
                        {
                            rtn.SubUnitInfo.Add(new CarrierSubUnitInfo()
                            {
                                Id = carmaReader.IsDBNull(0) ? null : carmaReader.GetString(0),
                                IdType = carmaReader.IsDBNull(1) ? null : carmaReader.GetString(1),
                                Created = carmaReader.IsDBNull(4) ? new DateTime() : carmaReader.GetDateTime(4),
                                Updated = carmaReader.IsDBNull(5) ? new DateTime() : carmaReader.GetDateTime(5),
                                SubUnitId = carmaReader.IsDBNull(2) ? null : carmaReader.GetString(2),
                                Position = carmaReader.IsDBNull(3) ? null : carmaReader.GetString(3)
                            });
                        }
                        carmaReader.Close();
                    }
                }
                else
                {
                    cmd.CommandText = "SELECT car.car_id, car.car_id_type, car.subunit_id, car.pos_id, car.created, car.updated " +
                                      "FROM carma.t_car_subunit car " +
                                      $"WHERE car.car_id= '{rtn.Id}' " +
                                      "ORDER BY subunit_id";
                    cmd.CommandType = CommandType.Text;
                    carmaReader = cmd.ExecuteReader();
                    while (carmaReader.Read())
                    {
                        rtn.SubUnitInfo.Add(new CarrierSubUnitInfo()
                        {
                            Id = carmaReader.IsDBNull(0) ? null : carmaReader.GetString(0),
                            IdType = carmaReader.IsDBNull(1) ? null : carmaReader.GetString(1),
                            Created = carmaReader.IsDBNull(4) ? new DateTime() : carmaReader.GetDateTime(4),
                            Updated = carmaReader.IsDBNull(5) ? new DateTime() : carmaReader.GetDateTime(5),
                            SubUnitId = carmaReader.IsDBNull(2) ? null : carmaReader.GetString(2),
                            Position = carmaReader.IsDBNull(3) ? null : carmaReader.GetString(3)
                        });
                    }
                    carmaReader.Close();
                }
            }
            carrierInfo = rtn;
        }

        public static void GetAllCarrier(string unitId, out List<CarrierInfo> carriers)
        {
            var rtn = new List<CarrierInfo>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT car_id, car_id_type, pos_id, car_type, subunit_id_type, created, updated, deleted " +
                    "FROM t_car_subunit_log " +
                    $"WHERE subunit_id = '{unitId}' AND transaction_type='Create_Subunit' " +
                    "ORDER BY created ";
                cmd.CommandType = CommandType.Text;
                var carmaReader = cmd.ExecuteReader();
                while (carmaReader.Read())
                {
                    rtn.Add(new CarrierInfo()
                    {
                        Id = carmaReader.IsDBNull(0) ? null : carmaReader.GetString(0),
                        IdType = carmaReader.IsDBNull(1) ? null : carmaReader.GetString(1),
                        CarrierType = carmaReader.IsDBNull(3) ? null : carmaReader.GetString(3),
                        Created = carmaReader.IsDBNull(5) ? new DateTime() : carmaReader.GetDateTime(5),
                        Updated = carmaReader.IsDBNull(6) ? new DateTime() : carmaReader.GetDateTime(6),
                        Deleted = !carmaReader.IsDBNull(7)
                    });
                }

                carmaReader.Close();

                if (rtn.Count > 0)
                {
                    rtn.ForEach(ci =>
                    {
                        cmd.CommandText = "SELECT car.car_id, car.car_id_type, car.subunit_id, car.pos_id, car.created, car.updated " +
                                          "FROM carma.t_car_subunit_log car " +
                                          $"WHERE car.car_id= '{ci.Id}' AND car.transaction_type='Create_Subunit' " +
                                          "ORDER BY pos_id";
                        cmd.CommandType = CommandType.Text;
                        carmaReader = cmd.ExecuteReader();
                        while (carmaReader != null && carmaReader.Read())
                        {
                            var pos = !carmaReader.IsDBNull(3) ? carmaReader?.GetString(3) : null;
                            if (string.IsNullOrEmpty(pos)) continue;
                            if (pos.Contains("S")) continue;
                            ci.SubUnitInfo.Add(new CarrierSubUnitInfo()
                            {
                                Id = carmaReader.IsDBNull(0) ? null : carmaReader.GetString(0),
                                IdType = carmaReader.IsDBNull(1) ? null : carmaReader.GetString(1),
                                Created = carmaReader.IsDBNull(4) ? new DateTime() : carmaReader.GetDateTime(4),
                                Updated = carmaReader.IsDBNull(5) ? new DateTime() : carmaReader.GetDateTime(5),
                                SubUnitId = carmaReader.IsDBNull(2) ? null : carmaReader.GetString(2),
                                Position = carmaReader.IsDBNull(3) ? null : carmaReader.GetString(3)
                            });
                        }

                        carmaReader?.Close();
                    });
                }
            }

            carriers = rtn;
        }
        public static void GetMaterialName(string material, out string materialName)
        {
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT matDef.part_number, matDef.part_name " +
                    "FROM mama.t_mat_def matDef " +
                    $"WHERE matDef.part_number = '{material}' ";
                cmd.CommandType = CommandType.Text;
                var matReader = cmd.ExecuteReader();
                if (matReader.Read())
                {
                    rtn = matReader.IsDBNull(1) ? null : matReader.GetString(1);
                }
                matReader.Close();
            }
            materialName = rtn;
        }
        public static void GetEvaTestRunTextInfo(string unitId,string key, string seq, out string textInfo)
        {
            var rtn = string.Empty;
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT ted2.txt_info " +
                    "FROM evaprod.pd_lfd_run plr " +
                    "JOIN evaprod.pd_lfd_ted2 ted2 ON plr.run_key_prt = ted2.run_key_prt AND plr.run_seq_key = ted2.run_seq_key " +
                    $"WHERE plr.runid = '{unitId}' AND plr.run_key_prt = '{key}' AND plr.run_seq_key = '{seq}'";
                cmd.CommandType = CommandType.Text;
                var tiReader = cmd.ExecuteReader();
                if (tiReader.Read())
                {
                    rtn = tiReader.IsDBNull(0) ? null : tiReader.GetString(0);
                }
                tiReader.Close();
            }
            textInfo = rtn;
        }
        public static void GetBuildIn(string unitId, out List<BuildIn> buildIn)
        {
            var rtn = new List<BuildIn>();
            using (var cmd = OraConnection.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT WIP.UNIT_ID_IN, WIP.UNIT_ID_IN_TYPE, WIP.created, partList.removed " +
                    "FROM WIP.t_wip_subset WIP " +
                    "JOIN WIP.t_wip_partslist partList ON partList.subset_id_l = WIP.subset_id_l " +
                    $"WHERE partList.PART_ID = '{unitId}' AND wip.job = partList.job " +
                    "ORDER BY wip.created";
                cmd.CommandType = CommandType.Text;
                var buildReader = cmd.ExecuteReader();
                while (buildReader.Read())
                {
                    rtn.Add(new BuildIn()
                    {
                        IsPart = false,
                        UnitId = buildReader.IsDBNull(0) ? null : buildReader.GetString(0),
                        UnitIdType = buildReader.IsDBNull(1) ? null : buildReader.GetString(1),
                        Created = buildReader.IsDBNull(2) ? new DateTime() : buildReader.GetDateTime(2),
                        Removed = buildReader.IsDBNull(3) ? new DateTime() : buildReader.GetDateTime(3)
                    });
                }
                buildReader.Close();
                
                cmd.CommandText =
                    "SELECT partList.part_id, partList.part_id_type, partList.created, partList.removed " +
                    "FROM wip.t_wip_partslist partList " +
                    "JOIN wip.t_wip_subset wip ON partList.subset_id_l = wip.subset_id_l " +
                    $"WHERE wip.unit_id_in = '{unitId}' AND wip.job = partList.job " +
                    "ORDER BY partList.created";
                cmd.CommandType = CommandType.Text;
                buildReader = cmd.ExecuteReader();
                while (buildReader.Read())
                {
                    rtn.Add(new BuildIn()
                    {
                        IsPart = true,
                        UnitId = buildReader.IsDBNull(0) ? null : buildReader.GetString(0),
                        UnitIdType = buildReader.IsDBNull(1) ? null : buildReader.GetString(1),
                        Created = buildReader.IsDBNull(2) ? new DateTime() : buildReader.GetDateTime(2),
                        Removed = buildReader.IsDBNull(3) ? new DateTime() : buildReader.GetDateTime(3)
                    });
                }
                buildReader.Close();
            }

            buildIn = rtn;
        }
    }
}