using System;
using System.Collections.Generic;

namespace ContiCom.Workers
{
    public class UnitData
    {
        public string UnitId { get; set; } = "";
        public string PreUnitId { get; set; } = "";
        public string NextUnitId { get; set; } = "";
        public string UnitIdType { get; set; } = "";
        public string Material { get; set; } = "";
        public string Description { get; set; } = "";
        public string CarrierId { get; set; } = "";
        public string Order { get; set; } = "";
        public bool OrderTerminated { get; set; } = false;
        public UnitStatus WipMama { get; set; } = UnitStatus.None;
        public string LockText { get; set; } = "";
        public bool Lock { get; set; } = false;
        public List<WipInfo> WipInfo { get; set; } = new List<WipInfo>();
        public List<EvaInfo> EvaInfo { get; set; } = new List<EvaInfo>();
        public List<BuildIn> BuildIn { get; set; } = new List<BuildIn>();
    }

    #region Wip
    public class WipInfo
    {
        public string Order { get; set; } = "";
        public string UnitId { get; set; } = "";
        public string UnitIdType { get; set; } = "";
        public DateTime Updated { get; set; }
        public string Equipment { get; set; } = "";
        public string Station { get; set; } = "";
        public UnitState Result { get; set; } = UnitState.None;
        public string LockId { get; set; } = "";
        public string LockComment { get; set; } = "";
        public string StationDescription { get; set; } = "";
        public string ProductDescription { get; set; } = "";
        public bool OrderTerminated { get; set; } = false;
        public string OrderLockComment { get; set; } = "";
    }
    #endregion

    #region Eva
    public class EvaInfo
    {
        public string UnitId { get; set; } = "";
        public string UnitIdType { get; set; } = "";
        public string Material { get; set; } = "";
        public string TestPlanVersion { get; set; } = "";
        public string TestPlanName { get; set; } = "";
        public string Station { get; set; } = "";
        public UnitState Result { get; set; } = UnitState.None;
        public DateTime DateTime { get; set; }

        public string TextInfo { get; set; } = "";
        
        public string KeyPrt { get; set; } = "";
        public string SeqKey { get; set; } = "";
    }
    public class EvaTestInfo
    {
        public string Sequence { get; set; } = "";
        public string SubSequence { get; set; } = "";
        public string Id { get; set; } = "";
        public string Description { get; set; } = "";
        public float Value { get; set; } = 0F;
        public float MinValue { get; set; } = 0F;
        public float MaxValue { get; set; } = 0F;
        public UnitState Result { get; set; } = UnitState.None;
        public string ValueType { get; set; } = "";
    }
    #endregion
    
    #region MAMA
    public class MamaInfo
    {
        public string PartId { get; set; } = "";
        public string PartIdType { get; set; } = "";
        public string PartNumber { get; set; } = "";
        public string LockId { get; set; } = "";
        public string UserComment { get; set; } = "";
    }
    #endregion

    #region Carma

    public class CarrierInfo
    {
        public string Id { get; set; } = "";
        public string IdType { get; set; } = "";

        public string CarrierType { get; set; } = "";
        public DateTime Created { get; set; }
        public DateTime Updated { get; set; }
        public List<CarrierSubUnitInfo> SubUnitInfo { get; set; } = new List<CarrierSubUnitInfo>();
        public bool Deleted { get; set; } = false;
    }

    public class CarrierSubUnitInfo
    {
        public string Id { get; set; } = "";
        public string IdType { get; set; } = "";
        public string SubUnitId { get; set; } = "";
        public string Position { get; set; } = "";
        public DateTime Created { get; set; }
        public DateTime Updated { get; set; }
    }

    #endregion

    #region BuildIn

    public class BuildIn
    {
        public bool IsPart { get; set; } = false;
        public string UnitId { get; set; } = "";
        public string UnitIdType { get; set; } = "";
        public DateTime Created { get; set; } = new DateTime();
        public DateTime Removed { get; set; } = new DateTime();
    }

    #endregion
    
    public enum UnitState{ None, Pass, Fail, Scrap, CheckIn }
    public enum UnitStatus{ None, Wip, WipHistory, Mama, WipMama, Scrap}

    public static class Converters
    {
        public static UnitState StringToUnitState(string unitState)
        {
            switch (unitState)
            {
                case "PASS" : return UnitState.Pass;
                case "P" : return UnitState.Pass;
                case "FAIL" : return UnitState.Fail;
                case "F" : return UnitState.Fail;
                case "SCRAP" : return UnitState.Scrap;
                case "S" : return UnitState.Scrap;
                case "CHACKIN" : return UnitState.CheckIn;
                case "C" : return UnitState.CheckIn;
            }
            return UnitState.None;
        }
        public static string UnitStateToString(UnitState unitState)
        {
            switch (unitState)
            {
                case UnitState.None: return "";
                case UnitState.Pass: return "PASS";
                case UnitState.Fail: return "FAIL";
                case UnitState.Scrap: return "SCRAP";
                case UnitState.CheckIn: return "CHACKIN";
                default: return "";
            }
        }
        public static UnitState ResArrayToUnitState(string res1, string res2, string res3, string res4)
        {
            if (res1 != "0") return UnitState.CheckIn;
            if (res2 != "0") return UnitState.Fail;
            if (res3 != "0") return UnitState.Pass;
            if (res4 != "0") return UnitState.Scrap;
            return UnitState.None;
        }
    }
}