using System;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using ContiCom.Workers;

namespace ContiCom
{
    public partial class AnalyseToolForm : Form
    {
        public AnalyseToolForm()
        {
            InitializeComponent();
        }

        private void searchBtn_Click(object sender, EventArgs e)
        {
            if(string.IsNullOrEmpty(searchTb.Text)) return;
            ContinentalDataBase.Connect();
            UnitData ud;
            ContinentalDataBase.GetUnit(searchTb.Text, out ud);
            searchTb.Text = "";
            wipDgw.Rows.Clear();
            evaDgw.Rows.Clear();
            buildInDgw.Rows.Clear();
            //dataGridView3.DataSource = dt;
            unitIdTb.Text = ud.UnitId;
            unitIdTypeTb.Text = ud.UnitIdType;
            preIdTb.Text = ud.PreUnitId;
            nxtIdTb.Text = ud.NextUnitId;
            materialTb.Text = ud.Material;
            descriptionTb.Text = ud.Description;
            carrierTb.Text = ud.CarrierId;
            orderTb.Text = ud.Order;
            orderTb.BackColor = ud.OrderTerminated ? Color.Orange : Color.LightGray;
            wipmamaTb.Text = ud.WipMama.ToString("G").ToUpper();
            wipmamaTb.BackColor = wipmamaTb.Text == "MAMA" ? Color.CornflowerBlue : wipmamaTb.Text == "WIPMAMA" ? Color.Orange : Color.LightGray;
            lockTb.Text = ud.LockText;
            if (ud.WipInfo.Count > 0)
            {
                wipStationTb.Text = ud.WipInfo[0].Equipment + @" - " + ud.WipInfo[0].StationDescription;
                wipDateTb.Text = ud.WipInfo[0].Updated.ToString("s").Replace("T"," ");
                wipResultTb.Text = Converters.UnitStateToString(ud.WipInfo[0].Result);
                switch (wipResultTb.Text)
                {
                    case "PASS": wipResultTb.BackColor = Color.LimeGreen; break;
                    case "FAIL": wipResultTb.BackColor = Color.Red; break;
                    case "CHECKIN": wipResultTb.BackColor = Color.CornflowerBlue; break;
                    default: wipResultTb.BackColor = Color.LightGray; break;
                }
            }
            else
            {
                wipStationTb.Text = "";
                wipDateTb.Text = "";
                wipResultTb.Text = "";
                wipResultTb.BackColor = Color.LightGray;
            }

            if (ud.EvaInfo.Count > 0)
            {
                evaStationTb.Text =ud.EvaInfo[0].TestPlanName  + @" - " + ud.EvaInfo[0].Station;
                evaDateTb.Text = ud.EvaInfo[0].DateTime.ToString("s").Replace("T"," ");
                evaResultTb.Text = Converters.UnitStateToString(ud.EvaInfo[0].Result);
                switch (evaResultTb.Text)
                {
                    case "PASS": evaResultTb.BackColor = Color.LimeGreen; break;
                    case "FAIL": evaResultTb.BackColor = Color.Red; break;
                    case "CHECKIN": evaResultTb.BackColor = Color.CornflowerBlue; break;
                    default: wipResultTb.BackColor = Color.LightGray; break;
                }
            }
            else
            {
                evaStationTb.Text = "";
                evaDateTb.Text = "";
                evaResultTb.Text = "";
                wipResultTb.BackColor = Color.DimGray;
            }
            
            ud.WipInfo.ForEach(wi =>
            {
                wipDgw.Rows.Add(wi.Updated.ToString("s").Replace("T"," "),wi.UnitIdType,wi.UnitId,
                    Converters.UnitStateToString(wi.Result),wi.Equipment);
                if (wi.Result == UnitState.Fail)
                {
                    wipDgw.Rows[wipDgw.Rows.Count-1].DefaultCellStyle = new DataGridViewCellStyle()
                        { BackColor = Color.Red, ForeColor = Color.White, SelectionForeColor = Color.Red};
                }
            });
            ud.EvaInfo.ForEach(ei =>
            {
                evaDgw.Rows.Add(ei.DateTime.ToString("s").Replace("T"," "), ei.UnitIdType, ei.Material,
                    Converters.UnitStateToString(ei.Result), ei.TestPlanName, ei.TestPlanVersion, ei.Station, ei.KeyPrt, ei.SeqKey);
                if (ei.Result == UnitState.Fail)
                {
                    evaDgw.Rows[evaDgw.Rows.Count-1].DefaultCellStyle = new DataGridViewCellStyle()
                        { BackColor = Color.Red, ForeColor = Color.White, SelectionForeColor = Color.Red};
                }
            });
            
            ud.BuildIn.ForEach(bi =>
            {
                buildInDgw.Rows.Add(bi.UnitId, bi.UnitIdType, "", bi.Removed.ToString("s").Replace("T", " "));
            });
            searchTb.Focus();
        }
        
        private void searchTb_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar != (char)Keys.Return) return;
            searchBtn_Click(searchBtn,EventArgs.Empty);
        }

        private void evaDgw_CellMouseDoubleClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            if(evaDgw.SelectedRows.Count < 0) return;
            ContinentalDataBase.Connect();
            var k = evaDgw.SelectedRows[0].Cells[7].Value.ToString();
            var s = evaDgw.SelectedRows[0].Cells[8].Value.ToString();
            ContinentalDataBase.GetEvaTestRunTextInfo(unitIdTb.Text,k,s,out var ti);
            ContinentalDataBase.GetEvaTestRun(unitIdTb.Text,k,s,out var etr);
            var tri = new TestRunInfo(etr,ti);
            tri.ShowDialog();
            tri.Dispose();
        }

        private void AnalyseToolForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            ContinentalDataBase.Dispose();
        }
    }
}