using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using ContiCom.Workers;

namespace ContiCom
{
    public partial class TestRunInfo : Form
    {
        public TestRunInfo(List<EvaTestInfo> testInfo, string textInfo)
        {
            InitializeComponent();
            testInfo.ForEach(eti =>
            {
                evaTestRunDgw.Rows.Add(eti.Sequence,eti.SubSequence,eti.Id,eti.Description,eti.Value.ToString(),eti.Result,eti.MinValue,eti.MaxValue,eti.ValueType);
                if (eti.Result == UnitState.Fail)
                {
                    evaTestRunDgw.Rows[evaTestRunDgw.Rows.Count-1].DefaultCellStyle = new DataGridViewCellStyle()
                        { BackColor = Color.Red, ForeColor = Color.White, SelectionForeColor = Color.Red};
                }
            });
            textInfoTb.Text = textInfo.Replace("<br>", Environment.NewLine);
        }
    }
}