﻿using System;
using System.Runtime.InteropServices;
using System.Windows;
using System.Windows.Input;
using System.Windows.Interop;

namespace ContiComGuiWpf
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private bool _isDragging = false;
        private Point _startPoint;
        
        public MainWindow()
        {
            InitializeComponent();
        }

        // Minimalizálás
        private void Minimize_Click(object sender, RoutedEventArgs e)
        {
            this.WindowState = WindowState.Minimized;
        }

        // Maximalizálás és visszaállítás közötti váltás
        private void Maximize_Click(object sender, RoutedEventArgs e)
        {
            ToggleWindowState();
        }

        // Bezárás
        private void Close_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        // Segéd függvény a maximális és normál állapot közötti váltáshoz
        private void ToggleWindowState()
        {
            if (this.WindowState == WindowState.Maximized)
            {
                this.WindowState = WindowState.Normal;
            }
            else
            {
                this.WindowState = WindowState.Maximized;
            }
        }
        public void Window_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            if (this.WindowState == WindowState.Maximized)
            {
                this.BorderThickness = new System.Windows.Thickness(8);
                this.MaximizeBtn.Content = "\ue923";
            }
            else
            {
                this.BorderThickness = new System.Windows.Thickness(0);
                this.MaximizeBtn.Content = "\ue739";
            }
        }
    }
}