using System;
using System.Runtime.InteropServices;
using System.Text;

namespace MesUserPassTest
{
    internal static class Native
  {
    [DllImport("UA.dll")]
    internal static extern short ua_Init();

    [DllImport("UA.dll")]
    internal static extern IntPtr ua_GetVersion();

    [DllImport("UA.dll")]
    internal static extern short ua_SetFraMESCfgPath(string szPath);

    [DllImport("UA.dll")]
    internal static extern short ua_GetErrorCode();

    [DllImport("UA.dll")]
    internal static extern IntPtr ua_GetErrorText(short sErrorCode);

    [DllImport("UA.dll")]
    internal static extern void ua_GetLastCapsError(out short sWCErrorCode, out short sWCApplError);

    [DllImport("UA.dll")]
    internal static extern void ua_SetLogLevel(short sLogLevel);

    [DllImport("UA.dll")]
    internal static extern void ua_SetLogDest(string szLogDest);

    [DllImport("UA.dll")]
    internal static extern short ua_GetErrorInformation(
      out IntPtr szErrorText,
      out IntPtr szFunctionName,
      out IntPtr szErrorHint,
      out IntPtr szCapsError);

    [DllImport("UA.dll")]
    internal static extern IntPtr ua_GetCfg(string szKey, short boShowError);

    [DllImport("UA.dll")]
    internal static extern short ua_SetApplicationName(string szApplicationName);

    [DllImport("UA.dll")]
    internal static extern short ua_UserLogin(
      string szUserName,
      string szPassword,
      out int lDefaultDiv);

    [DllImport("UA.dll")]
    internal static extern short ua_UserLogout();

    [DllImport("UA.dll")]
    internal static extern short ua_ChangePassword(
      string szUserName,
      string szOldPassword,
      string szNewPassword);

    [DllImport("UA.dll")]
    internal static extern short ua_CheckPermission(
      string szPermObject,
      string szPermSymbol,
      int lDivision);

    [DllImport("UA.dll")]
    internal static extern short ua_GetUsersPermissions2(
      out short sPermCnt,
      out IntPtr pPermissions);

    [DllImport("UA.dll")]
    internal static extern short ua_GetUserDescr(string szUserName, StringBuilder szDescription);

    [DllImport("UA.dll")]
    internal static extern short ua_GetUserGroups(out short sCount, out IntPtr pGroups);

    [DllImport("UA.dll")]
    internal static extern short ua_GetAllDivisions(out short sCount, out IntPtr pDivisions);
  }
}