﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace ScreenUpdater
{
    internal class Program
    {
        // API a konzolablak elrejtéséhez
        [DllImport("kernel32.dll")]
        private static extern IntPtr GetConsoleWindow();

        [DllImport("user32.dll")]
        private static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);

        private const int SW_HIDE = 0; // Ablak elrejtése
        private const int SW_SHOW = 5; // Ablak mutatása

        // API az energiaállapot módosításához
        [DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        private static extern uint SetThreadExecutionState(uint esFlags);

        private const uint ES_CONTINUOUS = 0x80000000;
        private const uint ES_DISPLAY_REQUIRED = 0x00000002;
        private const uint ES_SYSTEM_REQUIRED = 0x00000001;

        private static bool isEnabled = true;
        private static NotifyIcon trayIcon;

        static void Main()
        {
            // Elrejtjük a konzolablakot
            IntPtr handle = GetConsoleWindow();
            ShowWindow(handle, SW_HIDE);

            // Létrehozzuk a tálcán megjelenő ikont
            trayIcon = new NotifyIcon
            {
                Icon = SystemIcons.Application, // Használhatod saját ikont is
                Visible = true,
                Text = "Képernyővédő gátló"
            };

            // Kontextusmenü létrehozása
            var menu = new ContextMenuStrip();
            var toggleItem = new ToolStripMenuItem("Képernyővédő: Bekapcsolva", null, ToggleAction);
            var exitItem = new ToolStripMenuItem("Kilépés", null, ExitApplication);

            menu.Items.Add(toggleItem);
            menu.Items.Add(exitItem);

            trayIcon.ContextMenuStrip = menu;

            // Aktiváljuk az első indításkor a képernyővédő tiltását
            SetThreadExecutionState(ES_CONTINUOUS | ES_DISPLAY_REQUIRED | ES_SYSTEM_REQUIRED);
            trayIcon.ShowBalloonTip(3000,"Képernyővédő gátló","Bekapcsolva",ToolTipIcon.Info);

            // Üzenetkezelő hurok a tálcaikonhoz
            Application.Run();
        }

        private static void ToggleAction(object sender, EventArgs e)
        {
            isEnabled = !isEnabled;

            if (isEnabled)
            {
                SetThreadExecutionState(ES_CONTINUOUS | ES_DISPLAY_REQUIRED | ES_SYSTEM_REQUIRED);
                trayIcon.ContextMenuStrip.Items[0].Text = "Képernyővédő: Bekapcsolva";
                trayIcon.ShowBalloonTip(1000,"Képernyővédő gátló","Bekapcsolva",ToolTipIcon.Info);
            }
            else
            {
                SetThreadExecutionState(ES_CONTINUOUS);
                trayIcon.ContextMenuStrip.Items[0].Text = "Képernyővédő: Kikapcsolva";
                trayIcon.ShowBalloonTip(1000,"Képernyővédő gátló","Kikapcsolva",ToolTipIcon.Info);
            }
        }

        private static void ExitApplication(object sender, EventArgs e)
        {
            // Visszaállítjuk az eredeti állapotot és kilépünk
            SetThreadExecutionState(ES_CONTINUOUS);
            trayIcon.Visible = false;
            Application.Exit();
        }
    }
}