create package body backflush_corrections as
	function Disassembly(material in varchar2,ordernum in varchar2,quantity in number,unitidtype in varchar2,unitid in varchar2)  return integer is	
		selected_material backflush_correction%ROWTYPE;
		selected_unit backflush_corr_units%ROWTYPE;		
		cursor select_material(p1 in varchar2) is select * from backflush_correction where material = p1;
		cursor select_unit(p1 in varchar2,p2 in varchar2) is select * from backflush_corr_units where unitid = p1 and unitidtype = p2;		
	begin
		open select_material(material);
    fetch select_material into selected_material;
    if select_material%NOTFOUND then
      close select_material;
      insert into backflush_correction(material,difference_qty,last_report_id) values (material,(-1)*quantity,null);
      commit;
      open select_material(material);
        fetch select_material into selected_material;
      close select_material;
    else
      close select_material;
      update backflush_correction set difference_qty = (selected_material.difference_qty - quantity) where id = selected_material.id;
      commit;
    end if;    
		open select_unit(unitid,unitidtype);
		loop
			fetch select_unit into selected_unit;
      exit when select_unit%NOTFOUND;
			delete from backflush_corr_units where id = selected_unit.id;
		end loop;
		close select_unit;		
		insert into backflush_corr_units(unitid,unitidtype,material_id,ordernum) values(unitid,unitidtype,selected_material.id,ordernum);
		commit;
		return 0;
		exception when others then
			return 1;
	end Disassembly;
	
	function Backflush(material in varchar2,ordernum in varchar2,quantity in number,unitidtype in varchar2,unitid in varchar2) return integer is	
		selected_unit backflush_corr_units%ROWTYPE;
		selected_material backflush_correction%ROWTYPE;
		cursor select_material(p1 in number) is select * from backflush_correction where id = p1;
		cursor select_unit(p1 in varchar2,p2 in varchar2) is select * from backflush_corr_units where unitid = p1 and unitidtype = p2;		
	begin
		open select_unit(unitid,unitidtype);
    fetch select_unit into selected_unit;		
		if select_unit%NOTFOUND then
      close select_unit;
      return 2;
    else
      close select_unit;
      open select_material(selected_unit.material_id);
        fetch select_material into selected_material;
      close select_material;    
			if selected_material.material = material then
				if selected_unit.ordernum = ordernum then
					update backflush_correction set difference_qty = (selected_material.difference_qty + quantity) where id = selected_material.id;					
					delete from backflush_corr_units where id = selected_unit.id;
					commit;
				end if;
			end if;
		end if;
		return 0;
		exception when others then
			return 1;
	end Backflush;
	
	function Report(material in varchar2,update_user in varchar2) return integer is
	selected_material backflush_correction%ROWTYPE;
	maxrepid number;
	cursor select_material(p1 in varchar2) is select * from backflush_correction where material = p1;
	cursor select_max_repid is select max(id) from backflush_corr_report;
	begin
		open select_material(material);
			fetch select_material into selected_material;
		close select_material;
		insert into backflush_corr_report(material_id,report_date,report_user,report_from_id,corr_quantity) values(selected_material.id,sysdate,update_user,selected_material.last_report_id,selected_material.difference_qty);
		commit;
		open select_max_repid;
			fetch select_max_repid into maxrepid;
		close select_max_repid;
    update backflush_correction set difference_qty = 0,last_report_id = maxrepid where id = selected_material.id;
		commit;
		return selected_material.difference_qty;
		exception when others then
			return -1;
	end Report;
  
  function ActualReport(material in varchar2) return integer is
	selected_material backflush_correction%ROWTYPE;	
	cursor select_material(p1 in varchar2) is select * from backflush_correction where material = p1;	
	begin
		open select_material(material);
			fetch select_material into selected_material;
		close select_material;
		return selected_material.difference_qty;
		exception when others then
			return -1;
	end ActualReport;  
  
  function FromReport(material in varchar2,fromdate in date) return integer is
	selected_material backflush_correction%ROWTYPE;	
  selected_history backflush_corr_report%ROWTYPE;	
  endresult number;
	cursor select_material(p1 in varchar2) is select * from backflush_correction where material = p1;	
  cursor select_history(p1 in varchar2,p2 in date) is select * from backflush_corr_report where material = p1 and report_date > p2;	
	begin
    endresult := 0;
		open select_material(material);
			fetch select_material into selected_material;
		close select_material;
    open select_history(material,fromdate);
    loop
      fetch select_history into selected_history;
      exit when select_history%NOTFOUND;
      endresult := endresult + selected_history.corr_quantity;
    end loop;
    close select_history;
		endresult := endresult + selected_material.difference_qty;
    return endresult;
		exception when others then
			return -1;  
  end FromReport;
  
end backflush_corrections;
/

