create package body smtjidoka as
function checkjidoka(head IN headers) return integer is
  fifoID NUMBER;
  CURSOR fifoID_cursor IS SELECT smtjido_fifo_seq.currval from dual;  
  --CURSOR fifoID_cursor IS SELECT max(id) from smtjid_fifo;  
begin
  for i in 1..head.count LOOP
    insert into smtjid_fifo (  
    PRODUCT_FAMILY,
    LINE,
    MASTER_BC,
    POSITION,
    CREATED,
    INSP_TYPE,
    MACHINE_TYPE,
    MATERIAL,
    SUBUNIT_ID,
    ID_TYPE) values( 
    head(i).head.PRODUCT_FAMILY,
    head(i).head.LINE,
    head(i).head.MASTER_BC,
    head(i).head.POSITION,
    sysdate,
    head(i).head.INSP_TYPE,
    head(i).head.MACHINE_TYPE,
    head(i).head.MATERIAL,
    head(i).head.SUBUNIT_ID,
    head(i).head.ID_TYPE);  
    --commit;
    open fifoID_cursor;
    fetch fifoID_cursor into fifoID;
    close fifoID_cursor;
    for j in 1..head(i).errors.count LOOP
      insert into smtjid_errors (
      FIFO_ID,
      ALGORYTHM,
      POSITION,
      FAILURE,
      FULL_ERROR) values(
      fifoID,
      head(i).errors(j).ALGORYTHM,
      head(i).errors(j).POSITION,
      head(i).errors(j).FAILURE,
      head(i).errors(j).FULL_ERROR);
    end loop;
  end loop;
  commit;  
  RETURN 1;
  EXCEPTION WHEN OTHERS THEN
    ROLLBACK;
  RETURN 0;
end checkjidoka;

function checkViolations(line in varchar2,productFamily in varchar2) return integer is
  CURSOR rule_cursor(p1 in varchar2) IS SELECT * from smtjid_config where product_family = p1;
  CURSOR fifo_cursor(p1 in varchar2, p2 in varchar2, p3 in number) IS SELECT * from smtjid_fifo where product_family = p1 and line = p2 and rownum < p3;
  CURSOR error_cursor(p1 in number) IS SELECT * from smtjid_errors where fifo_id = p1;
  rulec_res smtjid_config%rowtype;
  --rulec_res_tab table smtjid_config%rowtype;
  fifoc_res smtjid_fifo%rowtype;
  errorc_res smtjid_errors%rowtype;
  max_interval number := 0;
  --type fifoidtype is table of number;
  type ruleTemp is record
  (
    ruleid number,
    fail_reason varchar2(200),
    fail_count number,
    fail_mb_count number,
    fifo_ids fifoid_type
  );
  type ruleTempList is table of ruleTemp;
  ruleList ruleTempList  :=ruleTempList();
  fifocount number := 0;
  fifodate date := sysdate;
  riportrule_date date := sysdate;
  ruleinrecord_a number := 0;
  ruleinrecord_f number := 0;
  ruleinrecord_p number := 0;
  ruleinrecord_c number := 0;
  ruleinrecord number := 0;
  recordthesame number := 0;
  sendresult integer := 0;
begin  
  select max(interval) into max_interval from smtjid_config where product_family = productfamily; --select maximal interval for loop  
  open fifo_cursor(productfamily,line,max_interval); -- fetch fifo rows for rules
  loop
    fetch fifo_cursor into fifoc_res;
    for j in 1..ruleList.count loop
      ruleList(j).fail_mb_count := 0;
    end loop;
    exit when fifoc_res.created < fifodate-(1/24);  --exit if last step board over one hour
    open rule_cursor(productFamily);  --fetch rules for check violation
    loop
      FETCH rule_cursor INTO rulec_res;
      begin
        select created into riportrule_date from smtjid_riport where line = fifoc_res.line and product_family = rulec_res.product_family and error_type = rulec_res.error_cause;
        exception 
          when NO_DATA_FOUND then riportrule_date := sysdate;
      end;
      if fifoc_res.insp_type = rulec_res.insp_type and fifoc_res.machine_type = rulec_res.machine_type and (riportrule_date + (1/96)) < fifoc_res.created and fifocount <= rulec_res.interval then
        open error_cursor(fifoc_res.id);
        loop
          fetch error_cursor into errorc_res;
            for i in 1..ruleList.count loop
              if ruleList(i).ruleid = rulec_res.id then
                ruleinrecord := 1;                
                if (rulec_res.error_cause= 'POSITION' and errorc_res.position= ruleList(i).fail_reason) then
                  if ruleList(i).fail_mb_count = 0 then
                    ruleList(i).fifo_ids.extend(1,fifoc_res.id);
                  end if;
                  if (rulec_res.errorcount -1) <> ruleList(i).fail_mb_count then
                    ruleList(i).fail_count := ruleList(i).fail_count+1;
                    ruleList(i).fail_mb_count := ruleList(i).fail_mb_count+1;
                    if rulec_res.errorcount = ruleList(i).fail_count then
                      sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                    end if;
                  end if;                  
                  ruleinrecord_p := 1;
                elsif (rulec_res.error_cause = 'ALGORYTHM' and errorc_res.algorythm= ruleList(i).fail_reason) then
                  if ruleList(i).fail_mb_count = 0 then
                    ruleList(i).fifo_ids.extend(1,fifoc_res.id);
                  end if;                
                  if (rulec_res.errorcount -1) <> ruleList(i).fail_mb_count then
                    ruleList(i).fail_count := ruleList(i).fail_count+1;
                    ruleList(i).fail_mb_count := ruleList(i).fail_mb_count+1;
                    if rulec_res.errorcount = ruleList(i).fail_count then
                      sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                    end if;                    
                  end if;
                  ruleinrecord_a := 1;
                elsif (rulec_res.error_cause= 'FAILURE' and errorc_res.failure= ruleList(i).fail_reason) then
                  if ruleList(i).fail_mb_count = 0 then
                    ruleList(i).fifo_ids.extend(1,fifoc_res.id);
                  end if;                
                  if (rulec_res.errorcount -1) <> ruleList(i).fail_mb_count then
                    ruleList(i).fail_count := ruleList(i).fail_count+1;
                    ruleList(i).fail_mb_count := ruleList(i).fail_mb_count+1;
                    if rulec_res.errorcount = ruleList(i).fail_count then
                      sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                    end if;                    
                  end if;
                  ruleinrecord_f := 1;
                elsif (errorc_res.full_error like('%'|| ruleList(i).fail_reason || '%') and ruleList(i).fail_reason = rulec_res.error_cause) then
                  if ruleList(i).fail_mb_count = 0 then
                    ruleList(i).fifo_ids.extend(1,fifoc_res.id);
                  end if;                
                  if (rulec_res.errorcount -1) <> ruleList(i).fail_mb_count then
                    ruleList(i).fail_count := ruleList(i).fail_count+1;
                    ruleList(i).fail_mb_count := ruleList(i).fail_mb_count+1;
                    if rulec_res.errorcount = ruleList(i).fail_count then
                      sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                    end if;                    
                  end if;
                  ruleinrecord_c := 1;
                end if;                            
              end if;
            end loop;            
            if ruleinrecord = 0 then             
             if rulec_res.error_cause= 'POSITION' then
              ruleList.extend(1);
              ruleList(ruleList.count).ruleid := rulec_res.id;
              ruleList(ruleList.count).fail_reason := errorc_res.position;
              ruleList(ruleList.count).fail_count := 1;                 
              ruleList(ruleList.count).fail_mb_count := 1;                  
              ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);                  
              if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
              end if;              
             elsif rulec_res.error_cause = 'ALGORYTHM' then
              ruleList.extend(1);
              ruleList(ruleList.count).ruleid := rulec_res.id;
              ruleList(ruleList.count).fail_reason := errorc_res.algorythm;
              ruleList(ruleList.count).fail_count := 1;    
              ruleList(ruleList.count).fail_mb_count := 1;
              ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);
              if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
              end if;              
             elsif rulec_res.error_cause = 'FAILURE' then
              ruleList.extend(1);
              ruleList(ruleList.count).ruleid := rulec_res.id;
              ruleList(ruleList.count).fail_reason := errorc_res.failure;
              ruleList(ruleList.count).fail_count := 1;    
              ruleList(ruleList.count).fail_mb_count := 1;
              ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);
              if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
              end if;              
             elsif errorc_res.full_error like('%' || rulec_res.error_cause || '%') then
              ruleList.extend(1);
              ruleList(ruleList.count).ruleid := rulec_res.id;
              ruleList(ruleList.count).fail_reason := rulec_res.error_cause;
              ruleList(ruleList.count).fail_count := 1;    
              ruleList(ruleList.count).fail_mb_count := 1;
              ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);
              if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
              end if;              
             end if;
            else             
              if rulec_res.error_cause = 'POSITION' and ruleinrecord_p = 0 then
                ruleList.extend(1);
                ruleList(ruleList.count).ruleid := rulec_res.id;
                ruleList(ruleList.count).fail_reason := errorc_res.position;
                ruleList(ruleList.count).fail_count := 1;
                ruleList(ruleList.count).fail_mb_count := 1;
                ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);
                if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                  sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                end if;
              elsif (rulec_res.error_cause= 'ALGORYTHM' and ruleinrecord_a = 0) then
                ruleList.extend(1);
                ruleList(ruleList.count).ruleid := rulec_res.id;
                ruleList(ruleList.count).fail_reason := errorc_res.algorythm;
                ruleList(ruleList.count).fail_count := 1;
                ruleList(ruleList.count).fail_mb_count := 1;
                ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);
                if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                  sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                end if;                
              elsif (rulec_res.error_cause= 'FAILURE' and ruleinrecord_f = 0) then
                ruleList.extend(1);
                ruleList(ruleList.count).ruleid := rulec_res.id;
                ruleList(ruleList.count).fail_reason := errorc_res.failure;
                ruleList(ruleList.count).fail_count := 1;
                ruleList(ruleList.count).fail_mb_count := 1;
                ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);
                if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                  sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                end if;                
              elsif (errorc_res.full_error like('%'|| rulec_res.error_cause || '%') and ruleinrecord_c = 0) then
                ruleList.extend(1);
                ruleList(ruleList.count).ruleid := rulec_res.id;
                ruleList(ruleList.count).fail_reason := rulec_res.error_cause;
                ruleList(ruleList.count).fail_count := 1; 
                ruleList(ruleList.count).fail_mb_count := 1;
                ruleList(ruleList.count).fifo_ids.extend(1,fifoc_res.id);
                if rulec_res.errorcount = ruleList(ruleList.count).fail_count then
                  sendresult := sendviolation(rulec_res.id,fifoc_res.master_bc,fifoc_res.id_type,fifoc_res.product_family,fifoc_res.line,fifoc_res.insp_type,fifoc_res.machine_type,rulec_res.error_cause,ruleList(ruleList.count).fail_reason, fifoc_res.material, ruleList(ruleList.count).fifo_ids);
                end if;                
              end if;
              ruleinrecord_a := 0;
              ruleinrecord_f := 0;
              ruleinrecord_p := 0;
              ruleinrecord_c := 0;
            end if;
            ruleinrecord := 0;
          exit when error_cursor%NOTFOUND;
        end loop;
        close error_cursor;
        --if statement is true evaluation can start
      end if;      
      EXIT WHEN rule_cursor%NOTFOUND;
    end loop;  
    close rule_cursor;
    fifodate := fifoc_res.created; --store last  
    fifocount := fifocount + 1;
    exit when fifo_cursor%NOTFOUND;  
  end loop;
  close fifo_cursor;
  return 0;
  -- end fetch
end checkViolations;

function SendViolation(ruleid in number,masterbc in varchar2,idtype in varchar2,productfamily in varchar2, line in varchar2,insptype in varchar2,machinetype in varchar2,errortype in varchar2,errorcause in varchar2, material in varchar2, fifoids in fifoid_type) return number is
--  c  utl_tcp.connection;  -- TCP/IP connection to the Web server
  ret_val pls_integer; 
  tcpstring varchar2(10000);
begin
  insert into smtjid_riport
  (PRODUCT_FAMILY,
  LINE,
  MASTER_BC,
  INSP_TYPE,
  MACHINE_TYPE,
  RULE,
  COMMENTER,
  CREATED,
  ERROR_TYPE,
  ID_TYPE)
  values(productfamily,line,masterbc,insptype,machinetype,errorcause,null,sysdate,errortype,idtype);
  commit;
--  c := utl_tcp.open_connection(remote_host => 'BUD6ZG0G.auto.contiwan.com',
  --                             remote_port =>  8888,
 --                              charset     => 'US7ASCII');  -- open connection
  tcpstring := tcpstring || line  || ';' || productfamily || ';' || material || ';' || insptype || ';' || machinetype || ';' || errorcause || ';' || errortype || ';' || masterbc || ';' || idtype || ';';
  for i in 1..fifoids.count loop
    tcpstring := tcpstring || fifoids(i) || ':';
  end loop;  
--  ret_val := utl_tcp.write_line(c, tcpstring);    -- send HTTP request
  --ret_val := utl_tcp.write_line(c);
--  utl_tcp.close_connection(c);
  return 0;
end SendViolation;
end smtjidoka;
/

